/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.issue;

import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.module.org_alfresco_module_rm.vital.VitalRecordDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class RM994Test
extends BaseRMTestCase {
    @Override
    protected void initServices() {
        super.initServices();
    }

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected boolean isRecordTest() {
        return true;
    }

    public void testRM944() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RM994Test.this.checkVitalRecordNotSet(RM994Test.this.rmContainer);
                RM994Test.this.checkVitalRecordNotSet(RM994Test.this.rmFolder);
                RM994Test.this.checkVitalRecordNotSet(RM994Test.this.recordOne);
                TestCase.assertNull((Object)RM994Test.this.nodeService.getProperty(RM994Test.this.recordOne, RecordsManagementModel.PROP_REVIEW_AS_OF));
                RM994Test.this.vitalRecordService.setVitalRecordDefintion(RM994Test.this.rmContainer, true, new Period("month|1"));
                return null;
            }
        });
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                RM994Test.this.checkVitalRecordSet(RM994Test.this.rmContainer);
                RM994Test.this.checkVitalRecordSet(RM994Test.this.rmFolder);
                RM994Test.this.checkVitalRecordSet(RM994Test.this.recordOne);
                TestCase.assertNotNull((Object)RM994Test.this.nodeService.getProperty(RM994Test.this.recordOne, RecordsManagementModel.PROP_REVIEW_AS_OF));
                RM994Test.this.recordService.createRecord(RM994Test.this.filePlan, RM994Test.this.dmDocument, true);
                TestCase.assertTrue((boolean)RM994Test.this.recordService.isRecord(RM994Test.this.dmDocument));
                RM994Test.this.checkVitalRecordNotSet(RM994Test.this.dmDocument);
                RM994Test.this.fileFolderService.move(RM994Test.this.dmDocument, RM994Test.this.rmFolder, null);
                RM994Test.this.checkVitalRecordSet(RM994Test.this.dmDocument);
                return null;
            }
        }, "admin");
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                RM994Test.this.checkVitalRecordSet(RM994Test.this.dmDocument);
                return null;
            }
        });
    }

    private void checkVitalRecordSet(NodeRef nodeRef) {
        VitalRecordDefinition def = this.vitalRecordService.getVitalRecordDefinition(nodeRef);
        RM994Test.assertNotNull((Object)def);
        RM994Test.assertTrue((boolean)def.isEnabled());
        RM994Test.assertEquals((String)"month", (String)def.getReviewPeriod().getPeriodType());
        RM994Test.assertEquals((String)"1", (String)def.getReviewPeriod().getExpression());
    }

    private void checkVitalRecordNotSet(NodeRef nodeRef) {
        VitalRecordDefinition recordDef = this.vitalRecordService.getVitalRecordDefinition(nodeRef);
        if (recordDef != null) {
            RM994Test.assertFalse((boolean)recordDef.isEnabled());
            RM994Test.assertEquals((String)"none", (String)recordDef.getReviewPeriod().getPeriodType());
            RM994Test.assertNull((Object)recordDef.getNextReviewDate());
        }
    }
}

