/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.transfer;

import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.util.GUID;

public class ReadPermissionsOnTransferFolderTest
extends BaseRMTestCase {
    private String testUser1 = null;
    private String testUser2 = null;

    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected void setupTestUsersImpl(NodeRef filePlan) {
        super.setupTestUsersImpl(filePlan);
        this.testUser1 = GUID.generate();
        this.createPerson(this.testUser1);
        this.testUser2 = GUID.generate();
        this.createPerson(this.testUser2);
        this.siteService.setMembership(this.siteId, this.testUser1, "SiteConsumer");
        this.siteService.setMembership(this.siteId, this.testUser2, "SiteConsumer");
        this.filePlanRoleService.assignRoleToAuthority(filePlan, "RecordsManager", this.testUser1);
        this.filePlanRoleService.assignRoleToAuthority(filePlan, "RecordsManager", this.testUser2);
    }

    public void testReadPermissionsOnTransferFolder() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.testUser1){
            private NodeRef recordsFolder;
            private NodeRef transferFolder;
            {
                this.recordsFolder = null;
                this.transferFolder = null;
            }

            @Override
            public void given() {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() {
                        NodeRef category = ReadPermissionsOnTransferFolderTest.this.filePlanService.createRecordCategory(ReadPermissionsOnTransferFolderTest.this.filePlan, GUID.generate());
                        ReadPermissionsOnTransferFolderTest.this.filePlanPermissionService.setPermission(category, ReadPermissionsOnTransferFolderTest.this.testUser1, "Filing");
                        ReadPermissionsOnTransferFolderTest.this.filePlanPermissionService.setPermission(category, ReadPermissionsOnTransferFolderTest.this.testUser2, "Filing");
                        ReadPermissionsOnTransferFolderTest.this.utils.createDispositionSchedule(category, "disposition instructions", "disposition authority", false, true, true);
                        recordsFolder = ReadPermissionsOnTransferFolderTest.this.recordFolderService.createRecordFolder(category, GUID.generate());
                        HashMap<String, String> params = new HashMap<String, String>(1);
                        params.put("eventName", "case_closed");
                        ReadPermissionsOnTransferFolderTest.this.rmActionService.executeRecordsManagementAction(recordsFolder, "completeEvent", params);
                        ReadPermissionsOnTransferFolderTest.this.rmActionService.executeRecordsManagementAction(recordsFolder, "cutoff");
                        return null;
                    }
                }, (String)AuthenticationUtil.getAdminUserName());
                this.transferFolder = (NodeRef)ReadPermissionsOnTransferFolderTest.this.rmActionService.executeRecordsManagementAction(this.recordsFolder, "transfer").getValue();
            }

            @Override
            public void when() {
                ReadPermissionsOnTransferFolderTest.this.filePlanPermissionService.setPermission(this.transferFolder, ReadPermissionsOnTransferFolderTest.this.testUser2, "ReadRecords");
            }

            @Override
            public void then() {
                TestCase.assertNotNull((Object)this.transferFolder);
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)ReadPermissionsOnTransferFolderTest.this.permissionService.hasPermission(ReadPermissionsOnTransferFolderTest.this.transfersContainer, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)ReadPermissionsOnTransferFolderTest.this.permissionService.hasPermission(this.transferFolder, "Filing"));
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() {
                        TestCase.assertNotNull((Object)transferFolder);
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)ReadPermissionsOnTransferFolderTest.this.permissionService.hasPermission(ReadPermissionsOnTransferFolderTest.this.transfersContainer, "ReadRecords"));
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)ReadPermissionsOnTransferFolderTest.this.permissionService.hasPermission(transferFolder, "ReadRecords"));
                        TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)ReadPermissionsOnTransferFolderTest.this.permissionService.hasPermission(transferFolder, "Filing"));
                        try {
                            ReadPermissionsOnTransferFolderTest.this.rmActionService.executeRecordsManagementAction(transferFolder, "transferComplete");
                        }
                        catch (AccessDeniedException accessDeniedException) {
                            // empty catch block
                        }
                        return null;
                    }
                }, (String)ReadPermissionsOnTransferFolderTest.this.testUser2);
            }
        });
    }
}

