/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.version;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.relationship.Relationship;
import org.alfresco.module.org_alfresco_module_rm.test.integration.version.RecordableVersionsBaseTest;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionModel;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionPolicy;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;

public class DeleteRecordVersionTest
extends RecordableVersionsBaseTest {
    public void testDeleteFirstRecordedVersion() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef myDocument;

            @Override
            public void given() throws Exception {
                this.myDocument = DeleteRecordVersionTest.this.fileFolderService.create(DeleteRecordVersionTest.this.dmFolder, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
                HashMap<QName, Object> props = new HashMap<QName, Object>(2);
                props.put(RecordableVersionModel.PROP_RECORDABLE_VERSION_POLICY, RecordableVersionPolicy.ALL);
                props.put(RecordableVersionModel.PROP_FILE_PLAN, DeleteRecordVersionTest.this.filePlan);
                DeleteRecordVersionTest.this.nodeService.addAspect(this.myDocument, RecordableVersionModel.ASPECT_VERSIONABLE, props);
                DeleteRecordVersionTest.this.nodeService.addAspect(this.myDocument, ContentModel.ASPECT_VERSIONABLE, null);
            }

            @Override
            public void when() {
                TestCase.assertEquals((Object)"1.0", (Object)DeleteRecordVersionTest.this.nodeService.getProperty(this.myDocument, ContentModel.PROP_VERSION_LABEL));
                VersionHistory versionHistory = DeleteRecordVersionTest.this.versionService.getVersionHistory(this.myDocument);
                TestCase.assertNotNull((Object)versionHistory);
                TestCase.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                Version head = versionHistory.getHeadVersion();
                TestCase.assertNotNull((Object)head);
                TestCase.assertFalse((boolean)DeleteRecordVersionTest.this.recordableVersionService.isRecordedVersionDestroyed(head));
                NodeRef record = DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(head);
                TestCase.assertTrue((boolean)DeleteRecordVersionTest.this.recordService.isRecord(record));
                TestCase.assertFalse((boolean)DeleteRecordVersionTest.this.nodeService.hasAspect(record, ContentModel.ASPECT_VERSIONABLE));
                VersionHistory recordVersionHistory = DeleteRecordVersionTest.this.versionService.getVersionHistory(record);
                TestCase.assertNull((Object)recordVersionHistory);
                DeleteRecordVersionTest.this.nodeService.deleteNode(record);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)DeleteRecordVersionTest.this.nodeService.hasAspect(this.myDocument, ContentModel.ASPECT_VERSIONABLE));
                TestCase.assertEquals((Object)"1.0", (Object)DeleteRecordVersionTest.this.nodeService.getProperty(this.myDocument, ContentModel.PROP_VERSION_LABEL));
                VersionHistory versionHistory = DeleteRecordVersionTest.this.versionService.getVersionHistory(this.myDocument);
                TestCase.assertNotNull((Object)versionHistory);
                TestCase.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                Version version = versionHistory.getHeadVersion();
                TestCase.assertNotNull((Object)version);
                TestCase.assertTrue((boolean)DeleteRecordVersionTest.this.recordableVersionService.isRecordedVersionDestroyed(version));
                TestCase.assertNull((Object)DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(version));
            }
        });
    }

    public void testDeleteFirstRecordedVersionAndCreateNewVersion() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef myDocument;

            @Override
            public void given() throws Exception {
                this.myDocument = DeleteRecordVersionTest.this.fileFolderService.create(DeleteRecordVersionTest.this.dmFolder, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
                ContentWriter writer = DeleteRecordVersionTest.this.fileFolderService.getWriter(this.myDocument);
                writer.setEncoding("UTF-8");
                writer.setMimetype("text/plain");
                writer.putContent(GUID.generate());
                HashMap<QName, Object> props = new HashMap<QName, Object>(2);
                props.put(RecordableVersionModel.PROP_RECORDABLE_VERSION_POLICY, RecordableVersionPolicy.ALL);
                props.put(RecordableVersionModel.PROP_FILE_PLAN, DeleteRecordVersionTest.this.filePlan);
                DeleteRecordVersionTest.this.nodeService.addAspect(this.myDocument, RecordableVersionModel.ASPECT_VERSIONABLE, props);
                DeleteRecordVersionTest.this.nodeService.addAspect(this.myDocument, ContentModel.ASPECT_VERSIONABLE, null);
            }

            @Override
            public void when() {
                VersionHistory versionHistory = DeleteRecordVersionTest.this.versionService.getVersionHistory(this.myDocument);
                Version head = versionHistory.getHeadVersion();
                NodeRef record = DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(head);
                DeleteRecordVersionTest.this.nodeService.deleteNode(record);
                ContentWriter writer = DeleteRecordVersionTest.this.fileFolderService.getWriter(this.myDocument);
                writer.putContent(GUID.generate());
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)DeleteRecordVersionTest.this.nodeService.hasAspect(this.myDocument, ContentModel.ASPECT_VERSIONABLE));
                TestCase.assertEquals((Object)"1.1", (Object)DeleteRecordVersionTest.this.nodeService.getProperty(this.myDocument, ContentModel.PROP_VERSION_LABEL));
                VersionHistory versionHistory = DeleteRecordVersionTest.this.versionService.getVersionHistory(this.myDocument);
                TestCase.assertNotNull((Object)versionHistory);
                TestCase.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
                Version head = versionHistory.getHeadVersion();
                TestCase.assertFalse((boolean)DeleteRecordVersionTest.this.recordableVersionService.isRecordedVersionDestroyed(head));
                TestCase.assertNotNull((Object)DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(head));
                Version destroyed = versionHistory.getPredecessor(head);
                TestCase.assertTrue((boolean)DeleteRecordVersionTest.this.recordableVersionService.isRecordedVersionDestroyed(destroyed));
                TestCase.assertNull((Object)DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(destroyed));
                NodeRef versionRecord = DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(head);
                TestCase.assertNotNull((Object)versionRecord);
                TestCase.assertTrue((boolean)DeleteRecordVersionTest.this.nodeService.exists(versionRecord));
                Set from = DeleteRecordVersionTest.this.relationshipService.getRelationshipsFrom(versionRecord);
                TestCase.assertTrue((boolean)from.isEmpty());
                Set to = DeleteRecordVersionTest.this.relationshipService.getRelationshipsTo(versionRecord);
                TestCase.assertTrue((boolean)to.isEmpty());
            }
        });
    }

    public void testDeleteOldestVersion() {
        final NodeRef myDocument = this.createDocumentWithRecordVersions();
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private VersionHistory versionHistory;

            @Override
            public void given() throws Exception {
                this.versionHistory = DeleteRecordVersionTest.this.versionService.getVersionHistory(myDocument);
            }

            @Override
            public void when() {
                Version version10 = this.versionHistory.getVersion("1.0");
                NodeRef recordVersion10 = DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(version10);
                DeleteRecordVersionTest.this.nodeService.deleteNode(recordVersion10);
            }

            @Override
            public void then() {
                Version version10 = this.versionHistory.getVersion("1.0");
                TestCase.assertNotNull((Object)version10);
                TestCase.assertTrue((boolean)DeleteRecordVersionTest.this.recordableVersionService.isRecordedVersionDestroyed(version10));
                NodeRef recordVersion10 = DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(version10);
                TestCase.assertNull((Object)recordVersion10);
                Version version12 = this.versionHistory.getHeadVersion();
                TestCase.assertEquals((String)"1.2", (String)version12.getVersionLabel());
                NodeRef recordVersion12 = DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(version12);
                TestCase.assertNotNull((Object)recordVersion12);
                TestCase.assertTrue((boolean)DeleteRecordVersionTest.this.relationshipService.getRelationshipsTo(recordVersion12, "versions").isEmpty());
                Set from12 = DeleteRecordVersionTest.this.relationshipService.getRelationshipsFrom(recordVersion12, "versions");
                TestCase.assertEquals((int)1, (int)from12.size());
                Version version11 = this.versionHistory.getPredecessor(version12);
                TestCase.assertEquals((String)"1.1", (String)version11.getVersionLabel());
                NodeRef recordVersion11 = DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(version11);
                TestCase.assertNotNull((Object)recordVersion11);
                Set to11 = DeleteRecordVersionTest.this.relationshipService.getRelationshipsTo(recordVersion11, "versions");
                TestCase.assertEquals((int)1, (int)to11.size());
                TestCase.assertEquals((Object)recordVersion12, (Object)((Relationship)to11.iterator().next()).getSource());
                TestCase.assertTrue((boolean)DeleteRecordVersionTest.this.relationshipService.getRelationshipsFrom(recordVersion11, "versions").isEmpty());
            }
        });
    }

    public void testDeleteMiddleVersion() {
        final NodeRef myDocument = this.createDocumentWithRecordVersions();
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private VersionHistory versionHistory;

            @Override
            public void given() throws Exception {
                this.versionHistory = DeleteRecordVersionTest.this.versionService.getVersionHistory(myDocument);
            }

            @Override
            public void when() {
                Version version11 = this.versionHistory.getVersion("1.1");
                NodeRef recordVersion11 = DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(version11);
                DeleteRecordVersionTest.this.nodeService.deleteNode(recordVersion11);
            }

            @Override
            public void then() {
                Version version11 = this.versionHistory.getVersion("1.1");
                TestCase.assertNotNull((Object)version11);
                TestCase.assertTrue((boolean)DeleteRecordVersionTest.this.recordableVersionService.isRecordedVersionDestroyed(version11));
                NodeRef recordVersion11 = DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(version11);
                TestCase.assertNull((Object)recordVersion11);
                Version version12 = this.versionHistory.getHeadVersion();
                TestCase.assertEquals((String)"1.2", (String)version12.getVersionLabel());
                NodeRef recordVersion12 = DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(version12);
                TestCase.assertNotNull((Object)recordVersion12);
                TestCase.assertTrue((boolean)DeleteRecordVersionTest.this.relationshipService.getRelationshipsTo(recordVersion12, "versions").isEmpty());
                Set from12 = DeleteRecordVersionTest.this.relationshipService.getRelationshipsFrom(recordVersion12, "versions");
                TestCase.assertEquals((int)1, (int)from12.size());
                Version version10 = this.versionHistory.getVersion("1.0");
                TestCase.assertEquals((String)"1.0", (String)version10.getVersionLabel());
                NodeRef recordVersion10 = DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(version10);
                TestCase.assertNotNull((Object)recordVersion10);
                Set to10 = DeleteRecordVersionTest.this.relationshipService.getRelationshipsTo(recordVersion10, "versions");
                TestCase.assertEquals((int)1, (int)to10.size());
                TestCase.assertEquals((Object)recordVersion12, (Object)((Relationship)to10.iterator().next()).getSource());
                TestCase.assertTrue((boolean)DeleteRecordVersionTest.this.relationshipService.getRelationshipsFrom(recordVersion10, "versions").isEmpty());
            }
        });
    }

    public void testDeleteCurrentVersion() {
        final NodeRef myDocument = this.createDocumentWithRecordVersions();
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private VersionHistory versionHistory;

            @Override
            public void given() throws Exception {
                this.versionHistory = DeleteRecordVersionTest.this.versionService.getVersionHistory(myDocument);
            }

            @Override
            public void when() {
                Version version12 = this.versionHistory.getVersion("1.2");
                NodeRef recordVersion12 = DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(version12);
                DeleteRecordVersionTest.this.nodeService.deleteNode(recordVersion12);
            }

            @Override
            public void then() {
                Version version12 = this.versionHistory.getVersion("1.2");
                TestCase.assertNotNull((Object)version12);
                TestCase.assertTrue((boolean)DeleteRecordVersionTest.this.recordableVersionService.isRecordedVersionDestroyed(version12));
                TestCase.assertNull((Object)DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(version12));
                Version version11 = this.versionHistory.getVersion("1.1");
                TestCase.assertNotNull((Object)version11);
                NodeRef recordVersion11 = DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(version11);
                TestCase.assertNotNull((Object)recordVersion11);
                TestCase.assertTrue((boolean)DeleteRecordVersionTest.this.relationshipService.getRelationshipsTo(recordVersion11, "versions").isEmpty());
                Set from11 = DeleteRecordVersionTest.this.relationshipService.getRelationshipsFrom(recordVersion11, "versions");
                TestCase.assertEquals((int)1, (int)from11.size());
                Version version10 = this.versionHistory.getVersion("1.0");
                TestCase.assertNotNull((Object)version10);
                NodeRef recordVersion10 = DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(version10);
                TestCase.assertNotNull((Object)recordVersion10);
                Set to10 = DeleteRecordVersionTest.this.relationshipService.getRelationshipsTo(recordVersion10, "versions");
                TestCase.assertEquals((int)1, (int)to10.size());
                TestCase.assertEquals((Object)recordVersion11, (Object)((Relationship)to10.iterator().next()).getSource());
                TestCase.assertTrue((boolean)DeleteRecordVersionTest.this.relationshipService.getRelationshipsFrom(recordVersion10, "versions").isEmpty());
            }
        });
    }

    public void testDestroyVersionRecordWithMetadata() {
        final NodeRef myDocument = this.createDocumentWithRecordVersions();
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private VersionHistory versionHistory;
            private NodeRef recordVersion11;

            @Override
            public void given() throws Exception {
                NodeRef myCategory = DeleteRecordVersionTest.this.filePlanService.createRecordCategory(DeleteRecordVersionTest.this.filePlan, GUID.generate());
                DeleteRecordVersionTest.this.utils.createBasicDispositionSchedule(myCategory, GUID.generate(), GUID.generate(), true, true);
                NodeRef myRecordFolder = DeleteRecordVersionTest.this.recordFolderService.createRecordFolder(myCategory, GUID.generate());
                this.versionHistory = DeleteRecordVersionTest.this.versionService.getVersionHistory(myDocument);
                for (Version version : this.versionHistory.getAllVersions()) {
                    NodeRef record = DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(version);
                    DeleteRecordVersionTest.this.fileFolderService.move(record, myRecordFolder, null);
                    DeleteRecordVersionTest.this.utils.completeRecord(record);
                }
            }

            @Override
            public void when() {
                Version version11 = this.versionHistory.getVersion("1.1");
                this.recordVersion11 = DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(version11);
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("eventName", "case_closed");
                DeleteRecordVersionTest.this.rmActionService.executeRecordsManagementAction(this.recordVersion11, "completeEvent", params);
                DeleteRecordVersionTest.this.rmActionService.executeRecordsManagementAction(this.recordVersion11, "cutoff");
                DeleteRecordVersionTest.this.rmActionService.executeRecordsManagementAction(this.recordVersion11, "destroy");
            }

            @Override
            public void then() {
                VersionHistory versionHistory = DeleteRecordVersionTest.this.versionService.getVersionHistory(myDocument);
                TestCase.assertNotNull((Object)versionHistory);
                Collection versions = versionHistory.getAllVersions();
                TestCase.assertEquals((int)3, (int)versions.size());
                Version version12 = versionHistory.getHeadVersion();
                TestCase.assertEquals((String)"1.2", (String)version12.getVersionLabel());
                TestCase.assertFalse((boolean)DeleteRecordVersionTest.this.recordableVersionService.isRecordedVersionDestroyed(version12));
                NodeRef recordVersion12 = DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(version12);
                TestCase.assertNotNull((Object)recordVersion12);
                TestCase.assertFalse((boolean)DeleteRecordVersionTest.this.recordService.isMetadataStub(recordVersion12));
                TestCase.assertTrue((boolean)DeleteRecordVersionTest.this.relationshipService.getRelationshipsTo(recordVersion12, "versions").isEmpty());
                Set from12 = DeleteRecordVersionTest.this.relationshipService.getRelationshipsFrom(recordVersion12, "versions");
                TestCase.assertEquals((int)1, (int)from12.size());
                Version version11 = versionHistory.getPredecessor(version12);
                TestCase.assertEquals((String)"1.1", (String)version11.getVersionLabel());
                TestCase.assertTrue((boolean)DeleteRecordVersionTest.this.recordableVersionService.isRecordedVersionDestroyed(version11));
                TestCase.assertNotNull((Object)this.recordVersion11);
                TestCase.assertTrue((boolean)DeleteRecordVersionTest.this.recordService.isMetadataStub(this.recordVersion11));
                Set to11 = DeleteRecordVersionTest.this.relationshipService.getRelationshipsTo(this.recordVersion11, "versions");
                TestCase.assertEquals((int)1, (int)to11.size());
                TestCase.assertEquals((Object)recordVersion12, (Object)((Relationship)to11.iterator().next()).getSource());
                Set from11 = DeleteRecordVersionTest.this.relationshipService.getRelationshipsFrom(this.recordVersion11, "versions");
                TestCase.assertEquals((int)1, (int)from11.size());
                Version version10 = versionHistory.getPredecessor(version11);
                TestCase.assertEquals((String)"1.0", (String)version10.getVersionLabel());
                TestCase.assertFalse((boolean)DeleteRecordVersionTest.this.recordableVersionService.isRecordedVersionDestroyed(version10));
                NodeRef recordVersion10 = DeleteRecordVersionTest.this.recordableVersionService.getVersionRecord(version10);
                TestCase.assertNotNull((Object)recordVersion10);
                TestCase.assertFalse((boolean)DeleteRecordVersionTest.this.recordService.isMetadataStub(recordVersion10));
                Set to10 = DeleteRecordVersionTest.this.relationshipService.getRelationshipsTo(recordVersion10, "versions");
                TestCase.assertEquals((int)1, (int)to10.size());
                TestCase.assertEquals((Object)this.recordVersion11, (Object)((Relationship)to10.iterator().next()).getSource());
                TestCase.assertTrue((boolean)DeleteRecordVersionTest.this.relationshipService.getRelationshipsFrom(recordVersion10, "versions").isEmpty());
            }
        });
    }
}

