/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.version;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.AlfrescoTransactionSupport;
import org.alfresco.module.org_alfresco_module_rm.util.AuthenticationUtil;
import org.alfresco.module.org_alfresco_module_rm.version.ExtendedVersionableAspect;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.springframework.extensions.webscripts.GUID;

public class ExtendedVersionableAspectUnitTest
implements RecordsManagementModel {
    private static final String KEY_VERSIONED_NODEREFS = "versioned_noderefs";
    private NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate());
    private NodeRef anotherNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate());
    private QName oldType = QName.createQName((String)"http://www.alfresco.org/model/recordsmanagement/1.0", (String)GUID.generate());
    private QName newType = QName.createQName((String)"http://www.alfresco.org/model/recordsmanagement/1.0", (String)GUID.generate());
    @Mock
    private NodeService mockedNodeService;
    @Mock
    private VersionService mockedVersionService;
    @Mock
    private LockService mockedLockService;
    @Mock
    private AlfrescoTransactionSupport mockedAlfrescoTransactionSupport;
    @Mock
    private AuthenticationUtil mockedAuthenticationUtil;
    @InjectMocks
    private ExtendedVersionableAspect extendedVersionableAspect;

    @Before
    public void testSetup() {
        MockitoAnnotations.initMocks((Object)this);
        ((AuthenticationUtil)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                AuthenticationUtil.RunAsWork work = (AuthenticationUtil.RunAsWork)invocation.getArguments()[0];
                return work.doWork();
            }
        }).when((Object)this.mockedAuthenticationUtil)).runAsSystem((AuthenticationUtil.RunAsWork)ArgumentMatchers.any(AuthenticationUtil.RunAsWork.class));
    }

    @Test
    public void autoVersionOff() {
        this.extendedVersionableAspect.setAutoVersionOnTypeChange(false);
        this.extendedVersionableAspect.onSetNodeType(this.nodeRef, this.oldType, this.newType);
        ((VersionService)Mockito.verify((Object)this.mockedVersionService, (VerificationMode)Mockito.never())).createVersion((NodeRef)ArgumentMatchers.eq((Object)this.nodeRef), (Map)ArgumentMatchers.any(Map.class));
    }

    @Test
    public void nodeDoesNotExist() {
        this.extendedVersionableAspect.setAutoVersionOnTypeChange(true);
        Mockito.when((Object)this.mockedNodeService.exists(this.nodeRef)).thenReturn((Object)false);
        this.extendedVersionableAspect.onSetNodeType(this.nodeRef, this.oldType, this.newType);
        ((VersionService)Mockito.verify((Object)this.mockedVersionService, (VerificationMode)Mockito.never())).createVersion((NodeRef)ArgumentMatchers.eq((Object)this.nodeRef), (Map)ArgumentMatchers.any(Map.class));
    }

    @Test
    public void nodeLocked() {
        this.extendedVersionableAspect.setAutoVersionOnTypeChange(true);
        Mockito.when((Object)this.mockedNodeService.exists(this.nodeRef)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedLockService.getLockStatus(this.nodeRef)).thenReturn((Object)LockStatus.LOCKED);
        this.extendedVersionableAspect.onSetNodeType(this.nodeRef, this.oldType, this.newType);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).exists(this.nodeRef);
        ((VersionService)Mockito.verify((Object)this.mockedVersionService, (VerificationMode)Mockito.never())).createVersion((NodeRef)ArgumentMatchers.eq((Object)this.nodeRef), (Map)ArgumentMatchers.any(Map.class));
    }

    @Test
    public void nodeIsNotVersionable() {
        this.extendedVersionableAspect.setAutoVersionOnTypeChange(true);
        Mockito.when((Object)this.mockedNodeService.exists(this.nodeRef)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedLockService.getLockStatus(this.nodeRef)).thenReturn((Object)LockStatus.NO_LOCK);
        Mockito.when((Object)this.mockedNodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE)).thenReturn((Object)false);
        this.extendedVersionableAspect.onSetNodeType(this.nodeRef, this.oldType, this.newType);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).exists(this.nodeRef);
        ((LockService)Mockito.verify((Object)this.mockedLockService)).isLockedAndReadOnly(this.nodeRef);
        ((VersionService)Mockito.verify((Object)this.mockedVersionService, (VerificationMode)Mockito.never())).createVersion((NodeRef)ArgumentMatchers.eq((Object)this.nodeRef), (Map)ArgumentMatchers.any(Map.class));
    }

    @Test
    public void nodeIsTemporary() {
        this.extendedVersionableAspect.setAutoVersionOnTypeChange(true);
        Mockito.when((Object)this.mockedNodeService.exists(this.nodeRef)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedLockService.getLockStatus(this.nodeRef)).thenReturn((Object)LockStatus.NO_LOCK);
        Mockito.when((Object)this.mockedNodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedNodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_TEMPORARY)).thenReturn((Object)true);
        this.extendedVersionableAspect.onSetNodeType(this.nodeRef, this.oldType, this.newType);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).exists(this.nodeRef);
        ((LockService)Mockito.verify((Object)this.mockedLockService)).isLockedAndReadOnly(this.nodeRef);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE);
        ((VersionService)Mockito.verify((Object)this.mockedVersionService, (VerificationMode)Mockito.never())).createVersion((NodeRef)ArgumentMatchers.eq((Object)this.nodeRef), (Map)ArgumentMatchers.any(Map.class));
    }

    @Test
    public void nodeIsBeingVersioned() {
        this.extendedVersionableAspect.setAutoVersionOnTypeChange(true);
        Mockito.when((Object)this.mockedNodeService.exists(this.nodeRef)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedLockService.getLockStatus(this.nodeRef)).thenReturn((Object)LockStatus.NO_LOCK);
        Mockito.when((Object)this.mockedNodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedNodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_TEMPORARY)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedAlfrescoTransactionSupport.getResource((Object)KEY_VERSIONED_NODEREFS)).thenReturn(Collections.singletonMap(this.nodeRef, this.nodeRef));
        this.extendedVersionableAspect.onSetNodeType(this.nodeRef, this.oldType, this.newType);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).exists(this.nodeRef);
        ((LockService)Mockito.verify((Object)this.mockedLockService)).isLockedAndReadOnly(this.nodeRef);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).hasAspect(this.nodeRef, ContentModel.ASPECT_TEMPORARY);
        ((VersionService)Mockito.verify((Object)this.mockedVersionService, (VerificationMode)Mockito.never())).createVersion((NodeRef)ArgumentMatchers.eq((Object)this.nodeRef), (Map)ArgumentMatchers.any(Map.class));
    }

    @Test
    public void autoVersionFalse() {
        this.extendedVersionableAspect.setAutoVersionOnTypeChange(true);
        Mockito.when((Object)this.mockedNodeService.exists(this.nodeRef)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedLockService.getLockStatus(this.nodeRef)).thenReturn((Object)LockStatus.NO_LOCK);
        Mockito.when((Object)this.mockedNodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedNodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_TEMPORARY)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedAlfrescoTransactionSupport.getResource((Object)KEY_VERSIONED_NODEREFS)).thenReturn(Collections.singletonMap(this.anotherNodeRef, this.anotherNodeRef));
        Mockito.when((Object)this.mockedNodeService.getProperty(this.nodeRef, ContentModel.PROP_AUTO_VERSION)).thenReturn((Object)Boolean.FALSE);
        this.extendedVersionableAspect.onSetNodeType(this.nodeRef, this.oldType, this.newType);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).exists(this.nodeRef);
        ((LockService)Mockito.verify((Object)this.mockedLockService)).isLockedAndReadOnly(this.nodeRef);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).hasAspect(this.nodeRef, ContentModel.ASPECT_TEMPORARY);
        ((AlfrescoTransactionSupport)Mockito.verify((Object)this.mockedAlfrescoTransactionSupport)).getResource((Object)KEY_VERSIONED_NODEREFS);
        ((VersionService)Mockito.verify((Object)this.mockedVersionService, (VerificationMode)Mockito.never())).createVersion((NodeRef)ArgumentMatchers.eq((Object)this.nodeRef), (Map)ArgumentMatchers.any(Map.class));
    }

    @Test
    public void createVersion() {
        this.extendedVersionableAspect.setAutoVersionOnTypeChange(true);
        Mockito.when((Object)this.mockedNodeService.exists(this.nodeRef)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedLockService.getLockStatus(this.nodeRef)).thenReturn((Object)LockStatus.NO_LOCK);
        Mockito.when((Object)this.mockedNodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedNodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_TEMPORARY)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedAlfrescoTransactionSupport.getResource((Object)KEY_VERSIONED_NODEREFS)).thenReturn(new HashMap<NodeRef, NodeRef>(Collections.singletonMap(this.anotherNodeRef, this.anotherNodeRef)));
        Mockito.when((Object)this.mockedNodeService.getProperty(this.nodeRef, ContentModel.PROP_AUTO_VERSION)).thenReturn((Object)Boolean.TRUE);
        this.extendedVersionableAspect.onSetNodeType(this.nodeRef, this.oldType, this.newType);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).exists(this.nodeRef);
        ((LockService)Mockito.verify((Object)this.mockedLockService)).isLockedAndReadOnly(this.nodeRef);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).hasAspect(this.nodeRef, ContentModel.ASPECT_TEMPORARY);
        ((AlfrescoTransactionSupport)Mockito.verify((Object)this.mockedAlfrescoTransactionSupport, (VerificationMode)Mockito.times((int)2))).getResource((Object)KEY_VERSIONED_NODEREFS);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).getProperty(this.nodeRef, ContentModel.PROP_AUTO_VERSION);
        ((VersionService)Mockito.verify((Object)this.mockedVersionService)).createVersion((NodeRef)ArgumentMatchers.eq((Object)this.nodeRef), (Map)ArgumentMatchers.any(Map.class));
    }
}

