/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.holds;

import org.alfresco.module.org_alfresco_module_rm.bulk.BulkOperation;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkService;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkStatus;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.framework.Operation;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.model.HoldBulkOperation;
import org.alfresco.rm.rest.api.model.HoldBulkOperationEntry;
import org.alfresco.rm.rest.api.model.HoldDeletionReason;
import org.alfresco.rm.rest.api.model.HoldModel;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;

@EntityResource(name="holds", title="Holds")
public class HoldsEntityResource
implements EntityResourceAction.ReadById<HoldModel>,
EntityResourceAction.Update<HoldModel>,
EntityResourceAction.Delete,
InitializingBean {
    private FilePlanComponentsApiUtils apiUtils;
    private FileFolderService fileFolderService;
    private ApiNodesModelFactory nodesModelFactory;
    private HoldService holdService;
    private TransactionService transactionService;
    private HoldBulkService holdBulkService;

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"nodesModelFactory", (Object)this.nodesModelFactory);
        ParameterCheck.mandatory((String)"apiUtils", (Object)this.apiUtils);
        ParameterCheck.mandatory((String)"fileFolderService", (Object)this.fileFolderService);
        ParameterCheck.mandatory((String)"holdService", (Object)this.holdService);
        ParameterCheck.mandatory((String)"transactionService", (Object)this.transactionService);
    }

    @WebApiDescription(title="Get hold information", description="Get information for a hold with id 'holdId'")
    @WebApiParam(name="holdId", title="The hold id")
    public HoldModel readById(String holdId, Parameters parameters) {
        RMParameterCheck.checkNotBlank("holdId", holdId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef hold = this.apiUtils.lookupAndValidateNodeType(holdId, RecordsManagementModel.TYPE_HOLD);
        FileInfo info = this.fileFolderService.getFileInfo(hold);
        return this.nodesModelFactory.createHoldModel(info);
    }

    @WebApiDescription(title="Update a hold", description="Updates a hold with id 'holdId'")
    public HoldModel update(String holdId, HoldModel holdModel, Parameters parameters) {
        RMParameterCheck.checkNotBlank("holdId", holdId);
        ParameterCheck.mandatory((String)"holdModel", (Object)holdModel);
        ParameterCheck.mandatory((String)"holdModel.name", (Object)holdModel.name());
        ParameterCheck.mandatory((String)"holdModel.reason", (Object)holdModel.reason());
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef nodeRef = this.apiUtils.lookupAndValidateNodeType(holdId, RecordsManagementModel.TYPE_HOLD);
        RetryingTransactionHelper.RetryingTransactionCallback callback = () -> {
            this.holdService.updateHold(nodeRef, holdModel.name(), holdModel.reason(), holdModel.description());
            return null;
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback readCallback = () -> this.fileFolderService.getFileInfo(nodeRef);
        FileInfo info = (FileInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction(readCallback, false, true);
        return this.nodesModelFactory.createHoldModel(info);
    }

    @WebApiDescription(title="Delete hold", description="Deletes a hold with id 'holdId'")
    public void delete(String holdId, Parameters parameters) {
        RMParameterCheck.checkNotBlank("holdId", holdId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef hold = this.apiUtils.lookupAndValidateNodeType(holdId, RecordsManagementModel.TYPE_HOLD);
        RetryingTransactionHelper.RetryingTransactionCallback callback = () -> {
            this.holdService.deleteHold(hold);
            return null;
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, false, true);
    }

    @Operation(value="delete")
    @WebApiDescription(title="Delete hold with a reason", successStatus=200)
    public HoldDeletionReason deleteHoldWithReason(String holdId, HoldDeletionReason reason, Parameters parameters, WithResponse withResponse) {
        RMParameterCheck.checkNotBlank("holdId", holdId);
        ParameterCheck.mandatory((String)"reason", (Object)reason);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef hold = this.apiUtils.lookupAndValidateNodeType(holdId, RecordsManagementModel.TYPE_HOLD);
        String deletionReason = reason.reason();
        RetryingTransactionHelper.RetryingTransactionCallback callback = () -> {
            if (StringUtils.isNotBlank((CharSequence)deletionReason)) {
                this.holdService.setHoldDeletionReason(hold, deletionReason);
            }
            this.holdService.deleteHold(hold);
            return null;
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, false, true);
        return reason;
    }

    @Operation(value="bulk")
    @WebApiDescription(title="Start the hold bulk operation", successStatus=202)
    public HoldBulkOperationEntry bulk(String holdId, HoldBulkOperation holdBulkOperation, Parameters parameters, WithResponse withResponse) {
        RMParameterCheck.checkNotBlank("holdId", holdId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef parentNodeRef = this.apiUtils.lookupAndValidateNodeType(holdId, RecordsManagementModel.TYPE_HOLD);
        HoldBulkStatus holdBulkStatus = this.holdBulkService.execute(parentNodeRef, new BulkOperation(holdBulkOperation.query(), holdBulkOperation.op().name()));
        return new HoldBulkOperationEntry(holdBulkStatus.bulkStatusId(), holdBulkStatus.totalItems());
    }

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void setHoldService(HoldService holdService) {
        this.holdService = holdService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setHoldBulkService(HoldBulkService holdBulkService) {
        this.holdBulkService = holdBulkService;
    }
}

