/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.vital;

import java.io.Serializable;
import java.util.Date;
import org.alfresco.module.org_alfresco_module_rm.action.RMActionExecuterAbstractBase;
import org.alfresco.module.org_alfresco_module_rm.vital.VitalRecordDefinition;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReviewedAction
extends RMActionExecuterAbstractBase {
    private static Log logger = LogFactory.getLog(ReviewedAction.class);

    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        VitalRecordDefinition vrDef = this.getVitalRecordService().getVitalRecordDefinition(actionedUponNodeRef);
        if (vrDef != null && vrDef.isEnabled()) {
            if (this.getRecordService().isRecord(actionedUponNodeRef)) {
                this.reviewRecord(actionedUponNodeRef, vrDef);
            } else if (this.getRecordFolderService().isRecordFolder(actionedUponNodeRef)) {
                for (NodeRef record : this.getRecordService().getRecords(actionedUponNodeRef)) {
                    this.reviewRecord(record, vrDef);
                }
            }
        }
    }

    private void reviewRecord(NodeRef nodeRef, VitalRecordDefinition vrDef) {
        if (vrDef.getReviewPeriod().getPeriodType().equals("immediately")) {
            if (logger.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Removing reviewAsOf property from").append(nodeRef);
                logger.debug((Object)msg.toString());
            }
            this.getNodeService().removeProperty(nodeRef, PROP_REVIEW_AS_OF);
        } else {
            Date reviewAsOf = vrDef.getNextReviewDate();
            if (reviewAsOf != null) {
                if (logger.isDebugEnabled()) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Setting new reviewAsOf property [").append(reviewAsOf).append("] on ").append(nodeRef);
                    logger.debug((Object)msg.toString());
                }
                this.getNodeService().setProperty(nodeRef, PROP_REVIEW_AS_OF, (Serializable)reviewAsOf);
            }
        }
    }
}

