/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.issue;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class RM4163Test
extends BaseRMTestCase {
    private RuleService ruleService;
    private NodeRef ruleFolder;
    private NodeRef nodeRefCategory1;

    @Override
    protected void initServices() {
        super.initServices();
        this.ruleService = (RuleService)this.applicationContext.getBean("RuleService");
    }

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected boolean isRecordTest() {
        return true;
    }

    public void testDeclareRecordsConcurently() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RM4163Test.this.ruleFolder = RM4163Test.this.fileFolderService.create(RM4163Test.this.documentLibrary, "mytestfolder", ContentModel.TYPE_FOLDER).getNodeRef();
                RM4163Test.this.nodeRefCategory1 = RM4163Test.this.filePlanService.createRecordCategory(RM4163Test.this.filePlan, "category1");
                Action action = RM4163Test.this.actionService.createAction("create-record");
                action.setParameterValue("file-plan", (Serializable)RM4163Test.this.filePlan);
                Rule rule = new Rule();
                rule.setRuleType("inbound");
                rule.setTitle("declareAsRecordRule");
                rule.setAction(action);
                rule.setExecuteAsynchronously(true);
                RM4163Test.this.ruleService.saveRule(RM4163Test.this.ruleFolder, rule);
                Action fileAction = RM4163Test.this.actionService.createAction("fileTo");
                fileAction.setParameterValue("path", (Serializable)((Object)"/category1/{node.cm:description}"));
                fileAction.setParameterValue("createRecordPath", (Serializable)Boolean.valueOf(true));
                Rule fileRule = new Rule();
                fileRule.setRuleType("inbound");
                fileRule.setTitle("filingRule");
                fileRule.setAction(fileAction);
                fileRule.setExecuteAsynchronously(true);
                RM4163Test.this.ruleService.saveRule(RM4163Test.this.filePlanService.getUnfiledContainer(RM4163Test.this.filePlan), fileRule);
                return null;
            }

            public void test(Void result) throws Exception {
                TestCase.assertFalse((boolean)RM4163Test.this.ruleService.getRules(RM4163Test.this.ruleFolder).isEmpty());
            }
        });
        ArrayList documents = new ArrayList(4);
        documents.addAll(this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<List<NodeRef>>(){

            public List<NodeRef> run() throws Exception {
                ArrayList<NodeRef> documents = new ArrayList<NodeRef>(4);
                NodeRef document = RM4163Test.this.createFile(RM4163Test.this.documentLibrary, "document1.txt", "desc1", ContentModel.TYPE_CONTENT);
                documents.add(document);
                document = RM4163Test.this.createFile(RM4163Test.this.documentLibrary, "document2.txt", "desc2", ContentModel.TYPE_CONTENT);
                documents.add(document);
                document = RM4163Test.this.createFile(RM4163Test.this.documentLibrary, "document3.txt", "desc1", ContentModel.TYPE_CONTENT);
                documents.add(document);
                document = RM4163Test.this.createFile(RM4163Test.this.documentLibrary, "document4.txt", "desc1", ContentModel.TYPE_CONTENT);
                documents.add(document);
                return documents;
            }
        }));
        final Iterator temp = documents.iterator();
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                while (temp.hasNext()) {
                    NodeRef document = (NodeRef)temp.next();
                    RM4163Test.this.fileFolderService.move(document, RM4163Test.this.ruleFolder, null);
                }
                return null;
            }
        });
        Thread.sleep(5000L);
        Integer numberOfRecords = (Integer)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Integer>(){

            public Integer doWork() throws Exception {
                List containedRecordFolders = RM4163Test.this.filePlanService.getContainedRecordFolders(RM4163Test.this.nodeRefCategory1);
                int numberOfRecords = 0;
                for (NodeRef recordFolder : containedRecordFolders) {
                    numberOfRecords += RM4163Test.this.fileFolderService.list(recordFolder).size();
                }
                return numberOfRecords;
            }
        });
        RM4163Test.assertEquals((int)4, (int)numberOfRecords);
    }

    private NodeRef createFile(NodeRef parentNodeRef, String name, String descrption, QName typeQName) {
        HashMap<QName, String> properties = new HashMap<QName, String>(11);
        properties.put(ContentModel.PROP_NAME, name);
        properties.put(ContentModel.PROP_DESCRIPTION, descrption);
        QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)name));
        ChildAssociationRef assocRef = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, assocQName, typeQName, properties);
        NodeRef nodeRef = assocRef.getChildRef();
        return nodeRef;
    }
}

