/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v21;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.patch.v21.RMv21PatchComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;

public class RMv21BehaviorScriptsPatch
extends RMv21PatchComponent
implements BeanNameAware {
    private static final Log LOGGER = LogFactory.getLog(RMv21BehaviorScriptsPatch.class);
    protected static final NodeRef RM_CONFIG = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "rm_config_folder");
    protected static final NodeRef OLD_BEHAVIOR_SCRIPTS_FOLDER = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "rm_scripts");
    private static NodeRef newBehaviorScriptsFolder = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "rm_behavior_scripts");
    protected static final String IS_CLOSED_JS = "rma_isClosed.js";
    private NodeService nodeService;
    private FileFolderService fileFolderService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    @Override
    protected void executePatch() {
        if (!this.nodeService.exists(RM_CONFIG)) {
            return;
        }
        if (!this.nodeService.exists(newBehaviorScriptsFolder)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)" ... creating RM Behavior Scripts folder");
            }
            String newBehaviorScriptsFolderName = "Records Management Behavior Scripts";
            String newBehaviorScriptsNodeUUID = "rm_behavior_scripts";
            String newBehaviorScriptsAssocQName = "records_management_behavior_scripts";
            HashMap<QName, String> newBehaviorScriptsFolderProps = new HashMap<QName, String>();
            newBehaviorScriptsFolderProps.put(ContentModel.PROP_NODE_UUID, newBehaviorScriptsNodeUUID);
            newBehaviorScriptsFolderProps.put(ContentModel.PROP_NAME, newBehaviorScriptsFolderName);
            newBehaviorScriptsFolderProps.put(ContentModel.PROP_TITLE, newBehaviorScriptsFolderName);
            newBehaviorScriptsFolderProps.put(ContentModel.PROP_DESCRIPTION, "Scripts intended for execution in response to RM events.");
            newBehaviorScriptsFolder = this.nodeService.createNode(RM_CONFIG, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"cm", (String)newBehaviorScriptsAssocQName), ContentModel.TYPE_FOLDER, newBehaviorScriptsFolderProps).getChildRef();
        }
        if (this.nodeService.exists(OLD_BEHAVIOR_SCRIPTS_FOLDER)) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() {
                    RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        public Void execute() throws Throwable {
                            RMv21BehaviorScriptsPatch.this.nodeService.setProperty(OLD_BEHAVIOR_SCRIPTS_FOLDER, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"Scripts specific to RM that can also be executed by RM rules."));
                            List oldBehaviorScripts = RMv21BehaviorScriptsPatch.this.fileFolderService.listFiles(OLD_BEHAVIOR_SCRIPTS_FOLDER);
                            if (oldBehaviorScripts != null && !oldBehaviorScripts.isEmpty()) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug((Object)" ... moving files from RM Scripts folder to RM Behavior Scripts folder");
                                }
                                for (FileInfo script : oldBehaviorScripts) {
                                    RMv21BehaviorScriptsPatch.this.fileFolderService.moveFrom(script.getNodeRef(), OLD_BEHAVIOR_SCRIPTS_FOLDER, newBehaviorScriptsFolder, script.getName());
                                    if (!LOGGER.isDebugEnabled()) continue;
                                    LOGGER.debug((Object)(" ...... moved " + script.getName()));
                                }
                            }
                            return null;
                        }
                    };
                    RMv21BehaviorScriptsPatch.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }
}

