/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.util.dao;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.module.org_alfresco_module_rm.util.dao.QueryField;
import org.alfresco.util.Pair;

@AlfrescoPublicApi
public class QueryParams<T extends QueryField> {
    private List<Pair<T, Boolean>> sortProps;
    private int skipCount = 0;
    private int maxItems = 10;

    public QueryParams(List<Pair<T, Boolean>> sortProps) {
        this.setSortProps(sortProps);
    }

    public QueryParams<T> withSkipCount(int skipCount) {
        this.skipCount = skipCount;
        return this;
    }

    public QueryParams<T> withMaxItems(int maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public QueryParams<T> withSortProps(List<Pair<T, Boolean>> sortProps) {
        this.setSortProps(sortProps);
        return this;
    }

    public void setSortProps(List<Pair<T, Boolean>> sortProps) {
        this.sortProps = ImmutableList.copyOf(sortProps);
        for (Pair<T, Boolean> sortPair : sortProps) {
            if (sortPair != null && sortPair.getFirst() != null && sortPair.getSecond() != null) continue;
            throw new IllegalArgumentException("Unexpected null or null containing element in list: " + String.valueOf(sortProps));
        }
    }

    public List<Pair<T, Boolean>> getSortProps() {
        return this.sortProps;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public int getMaxItems() {
        return this.maxItems;
    }
}

