/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.impl;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.rest.workflow.api.impl.MapBasedQueryWalker;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class SearchTypesFactory {
    private DictionaryService dictionaryService;
    private Nodes nodes;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public Set<QName> buildSearchTypesForFilePlanEndpoint() {
        HashSet<QName> searchTypeQNames = new HashSet<QName>();
        searchTypeQNames.add(RecordsManagementModel.TYPE_RECORD_CATEGORY);
        return searchTypeQNames;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<QName> buildSearchTypesForUnfiledEndpoint(Parameters parameters, Set<String> listFolderChildrenEqualsQueryProperties) {
        HashSet<QName> searchTypeQNames = new HashSet<QName>();
        Query q = parameters.getQuery();
        boolean includeUnfiledRecordFolders = false;
        boolean includeRecords = false;
        boolean includeSubTypes = false;
        if (q != null && q.getTree() != null) {
            MapBasedQueryWalker propertyWalker = new MapBasedQueryWalker(listFolderChildrenEqualsQueryProperties, null);
            QueryHelper.walk((Query)q, (QueryHelper.WalkerCallback)propertyWalker);
            Boolean isUnfiledRecordFolder = (Boolean)propertyWalker.getProperty("isUnfiledRecordFolder", 8, Boolean.class);
            Boolean isRecord = (Boolean)propertyWalker.getProperty("isRecord", 8, Boolean.class);
            if (SearchTypesFactory.checkIncludeUnfiledRecordFolders(isUnfiledRecordFolder, isRecord)) {
                includeUnfiledRecordFolders = true;
            } else if (SearchTypesFactory.checkIncludeRecords(isUnfiledRecordFolder, isRecord)) {
                includeRecords = true;
            }
            String nodeTypeQNameStr = (String)propertyWalker.getProperty("nodeType", 8, String.class);
            if (nodeTypeQNameStr != null) {
                if (isUnfiledRecordFolder != null || isRecord != null) {
                    throw new InvalidArgumentException("Invalid filter - nodeType and isUnfiledRecordFolder/isRecord are mutually exclusive");
                }
                Pair<QName, Boolean> pair = this.parseNodeTypeFilter(nodeTypeQNameStr);
                QName filterNodeTypeQName = (QName)pair.getFirst();
                includeSubTypes = (Boolean)pair.getSecond();
                if (filterNodeTypeQName.equals((Object)RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER)) {
                    includeUnfiledRecordFolders = true;
                } else if (filterNodeTypeQName.equals((Object)ContentModel.TYPE_CONTENT)) {
                    includeRecords = true;
                } else {
                    if (!this.dictionaryService.isSubClass(filterNodeTypeQName, ContentModel.TYPE_CONTENT)) throw new InvalidParameterException("Filter nodeType: " + nodeTypeQNameStr + " is invalid for this endpoint");
                    searchTypeQNames.add(filterNodeTypeQName);
                    if (includeSubTypes) {
                        Collection qnames = this.dictionaryService.getSubTypes(filterNodeTypeQName, true);
                        searchTypeQNames.addAll(qnames);
                    }
                }
            }
        } else {
            includeRecords = true;
            includeUnfiledRecordFolders = true;
            includeSubTypes = true;
        }
        if (includeUnfiledRecordFolders) {
            searchTypeQNames.add(RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER);
        }
        if (!includeRecords) return searchTypeQNames;
        if (includeSubTypes) {
            Collection qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_CONTENT, true);
            searchTypeQNames.addAll(qnames);
            return searchTypeQNames;
        } else {
            searchTypeQNames.add(ContentModel.TYPE_CONTENT);
            searchTypeQNames.add(RecordsManagementModel.TYPE_NON_ELECTRONIC_DOCUMENT);
        }
        return searchTypeQNames;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<QName> buildSearchTypesCategoriesEndpoint(Parameters parameters, Set<String> listRecordCategoryChildrenEqualsQueryProperties) {
        HashSet<QName> searchTypeQNames = new HashSet<QName>();
        Query q = parameters.getQuery();
        boolean includeRecordFolders = false;
        boolean includeRecordCategories = false;
        if (q != null) {
            MapBasedQueryWalker propertyWalker = new MapBasedQueryWalker(listRecordCategoryChildrenEqualsQueryProperties, null);
            QueryHelper.walk((Query)q, (QueryHelper.WalkerCallback)propertyWalker);
            Boolean isRecordFolder = (Boolean)propertyWalker.getProperty("isRecordFolder", 8, Boolean.class);
            Boolean isRecordCategory = (Boolean)propertyWalker.getProperty("isRecordCategory", 8, Boolean.class);
            if (SearchTypesFactory.checkIncludeUnfiledRecordFolders(isRecordFolder, isRecordCategory)) {
                includeRecordFolders = true;
            } else if (SearchTypesFactory.checkIncludeRecords(isRecordFolder, isRecordCategory)) {
                includeRecordCategories = true;
            }
            String nodeTypeQNameStr = (String)propertyWalker.getProperty("nodeType", 8, String.class);
            if (nodeTypeQNameStr != null) {
                if (isRecordFolder != null || isRecordCategory != null) {
                    throw new InvalidArgumentException("Invalid filter - nodeType and isRecordFolder/isRecordCategory are mutually exclusive");
                }
                Pair<QName, Boolean> pair = this.parseNodeTypeFilter(nodeTypeQNameStr);
                QName filterNodeTypeQName = (QName)pair.getFirst();
                if (filterNodeTypeQName.equals((Object)RecordsManagementModel.TYPE_RECORD_FOLDER)) {
                    includeRecordFolders = true;
                } else {
                    if (!filterNodeTypeQName.equals((Object)RecordsManagementModel.TYPE_RECORD_CATEGORY)) throw new InvalidParameterException("Filter nodeType: " + nodeTypeQNameStr + " is invalid for this endpoint");
                    includeRecordCategories = true;
                }
            }
        } else {
            includeRecordCategories = true;
            includeRecordFolders = true;
        }
        if (includeRecordFolders) {
            searchTypeQNames.add(RecordsManagementModel.TYPE_RECORD_FOLDER);
        }
        if (!includeRecordCategories) return searchTypeQNames;
        searchTypeQNames.add(RecordsManagementModel.TYPE_RECORD_CATEGORY);
        return searchTypeQNames;
    }

    public Set<QName> buildSearchTypesForTransferContainersEndpoint() {
        HashSet<QName> searchTypeQNames = new HashSet<QName>();
        searchTypeQNames.add(RecordsManagementModel.TYPE_TRANSFER);
        return searchTypeQNames;
    }

    private Pair<QName, Boolean> parseNodeTypeFilter(String nodeTypeStr) {
        QName filterNodeTypeQName;
        String suffix;
        boolean filterIncludeSubTypes = false;
        int idx = nodeTypeStr.lastIndexOf(32);
        if (idx > 0 && (suffix = nodeTypeStr.substring(idx)).equalsIgnoreCase(" INCLUDESUBTYPES")) {
            filterIncludeSubTypes = true;
            nodeTypeStr = nodeTypeStr.substring(0, idx);
        }
        if (this.dictionaryService.getType(filterNodeTypeQName = this.nodes.createQName(nodeTypeStr)) == null) {
            throw new InvalidParameterException("Filter nodeType: " + nodeTypeStr + " is invalid");
        }
        return new Pair((Object)filterNodeTypeQName, (Object)filterIncludeSubTypes);
    }

    private static boolean checkIncludeRecords(Boolean isUnfiledRecordFolder, Boolean isRecord) {
        return isUnfiledRecordFolder != null && isUnfiledRecordFolder == false || isRecord != null && isRecord != false;
    }

    private static boolean checkIncludeUnfiledRecordFolders(Boolean isUnfiledRecordFolder, Boolean isRecord) {
        return isUnfiledRecordFolder != null && isUnfiledRecordFolder != false || isRecord != null && isRecord == false;
    }
}

