/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.type;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.identifier.IdentifierService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.model.behaviour.AbstractDisposableItem;
import org.alfresco.module.org_alfresco_module_rm.vital.VitalRecordService;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.extensions.surf.util.I18NUtil;

@BehaviourBean(defaultType="rma:recordFolder")
public class RecordFolderType
extends AbstractDisposableItem
implements NodeServicePolicies.OnMoveNodePolicy,
NodeServicePolicies.OnCreateChildAssociationPolicy {
    protected VitalRecordService vitalRecordService;
    protected IdentifierService identifierService;
    private static final String MSG_CANNOT_CREATE_RECORD_FOLDER_CHILD = "rm.action.create.record.folder.child-error-message";
    private static final String MSG_CANNOT_CREATE_CHILDREN_IN_CLOSED_RECORD_FOLDER = "rm.service.add-children-to-closed-record-folder";

    public void setVitalRecordService(VitalRecordService vitalRecordService) {
        this.vitalRecordService = vitalRecordService;
    }

    public void setIdentifierService(IdentifierService identifierService) {
        this.identifierService = identifierService;
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        if (!this.nodeService.getType(newChildAssocRef.getParentRef()).equals((Object)TYPE_RECORD_FOLDER)) {
            if (!oldChildAssocRef.getParentRef().equals((Object)newChildAssocRef.getParentRef())) {
                this.reinitializeRecordFolder(newChildAssocRef);
            }
        } else {
            throw new UnsupportedOperationException("Cannot move record folder into another record folder.");
        }
    }

    @Behaviour(kind=BehaviourKind.CLASS, policy="alf:getCopyCallback")
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return new DefaultCopyBehaviourCallback(){

            public Map<QName, Serializable> getCopyProperties(QName classRef, CopyDetails copyDetails, Map<QName, Serializable> properties) {
                Map sourceProperties = super.getCopyProperties(classRef, copyDetails, properties);
                if (sourceProperties.containsKey(RecordsManagementModel.PROP_IS_CLOSED)) {
                    sourceProperties.remove(RecordsManagementModel.PROP_IS_CLOSED);
                }
                return sourceProperties;
            }

            public boolean getMustCopy(QName classQName, CopyDetails copyDetails) {
                boolean targetParentIsRecordFolder = RecordFolderType.this.nodeService.getType(copyDetails.getTargetParentNodeRef()).equals((Object)RecordsManagementModel.TYPE_RECORD_FOLDER);
                boolean containsUnwantedAspect = ArrayUtils.contains((Object[])RecordFolderType.this.unwantedAspects, (Object)classQName);
                return !targetParentIsRecordFolder && !containsUnwantedAspect;
            }
        };
    }

    @Behaviour(kind=BehaviourKind.ASSOCIATION, notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void onCreateChildAssociation(ChildAssociationRef childAssocRef, boolean bNew) {
        NodeRef nodeRef = childAssocRef.getChildRef();
        if (this.nodeService.exists(nodeRef)) {
            boolean notFolderOrRmFolderSubType;
            boolean bl = notFolderOrRmFolderSubType = !this.instanceOf(nodeRef, ContentModel.TYPE_FOLDER) || this.instanceOf(nodeRef, RecordsManagementModel.TYPE_RECORDS_MANAGEMENT_CONTAINER) || this.instanceOf(nodeRef, RecordsManagementModel.TYPE_RECORD_FOLDER) || this.instanceOf(nodeRef, RecordsManagementModel.TYPE_TRANSFER);
            if (!this.instanceOf(nodeRef, ContentModel.TYPE_CONTENT) && notFolderOrRmFolderSubType) {
                throw new IntegrityException(I18NUtil.getMessage((String)MSG_CANNOT_CREATE_RECORD_FOLDER_CHILD, (Object[])new Object[]{this.nodeService.getType(nodeRef)}), null);
            }
            NodeRef recordFolder = childAssocRef.getParentRef();
            Boolean isClosed = (Boolean)this.nodeService.getProperty(recordFolder, PROP_IS_CLOSED);
            if (isClosed != null && isClosed.booleanValue()) {
                throw new IntegrityException(I18NUtil.getMessage((String)MSG_CANNOT_CREATE_CHILDREN_IN_CLOSED_RECORD_FOLDER), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Behaviour(kind=BehaviourKind.ASSOCIATION, policy="alf:onCreateChildAssociation", notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onCreateChildAssociationOnCommit(ChildAssociationRef childAssocRef, boolean bNew) {
        final NodeRef child = childAssocRef.getChildRef();
        if (!this.nodeService.exists(child)) {
            return;
        }
        if (this.instanceOf(child, ContentModel.TYPE_FOLDER) && !this.nodeService.hasAspect(child, ContentModel.ASPECT_HIDDEN)) {
            throw new IntegrityException(I18NUtil.getMessage((String)MSG_CANNOT_CREATE_RECORD_FOLDER_CHILD, (Object[])new Object[]{this.nodeService.getType(child)}), null);
        }
        this.behaviourFilter.disableBehaviour();
        try {
            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    RecordFolderType.this.vitalRecordService.setupVitalRecordDefinition(child);
                    return null;
                }
            });
        }
        finally {
            this.behaviourFilter.enableBehaviour();
        }
    }
}

