/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.model.RenditionModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.security.ExtendedSecurityServiceImpl;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.security.permissions.impl.AccessPermissionImpl;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class ExtendedSecurityServiceImplUnitTest {
    @Mock
    private FilePlanService mockedFilePlanService;
    @Mock
    private FilePlanRoleService mockedFilePlanRoleService;
    @Mock
    private AuthorityService mockedAuthorityService;
    @Mock
    private PermissionService mockedPermissionService;
    @Mock
    private TransactionService mockedTransactionService;
    @Mock
    private RetryingTransactionHelper mockedRetryingTransactionHelper;
    @Mock
    private NodeService mockedNodeService;
    @Mock
    private PagingResults<String> mockedReadPagingResults;
    @Mock
    private PagingResults<String> mockedWritePagingResults;
    @Mock
    private ApplicationContext mockedApplicationContext;
    @Mock
    private ChildAssociationRef mockedChildAssociationRef;
    @InjectMocks
    private ExtendedSecurityServiceImpl extendedSecurityService;
    private static final String READER_GROUP_FULL_PREFIX = "GROUP_IPRR";
    private static final String WRITER_GROUP_FULL_PREFIX = "GROUP_IPRW";
    private static final String USER = "USER";
    private static final String GROUP = "GROUP_GROUP";
    private static final String USER_W = "USER_W";
    private static final String GROUP_W = "GROUP_GROUP_W";
    private static final Set<String> READERS = Stream.of("USER", "GROUP_GROUP").collect(Collectors.toSet());
    private static final Set<String> WRITERS = Stream.of("USER_W", "GROUP_GROUP_W").collect(Collectors.toSet());
    private static final Set<AccessPermission> HAS_EXTENDED_SECURITY = Stream.of(new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, "GROUP_IPRR", 0), new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, AlfMock.generateText(), 1), new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, "GROUP_IPRW", 2)).collect(Collectors.toSet());
    private static final Set<AccessPermission> HAS_NO_EXTENDED_SECURITY = Stream.of(new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, AlfMock.generateText(), 0), new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, AlfMock.generateText(), 1), new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, AlfMock.generateText(), 2)).collect(Collectors.toSet());
    private NodeRef nodeRef;
    private NodeRef filePlan;
    private String readGroupPrefix;
    private String writeGroupPrefix;

    @Before
    public void before() {
        this.nodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
        this.filePlan = AlfMock.generateNodeRef(this.mockedNodeService);
        Mockito.when((Object)this.mockedFilePlanService.getFilePlan((NodeRef)ArgumentMatchers.any(NodeRef.class))).thenReturn((Object)this.filePlan);
        Mockito.lenient().when(this.mockedApplicationContext.getBean("dbNodeService")).thenReturn((Object)this.mockedNodeService);
        Answer<Object> doInTransactionAnswer = new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                RetryingTransactionHelper.RetryingTransactionCallback callback = (RetryingTransactionHelper.RetryingTransactionCallback)invocation.getArguments()[0];
                return callback.execute();
            }
        };
        ((RetryingTransactionHelper)Mockito.doAnswer((Answer)doInTransactionAnswer).when((Object)this.mockedRetryingTransactionHelper)).doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)ArgumentMatchers.any(RetryingTransactionHelper.RetryingTransactionCallback.class));
        Mockito.when((Object)this.mockedTransactionService.getRetryingTransactionHelper()).thenReturn((Object)this.mockedRetryingTransactionHelper);
        Answer<String> createAuthorityAnswer = new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return "GROUP_" + (String)invocation.getArguments()[1];
            }
        };
        Mockito.when((Object)this.mockedAuthorityService.createAuthority((AuthorityType)ArgumentMatchers.any(AuthorityType.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anySet())).thenAnswer((Answer)createAuthorityAnswer);
        this.readGroupPrefix = this.extendedSecurityService.getIPRGroupPrefixShortName("IPRR", READERS);
        this.writeGroupPrefix = this.extendedSecurityService.getIPRGroupPrefixShortName("IPRW", WRITERS);
        Stream.of(USER, USER_W, GROUP, GROUP_W).forEach(a -> Mockito.when((Object)this.mockedAuthorityService.authorityExists(a)).thenReturn((Object)true));
        this.extendedSecurityService.setNodeService(this.mockedNodeService);
    }

    @Test
    public void rootAuthorityDoesNotExist() {
        Mockito.when((Object)this.mockedAuthorityService.authorityExists("GROUP_INPLACE_RECORD_MANAGEMENT")).thenReturn((Object)false);
        this.extendedSecurityService.onApplicationEvent((ContextRefreshedEvent)Mockito.mock(ContextRefreshedEvent.class));
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).createAuthority(AuthorityType.GROUP, "INPLACE_RECORD_MANAGEMENT", "INPLACE_RECORD_MANAGEMENT", Collections.singleton("APP.RM"));
    }

    @Test
    public void rootAuthorityDoesExist() {
        Mockito.when((Object)this.mockedAuthorityService.authorityExists("GROUP_INPLACE_RECORD_MANAGEMENT")).thenReturn((Object)true);
        this.extendedSecurityService.onApplicationEvent((ContextRefreshedEvent)Mockito.mock(ContextRefreshedEvent.class));
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.never())).createAuthority(AuthorityType.GROUP, "INPLACE_RECORD_MANAGEMENT", "INPLACE_RECORD_MANAGEMENT", Collections.singleton("APP.RM"));
    }

    @Test
    public void hasExtendedSecurityWithReadAndWriteGroups() {
        Mockito.when((Object)this.mockedPermissionService.getAllSetPermissions(this.nodeRef)).thenReturn(HAS_EXTENDED_SECURITY);
        Assert.assertTrue((boolean)this.extendedSecurityService.hasExtendedSecurity(this.nodeRef));
    }

    @Test
    public void hasExtendedSecurityWithNoReadGroup() {
        Set permissions = Stream.of(new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, AlfMock.generateText(), 0), new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, AlfMock.generateText(), 1), new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, WRITER_GROUP_FULL_PREFIX, 2)).collect(Collectors.toSet());
        Mockito.when((Object)this.mockedPermissionService.getAllSetPermissions(this.nodeRef)).thenReturn(permissions);
        Assert.assertFalse((boolean)this.extendedSecurityService.hasExtendedSecurity(this.nodeRef));
    }

    @Test
    public void hasExtendedSecurityWithNoWriteGroup() {
        Set permissions = Stream.of(new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, READER_GROUP_FULL_PREFIX, 0), new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, AlfMock.generateText(), 1), new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, AlfMock.generateText(), 2)).collect(Collectors.toSet());
        Mockito.when((Object)this.mockedPermissionService.getAllSetPermissions(this.nodeRef)).thenReturn(permissions);
        Assert.assertFalse((boolean)this.extendedSecurityService.hasExtendedSecurity(this.nodeRef));
    }

    @Test
    public void hasExtendedSecurityWithNoAssignedGroups() {
        Mockito.when((Object)this.mockedPermissionService.getAllSetPermissions(this.nodeRef)).thenReturn(HAS_NO_EXTENDED_SECURITY);
        Assert.assertFalse((boolean)this.extendedSecurityService.hasExtendedSecurity(this.nodeRef));
    }

    @Test
    public void getExtendedReadersNoIPRGroupsAssigned() {
        Mockito.when((Object)this.mockedPermissionService.getAllSetPermissions(this.nodeRef)).thenReturn(HAS_NO_EXTENDED_SECURITY);
        Assert.assertTrue((boolean)this.extendedSecurityService.getReaders(this.nodeRef).isEmpty());
    }

    @Test
    public void getExtendedReaders() {
        Mockito.when((Object)this.mockedPermissionService.getAllSetPermissions(this.nodeRef)).thenReturn(HAS_EXTENDED_SECURITY);
        Mockito.when((Object)this.mockedAuthorityService.getContainedAuthorities(null, READER_GROUP_FULL_PREFIX, true)).thenReturn(Stream.of(USER, GROUP).collect(Collectors.toSet()));
        Set extendedReaders = this.extendedSecurityService.getReaders(this.nodeRef);
        Assert.assertEquals(Stream.of(USER, GROUP).collect(Collectors.toSet()), (Object)extendedReaders);
    }

    @Test
    public void getExtendedWritersNoIPRGroupsAssigned() {
        Mockito.when((Object)this.mockedPermissionService.getAllSetPermissions(this.nodeRef)).thenReturn(HAS_NO_EXTENDED_SECURITY);
        Assert.assertTrue((boolean)this.extendedSecurityService.getWriters(this.nodeRef).isEmpty());
    }

    @Test
    public void getExtendedWriters() {
        Mockito.when((Object)this.mockedPermissionService.getAllSetPermissions(this.nodeRef)).thenReturn(HAS_EXTENDED_SECURITY);
        Mockito.when((Object)this.mockedAuthorityService.getContainedAuthorities(null, WRITER_GROUP_FULL_PREFIX, true)).thenReturn(Stream.of(USER, GROUP).collect(Collectors.toSet()));
        Set extendedWriters = this.extendedSecurityService.getWriters(this.nodeRef);
        Assert.assertEquals(Stream.of(USER, GROUP).collect(Collectors.toSet()), (Object)extendedWriters);
    }

    @Test
    public void addExtendedSecurityForTheFirstTimeAndCreateGroups() {
        Object readGroup = this.extendedSecurityService.getIPRGroupShortName("IPRR", READERS, 0);
        Object writeGroup = this.extendedSecurityService.getIPRGroupShortName("IPRW", WRITERS, 0);
        Mockito.when((Object)this.mockedReadPagingResults.getPage()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.mockedAuthorityService.getAuthorities((AuthorityType)ArgumentMatchers.eq((Object)AuthorityType.GROUP), (String)ArgumentMatchers.eq((Object)"APP.RM"), (String)ArgumentMatchers.any(String.class), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false), (PagingRequest)ArgumentMatchers.any(PagingRequest.class))).thenReturn(this.mockedReadPagingResults);
        this.extendedSecurityService.set(this.nodeRef, READERS, WRITERS);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.never())).clearPermission((NodeRef)ArgumentMatchers.eq((Object)this.nodeRef), ArgumentMatchers.anyString());
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).createAuthority(AuthorityType.GROUP, (String)readGroup, (String)readGroup, Collections.singleton("APP.RM"));
        readGroup = "GROUP_" + (String)readGroup;
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority("GROUP_INPLACE_RECORD_MANAGEMENT", (String)readGroup);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority((String)readGroup, USER);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority((String)readGroup, GROUP);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).createAuthority(AuthorityType.GROUP, (String)writeGroup, (String)writeGroup, Collections.singleton("APP.RM"));
        writeGroup = "GROUP_" + (String)writeGroup;
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority("GROUP_INPLACE_RECORD_MANAGEMENT", (String)writeGroup);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority((String)writeGroup, USER_W);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority((String)writeGroup, GROUP_W);
        ((FilePlanRoleService)Mockito.verify((Object)this.mockedFilePlanRoleService)).assignRoleToAuthority(this.filePlan, "ExtendedReaders", (String)readGroup);
        ((FilePlanRoleService)Mockito.verify((Object)this.mockedFilePlanRoleService)).assignRoleToAuthority(this.filePlan, "ExtendedWriters", (String)writeGroup);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).setPermission(this.nodeRef, (String)readGroup, "ReadRecords", true);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).setPermission(this.nodeRef, (String)writeGroup, "Filing", true);
    }

    @Test
    public void addExtendedSecurityForTheFirstTimeAndReuseGroups() {
        String readGroup = this.readGroupPrefix + "0";
        String writeGroup = this.writeGroupPrefix + "0";
        Mockito.when((Object)this.mockedReadPagingResults.getPage()).thenReturn(Stream.of("GROUP_" + readGroup).collect(Collectors.toList()));
        Mockito.when((Object)this.mockedAuthorityService.getAuthorities((AuthorityType)ArgumentMatchers.eq((Object)AuthorityType.GROUP), (String)ArgumentMatchers.eq((Object)"APP.RM"), (String)ArgumentMatchers.eq((Object)this.readGroupPrefix), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false), (PagingRequest)ArgumentMatchers.any(PagingRequest.class))).thenReturn(this.mockedReadPagingResults);
        Mockito.when((Object)this.mockedWritePagingResults.getPage()).thenReturn(Stream.of("GROUP_" + writeGroup).collect(Collectors.toList()));
        Mockito.when((Object)this.mockedAuthorityService.getAuthorities((AuthorityType)ArgumentMatchers.eq((Object)AuthorityType.GROUP), (String)ArgumentMatchers.eq((Object)"APP.RM"), (String)ArgumentMatchers.eq((Object)this.writeGroupPrefix), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false), (PagingRequest)ArgumentMatchers.any(PagingRequest.class))).thenReturn(this.mockedWritePagingResults);
        Mockito.lenient().when((Object)this.mockedAuthorityService.authorityExists("GROUP_" + writeGroup)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedAuthorityService.getContainedAuthorities(null, "GROUP_" + readGroup, true)).thenReturn(Stream.of(USER, GROUP).collect(Collectors.toSet()));
        Mockito.when((Object)this.mockedAuthorityService.getContainedAuthorities(null, "GROUP_" + writeGroup, true)).thenReturn(Stream.of(USER_W, GROUP_W).collect(Collectors.toSet()));
        this.extendedSecurityService.set(this.nodeRef, READERS, WRITERS);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.never())).clearPermission((NodeRef)ArgumentMatchers.eq((Object)this.nodeRef), ArgumentMatchers.anyString());
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.never())).createAuthority(AuthorityType.GROUP, readGroup, readGroup, Collections.singleton("APP.RM"));
        readGroup = "GROUP_" + readGroup;
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.never())).addAuthority("GROUP_INPLACE_RECORD_MANAGEMENT", readGroup);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.never())).addAuthority(readGroup, USER);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.never())).addAuthority(readGroup, GROUP);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.never())).createAuthority(AuthorityType.GROUP, writeGroup, writeGroup, Collections.singleton("APP.RM"));
        writeGroup = "GROUP_" + writeGroup;
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.never())).addAuthority(readGroup, writeGroup);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.never())).addAuthority(writeGroup, USER_W);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.never())).addAuthority(writeGroup, GROUP_W);
        ((FilePlanRoleService)Mockito.verify((Object)this.mockedFilePlanRoleService)).assignRoleToAuthority(this.filePlan, "ExtendedReaders", readGroup);
        ((FilePlanRoleService)Mockito.verify((Object)this.mockedFilePlanRoleService)).assignRoleToAuthority(this.filePlan, "ExtendedWriters", writeGroup);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).setPermission(this.nodeRef, readGroup, "ReadRecords", true);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).setPermission(this.nodeRef, writeGroup, "Filing", true);
    }

    @Test
    public void addExtendedSecurityForTheFirstTimeAndCreateGroupsAfterClash() {
        Object readGroup = this.readGroupPrefix + "0";
        Object writeGroup = this.writeGroupPrefix + "0";
        Mockito.when((Object)this.mockedReadPagingResults.getPage()).thenReturn(Stream.of("GROUP_" + (String)readGroup).collect(Collectors.toList()));
        Mockito.when((Object)this.mockedAuthorityService.getAuthorities((AuthorityType)ArgumentMatchers.eq((Object)AuthorityType.GROUP), (String)ArgumentMatchers.eq((Object)"APP.RM"), (String)ArgumentMatchers.eq((Object)this.readGroupPrefix), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false), (PagingRequest)ArgumentMatchers.any(PagingRequest.class))).thenReturn(this.mockedReadPagingResults);
        Mockito.when((Object)this.mockedWritePagingResults.getPage()).thenReturn(Stream.of("GROUP_" + (String)writeGroup).collect(Collectors.toList()));
        Mockito.when((Object)this.mockedAuthorityService.getAuthorities((AuthorityType)ArgumentMatchers.eq((Object)AuthorityType.GROUP), (String)ArgumentMatchers.eq((Object)"APP.RM"), (String)ArgumentMatchers.eq((Object)this.writeGroupPrefix), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false), (PagingRequest)ArgumentMatchers.any(PagingRequest.class))).thenReturn(this.mockedWritePagingResults);
        Mockito.lenient().when((Object)this.mockedAuthorityService.authorityExists("GROUP_" + (String)writeGroup)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedAuthorityService.getContainedAuthorities(null, "GROUP_" + (String)readGroup, true)).thenReturn(Stream.of(USER, GROUP, AlfMock.generateText()).collect(Collectors.toSet()));
        Mockito.when((Object)this.mockedAuthorityService.getContainedAuthorities(null, "GROUP_" + (String)writeGroup, true)).thenReturn(Stream.of(USER_W, AlfMock.generateText()).collect(Collectors.toSet()));
        this.extendedSecurityService.set(this.nodeRef, READERS, WRITERS);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.never())).clearPermission((NodeRef)ArgumentMatchers.eq((Object)this.nodeRef), ArgumentMatchers.anyString());
        readGroup = this.extendedSecurityService.getIPRGroupShortName("IPRR", READERS, 1);
        writeGroup = this.extendedSecurityService.getIPRGroupShortName("IPRW", WRITERS, 1);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).createAuthority(AuthorityType.GROUP, (String)readGroup, (String)readGroup, Collections.singleton("APP.RM"));
        readGroup = "GROUP_" + (String)readGroup;
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority("GROUP_INPLACE_RECORD_MANAGEMENT", (String)readGroup);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority((String)readGroup, USER);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority((String)readGroup, GROUP);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).createAuthority(AuthorityType.GROUP, (String)writeGroup, (String)writeGroup, Collections.singleton("APP.RM"));
        writeGroup = "GROUP_" + (String)writeGroup;
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority("GROUP_INPLACE_RECORD_MANAGEMENT", (String)writeGroup);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority((String)writeGroup, USER_W);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority((String)writeGroup, GROUP_W);
        ((FilePlanRoleService)Mockito.verify((Object)this.mockedFilePlanRoleService)).assignRoleToAuthority(this.filePlan, "ExtendedReaders", (String)readGroup);
        ((FilePlanRoleService)Mockito.verify((Object)this.mockedFilePlanRoleService)).assignRoleToAuthority(this.filePlan, "ExtendedWriters", (String)writeGroup);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).setPermission(this.nodeRef, (String)readGroup, "ReadRecords", true);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).setPermission(this.nodeRef, (String)writeGroup, "Filing", true);
    }

    @Test
    public void addExtendedSecurityWithResultPaging() {
        String readGroup = this.readGroupPrefix + "0";
        String writeGroup = this.writeGroupPrefix + "0";
        ArrayList<String> fiftyResults = new ArrayList<String>(50);
        for (int i = 0; i < 50; ++i) {
            fiftyResults.add(AlfMock.generateText());
        }
        Mockito.when((Object)this.mockedReadPagingResults.getPage()).thenReturn(fiftyResults).thenReturn(Stream.of("GROUP_" + readGroup).collect(Collectors.toList()));
        Mockito.when((Object)this.mockedAuthorityService.getAuthorities((AuthorityType)ArgumentMatchers.eq((Object)AuthorityType.GROUP), (String)ArgumentMatchers.eq((Object)"APP.RM"), (String)ArgumentMatchers.eq((Object)this.readGroupPrefix), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false), (PagingRequest)ArgumentMatchers.any(PagingRequest.class))).thenReturn(this.mockedReadPagingResults);
        Mockito.when((Object)this.mockedWritePagingResults.getPage()).thenReturn(fiftyResults).thenReturn(Stream.of("GROUP_" + writeGroup).collect(Collectors.toList()));
        Mockito.when((Object)this.mockedAuthorityService.getAuthorities((AuthorityType)ArgumentMatchers.eq((Object)AuthorityType.GROUP), (String)ArgumentMatchers.eq((Object)"APP.RM"), (String)ArgumentMatchers.eq((Object)this.writeGroupPrefix), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false), (PagingRequest)ArgumentMatchers.any(PagingRequest.class))).thenReturn(this.mockedWritePagingResults);
        Mockito.lenient().when((Object)this.mockedAuthorityService.authorityExists("GROUP_" + writeGroup)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedAuthorityService.getContainedAuthorities(null, "GROUP_" + readGroup, true)).thenReturn(Stream.of(USER, GROUP).collect(Collectors.toSet()));
        Mockito.when((Object)this.mockedAuthorityService.getContainedAuthorities(null, "GROUP_" + writeGroup, true)).thenReturn(Stream.of(USER_W, GROUP_W).collect(Collectors.toSet()));
        this.extendedSecurityService.set(this.nodeRef, READERS, WRITERS);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.never())).clearPermission((NodeRef)ArgumentMatchers.eq((Object)this.nodeRef), ArgumentMatchers.anyString());
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.never())).createAuthority(AuthorityType.GROUP, readGroup, readGroup, Collections.singleton("APP.RM"));
        readGroup = "GROUP_" + readGroup;
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.never())).addAuthority("GROUP_INPLACE_RECORD_MANAGEMENT", readGroup);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.never())).addAuthority(readGroup, USER);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.never())).addAuthority(readGroup, GROUP);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.never())).createAuthority(AuthorityType.GROUP, writeGroup, writeGroup, Collections.singleton("APP.RM"));
        writeGroup = "GROUP_" + writeGroup;
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.never())).addAuthority(readGroup, writeGroup);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.never())).addAuthority(writeGroup, USER_W);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.never())).addAuthority(writeGroup, GROUP_W);
        ((FilePlanRoleService)Mockito.verify((Object)this.mockedFilePlanRoleService)).assignRoleToAuthority(this.filePlan, "ExtendedReaders", readGroup);
        ((FilePlanRoleService)Mockito.verify((Object)this.mockedFilePlanRoleService)).assignRoleToAuthority(this.filePlan, "ExtendedWriters", writeGroup);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).setPermission(this.nodeRef, readGroup, "ReadRecords", true);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).setPermission(this.nodeRef, writeGroup, "Filing", true);
    }

    @Test
    public void addExtendedSecurityToNodeWithExtendedSecurity() {
        String readGroup = this.extendedSecurityService.getIPRGroupShortName(READER_GROUP_FULL_PREFIX, READERS, 0);
        String writeGroup = this.extendedSecurityService.getIPRGroupShortName(WRITER_GROUP_FULL_PREFIX, WRITERS, 0);
        Set permissions = Stream.of(new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, readGroup, 0), new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, AlfMock.generateText(), 1), new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, writeGroup, 2)).collect(Collectors.toSet());
        Mockito.when((Object)this.mockedPermissionService.getAllSetPermissions(this.nodeRef)).thenReturn(permissions);
        String user = AlfMock.generateText();
        String group = AlfMock.generateText();
        String userW = AlfMock.generateText();
        String groupW = AlfMock.generateText();
        Set newReaders = Stream.of(user, group).collect(Collectors.toSet());
        Set newWriters = Stream.of(userW, groupW).collect(Collectors.toSet());
        Object newReadGroup = this.extendedSecurityService.getIPRGroupShortName("IPRR", newReaders, 0);
        Object newWriteGroup = this.extendedSecurityService.getIPRGroupShortName("IPRW", newWriters, 0);
        Stream.of(user, group, userW, groupW).forEach(a -> Mockito.when((Object)this.mockedAuthorityService.authorityExists(a)).thenReturn((Object)true));
        Mockito.when((Object)this.mockedReadPagingResults.getPage()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.mockedAuthorityService.getAuthorities((AuthorityType)ArgumentMatchers.eq((Object)AuthorityType.GROUP), (String)ArgumentMatchers.eq((Object)"APP.RM"), (String)ArgumentMatchers.any(String.class), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false), (PagingRequest)ArgumentMatchers.any(PagingRequest.class))).thenReturn(this.mockedReadPagingResults);
        this.extendedSecurityService.set(this.nodeRef, newReaders, newWriters);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).clearPermission(this.nodeRef, readGroup);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).clearPermission(this.nodeRef, writeGroup);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).createAuthority(AuthorityType.GROUP, (String)newReadGroup, (String)newReadGroup, Collections.singleton("APP.RM"));
        newReadGroup = "GROUP_" + (String)newReadGroup;
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority("GROUP_INPLACE_RECORD_MANAGEMENT", (String)newReadGroup);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority((String)newReadGroup, user);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority((String)newReadGroup, group);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).createAuthority(AuthorityType.GROUP, (String)newWriteGroup, (String)newWriteGroup, Collections.singleton("APP.RM"));
        newWriteGroup = "GROUP_" + (String)newWriteGroup;
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority("GROUP_INPLACE_RECORD_MANAGEMENT", (String)newWriteGroup);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority((String)newWriteGroup, userW);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority((String)newWriteGroup, groupW);
        ((FilePlanRoleService)Mockito.verify((Object)this.mockedFilePlanRoleService)).assignRoleToAuthority(this.filePlan, "ExtendedReaders", (String)newReadGroup);
        ((FilePlanRoleService)Mockito.verify((Object)this.mockedFilePlanRoleService)).assignRoleToAuthority(this.filePlan, "ExtendedWriters", (String)newWriteGroup);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).setPermission(this.nodeRef, (String)newReadGroup, "ReadRecords", true);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).setPermission(this.nodeRef, (String)newWriteGroup, "Filing", true);
    }

    @Test
    public void extendedSecurityAddedToRenditions() {
        Object readGroup = this.extendedSecurityService.getIPRGroupShortName("IPRR", READERS, 0);
        Object writeGroup = this.extendedSecurityService.getIPRGroupShortName("IPRW", WRITERS, 0);
        Mockito.when((Object)this.mockedReadPagingResults.getPage()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.mockedAuthorityService.getAuthorities((AuthorityType)ArgumentMatchers.eq((Object)AuthorityType.GROUP), (String)ArgumentMatchers.eq((Object)"APP.RM"), (String)ArgumentMatchers.any(String.class), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false), (PagingRequest)ArgumentMatchers.any(PagingRequest.class))).thenReturn(this.mockedReadPagingResults);
        NodeRef renditionNodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
        Mockito.when((Object)this.mockedNodeService.hasAspect(this.nodeRef, RecordsManagementModel.ASPECT_RECORD)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedChildAssociationRef.getChildRef()).thenReturn((Object)renditionNodeRef);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(this.nodeRef, (QNamePattern)RenditionModel.ASSOC_RENDITION, RegexQNamePattern.MATCH_ALL)).thenReturn(Collections.singletonList(this.mockedChildAssociationRef));
        this.extendedSecurityService.set(this.nodeRef, READERS, WRITERS);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.never())).clearPermission((NodeRef)ArgumentMatchers.eq((Object)this.nodeRef), ArgumentMatchers.anyString());
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).createAuthority(AuthorityType.GROUP, (String)readGroup, (String)readGroup, Collections.singleton("APP.RM"));
        readGroup = "GROUP_" + (String)readGroup;
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority("GROUP_INPLACE_RECORD_MANAGEMENT", (String)readGroup);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority((String)readGroup, USER);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority((String)readGroup, GROUP);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).createAuthority(AuthorityType.GROUP, (String)writeGroup, (String)writeGroup, Collections.singleton("APP.RM"));
        writeGroup = "GROUP_" + (String)writeGroup;
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority("GROUP_INPLACE_RECORD_MANAGEMENT", (String)writeGroup);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority((String)writeGroup, USER_W);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService)).addAuthority((String)writeGroup, GROUP_W);
        ((FilePlanRoleService)Mockito.verify((Object)this.mockedFilePlanRoleService)).assignRoleToAuthority(this.filePlan, "ExtendedReaders", (String)readGroup);
        ((FilePlanRoleService)Mockito.verify((Object)this.mockedFilePlanRoleService)).assignRoleToAuthority(this.filePlan, "ExtendedWriters", (String)writeGroup);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).setPermission(this.nodeRef, (String)readGroup, "ReadRecords", true);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).setPermission(this.nodeRef, (String)writeGroup, "Filing", true);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).setPermission(renditionNodeRef, (String)readGroup, "ReadRecords", true);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).setPermission(renditionNodeRef, (String)writeGroup, "Filing", true);
    }

    @Test
    public void removeAllExtendedSecurity() {
        String readGroup = this.extendedSecurityService.getIPRGroupShortName(READER_GROUP_FULL_PREFIX, READERS, 0);
        String writeGroup = this.extendedSecurityService.getIPRGroupShortName(WRITER_GROUP_FULL_PREFIX, WRITERS, 0);
        Set permissions = Stream.of(new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, readGroup, 0), new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, AlfMock.generateText(), 1), new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, writeGroup, 2)).collect(Collectors.toSet());
        Mockito.when((Object)this.mockedPermissionService.getAllSetPermissions(this.nodeRef)).thenReturn(permissions);
        this.extendedSecurityService.remove(this.nodeRef);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).clearPermission(this.nodeRef, readGroup);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).clearPermission(this.nodeRef, writeGroup);
    }

    @Test
    public void noExtendedSecurityToRemove() {
        Mockito.when((Object)this.mockedPermissionService.getAllSetPermissions(this.nodeRef)).thenReturn(HAS_NO_EXTENDED_SECURITY);
        this.extendedSecurityService.remove(this.nodeRef);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.never())).clearPermission((NodeRef)ArgumentMatchers.eq((Object)this.nodeRef), ArgumentMatchers.anyString());
    }

    @Test
    public void removeExtendedSecurityFromRenditions() {
        String readGroup = this.extendedSecurityService.getIPRGroupShortName(READER_GROUP_FULL_PREFIX, READERS, 0);
        String writeGroup = this.extendedSecurityService.getIPRGroupShortName(WRITER_GROUP_FULL_PREFIX, WRITERS, 0);
        NodeRef renditionNodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
        Mockito.when((Object)this.mockedNodeService.hasAspect(this.nodeRef, RecordsManagementModel.ASPECT_RECORD)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedChildAssociationRef.getChildRef()).thenReturn((Object)renditionNodeRef);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(this.nodeRef, (QNamePattern)RenditionModel.ASSOC_RENDITION, RegexQNamePattern.MATCH_ALL)).thenReturn(Collections.singletonList(this.mockedChildAssociationRef));
        Set permissions = Stream.of(new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, readGroup, 0), new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, AlfMock.generateText(), 1), new AccessPermissionImpl(AlfMock.generateText(), AccessStatus.ALLOWED, writeGroup, 2)).collect(Collectors.toSet());
        Mockito.when((Object)this.mockedPermissionService.getAllSetPermissions(this.nodeRef)).thenReturn(permissions);
        this.extendedSecurityService.remove(this.nodeRef);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).clearPermission(this.nodeRef, readGroup);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).clearPermission(this.nodeRef, writeGroup);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).clearPermission(renditionNodeRef, readGroup);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).clearPermission(renditionNodeRef, writeGroup);
    }
}

