/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.audit.event;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.lang3.StringUtils;

public class UserGroupMembershipUtils {
    public static final QName PARENT_GROUP = QName.createQName((String)"http://www.alfresco.org/model/recordsmanagement/1.0", (String)"Parent Group");
    private static final QName CHILD_GROUP = QName.createQName((String)"http://www.alfresco.org/model/recordsmanagement/1.0", (String)"Child Group");

    public static Map<QName, Serializable> makePropertiesMap(ChildAssociationRef childAssocRef, NodeService nodeService) {
        String childUserName;
        HashMap<QName, Serializable> auditProperties = new HashMap<QName, Serializable>();
        String childGroupName = UserGroupMembershipUtils.getUserGroupName(childAssocRef.getChildRef(), nodeService);
        if (!StringUtils.isBlank((CharSequence)childGroupName)) {
            auditProperties.put(CHILD_GROUP, (Serializable)((Object)childGroupName));
        }
        if (!StringUtils.isBlank((CharSequence)(childUserName = (String)((Object)nodeService.getProperty(childAssocRef.getChildRef(), ContentModel.PROP_USERNAME))))) {
            auditProperties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)childUserName));
        }
        auditProperties.put(PARENT_GROUP, (Serializable)((Object)UserGroupMembershipUtils.getUserGroupName(childAssocRef.getParentRef(), nodeService)));
        return auditProperties;
    }

    private static String getUserGroupName(NodeRef nodeRef, NodeService nodeService) {
        String groupName = (String)((Object)nodeService.getProperty(nodeRef, ContentModel.PROP_AUTHORITY_DISPLAY_NAME));
        if (StringUtils.isBlank((CharSequence)groupName)) {
            groupName = (String)((Object)nodeService.getProperty(nodeRef, ContentModel.PROP_AUTHORITY_NAME));
        }
        return groupName;
    }
}

