/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.disposition;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DispositionSelectionStrategy
implements RecordsManagementModel {
    private static Log logger = LogFactory.getLog(DispositionSelectionStrategy.class);
    private DispositionService dispositionService;

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public NodeRef selectDispositionScheduleFrom(List<NodeRef> recordFolders) {
        if (recordFolders == null || recordFolders.isEmpty()) {
            return null;
        }
        NodeRef recordFolder = null;
        if (recordFolders.size() == 1) {
            recordFolder = recordFolders.get(0);
        } else {
            TreeSet<NodeRef> sortedFolders = new TreeSet<NodeRef>(new DispositionableNodeRefComparator());
            sortedFolders.addAll(recordFolders);
            recordFolder = (NodeRef)sortedFolders.first();
        }
        DispositionSchedule dispSchedule = this.dispositionService.getDispositionSchedule(recordFolder);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Selected retention schedule: " + String.valueOf(dispSchedule)));
        }
        NodeRef result = null;
        if (dispSchedule != null) {
            result = dispSchedule.getNodeRef();
        }
        return result;
    }

    class DispositionableNodeRefComparator
    implements Comparator<NodeRef> {
        DispositionableNodeRefComparator() {
        }

        @Override
        public int compare(final NodeRef f1, final NodeRef f2) {
            return (Integer)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Integer>(){

                public Integer doWork() {
                    return DispositionableNodeRefComparator.this.compareImpl(f1, f2);
                }
            }, (String)AuthenticationUtil.getAdminUserName());
        }

        private int compareImpl(NodeRef f1, NodeRef f2) {
            if (f1.equals((Object)f2)) {
                return 0;
            }
            DispositionSchedule ds1 = DispositionSelectionStrategy.this.dispositionService.getDispositionSchedule(f1);
            DispositionSchedule ds2 = DispositionSelectionStrategy.this.dispositionService.getDispositionSchedule(f2);
            if (ds1 == null && ds2 != null) {
                return 1;
            }
            if (ds1 != null && ds2 == null) {
                return -1;
            }
            if (ds1 == null && ds2 == null) {
                return 0;
            }
            DispositionAction da1 = DispositionSelectionStrategy.this.dispositionService.getNextDispositionAction(f1);
            DispositionAction da2 = DispositionSelectionStrategy.this.dispositionService.getNextDispositionAction(f2);
            if (da1 != null && da2 != null) {
                Date asOfDate1 = da1.getAsOfDate();
                Date asOfDate2 = da2.getAsOfDate();
                if (asOfDate1 != null && asOfDate2 != null) {
                    return asOfDate1.compareTo(asOfDate2);
                }
                if (asOfDate1 != null || asOfDate2 != null) {
                    return asOfDate1 == null ? 1 : -1;
                }
                DispositionActionDefinition dad1 = da1.getDispositionActionDefinition();
                DispositionActionDefinition dad2 = da2.getDispositionActionDefinition();
                int eventsCount1 = 0;
                int eventsCount2 = 0;
                if (dad1 != null) {
                    eventsCount1 = dad1.getEvents().size();
                }
                if (dad2 != null) {
                    eventsCount2 = dad2.getEvents().size();
                }
                return Integer.valueOf(eventsCount1).compareTo(eventsCount2);
            }
            return 0;
        }
    }
}

