/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.hold;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldServicePolicies;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.util.ServiceBaseImpl;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

@BehaviourBean
public class HoldServiceImpl
extends ServiceBaseImpl
implements HoldService,
NodeServicePolicies.BeforeDeleteNodePolicy,
RecordsManagementModel {
    private static Log logger = LogFactory.getLog(HoldServiceImpl.class);
    private static final String MSG_ERR_ACCESS_DENIED = "permissions.err_access_denied";
    private static final String MSG_ERR_HOLD_PERMISSION_GENERIC_ERROR = "rm.hold.generic-permission-error";
    private static final String MSG_ERR_HOLD_PERMISSION_DETAILED_ERROR = "rm.hold.detailed-permission-error";
    private static final int MAX_HELD_ITEMS_LIST_SIZE = 5;
    private FilePlanService filePlanService;
    private RecordService recordService;
    private RecordFolderService recordFolderService;
    private PermissionService permissionService;
    private CapabilityService capabilityService;
    private PolicyComponent policyComponent;
    private ClassPolicyDelegate<HoldServicePolicies.BeforeCreateHoldPolicy> beforeCreateHoldPolicyDelegate;
    private ClassPolicyDelegate<HoldServicePolicies.OnCreateHoldPolicy> onCreateHoldPolicyDelegate;
    private ClassPolicyDelegate<HoldServicePolicies.BeforeDeleteHoldPolicy> beforeDeleteHoldPolicyDelegate;
    private ClassPolicyDelegate<HoldServicePolicies.OnDeleteHoldPolicy> onDeleteHoldPolicyDelegate;
    private ClassPolicyDelegate<HoldServicePolicies.BeforeAddToHoldPolicy> beforeAddToHoldPolicyDelegate;
    private ClassPolicyDelegate<HoldServicePolicies.OnAddToHoldPolicy> onAddToHoldPolicyDelegate;
    private ClassPolicyDelegate<HoldServicePolicies.BeforeRemoveFromHoldPolicy> beforeRemoveFromHoldPolicyDelegate;
    private ClassPolicyDelegate<HoldServicePolicies.OnRemoveFromHoldPolicy> onRemoveFromHoldPolicyDelegate;

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setRecordFolderService(RecordFolderService recordFolderService) {
        this.recordFolderService = recordFolderService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    protected PolicyComponent getPolicyComponent() {
        return this.policyComponent;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void init() {
        this.beforeCreateHoldPolicyDelegate = this.getPolicyComponent().registerClassPolicy(HoldServicePolicies.BeforeCreateHoldPolicy.class);
        this.onCreateHoldPolicyDelegate = this.getPolicyComponent().registerClassPolicy(HoldServicePolicies.OnCreateHoldPolicy.class);
        this.beforeDeleteHoldPolicyDelegate = this.getPolicyComponent().registerClassPolicy(HoldServicePolicies.BeforeDeleteHoldPolicy.class);
        this.onDeleteHoldPolicyDelegate = this.getPolicyComponent().registerClassPolicy(HoldServicePolicies.OnDeleteHoldPolicy.class);
        this.beforeAddToHoldPolicyDelegate = this.getPolicyComponent().registerClassPolicy(HoldServicePolicies.BeforeAddToHoldPolicy.class);
        this.onAddToHoldPolicyDelegate = this.getPolicyComponent().registerClassPolicy(HoldServicePolicies.OnAddToHoldPolicy.class);
        this.beforeRemoveFromHoldPolicyDelegate = this.getPolicyComponent().registerClassPolicy(HoldServicePolicies.BeforeRemoveFromHoldPolicy.class);
        this.onRemoveFromHoldPolicyDelegate = this.getPolicyComponent().registerClassPolicy(HoldServicePolicies.OnRemoveFromHoldPolicy.class);
    }

    @Behaviour(kind=BehaviourKind.CLASS, type="rma:hold", notificationFrequency=Behaviour.NotificationFrequency.EVERY_EVENT)
    public void beforeDeleteNode(final NodeRef hold) {
        if (this.nodeService.exists(hold) && this.isHold(hold)) {
            this.checkPermissionsForDeleteHold(hold);
            AuthenticationUtil.RunAsWork<Void> work = new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    List<NodeRef> frozenNodes = HoldServiceImpl.this.getHeld(hold);
                    for (NodeRef frozenNode : frozenNodes) {
                        HoldServiceImpl.this.transactionalResourceHelper.getSet("frozen").add(frozenNode);
                        HoldServiceImpl.this.removeFreezeAspect(frozenNode, 1);
                    }
                    return null;
                }
            };
            this.authenticationUtil.runAsSystem(work);
        }
    }

    private void removeFreezeAspect(NodeRef nodeRef, int index) {
        List<NodeRef> otherHolds = this.heldBy(nodeRef, true);
        if (otherHolds.size() == index) {
            if (this.nodeService.hasAspect(nodeRef, ASPECT_FROZEN)) {
                this.transactionalResourceHelper.getSet("frozen").add(nodeRef);
                this.nodeService.removeAspect(nodeRef, ASPECT_FROZEN);
            }
            if (this.isRecordFolder(nodeRef)) {
                List<NodeRef> records = this.recordService.getRecords(nodeRef);
                for (NodeRef record : records) {
                    List<NodeRef> recordsOtherHolds;
                    if (!this.nodeService.hasAspect(record, ASPECT_FROZEN) || (recordsOtherHolds = this.heldBy(record, true)).size() != index) continue;
                    this.transactionalResourceHelper.getSet("frozen").add(record);
                    this.nodeService.removeAspect(record, ASPECT_FROZEN);
                }
            }
        }
    }

    @Override
    public List<NodeRef> getHolds(NodeRef filePlan) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        ArrayList<NodeRef> holds = new ArrayList<NodeRef>();
        NodeRef holdContainer = this.filePlanService.getHoldContainer(filePlan);
        if (holdContainer != null) {
            List holdsAssocs = this.nodeService.getChildAssocs(holdContainer, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef holdAssoc : holdsAssocs) {
                NodeRef hold = holdAssoc.getChildRef();
                if (!this.isHold(hold)) continue;
                holds.add(hold);
            }
        }
        return holds;
    }

    @Override
    public List<NodeRef> heldBy(NodeRef nodeRef, boolean includedInHold) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ArrayList<Object> result = new ArrayList();
        Set<NodeRef> holdsIncludingNodeRef = this.getParentHolds(nodeRef);
        if (this.isRecord(nodeRef)) {
            List<NodeRef> recordFolders = this.recordFolderService.getRecordFolders(nodeRef);
            for (NodeRef recordFolder : recordFolders) {
                holdsIncludingNodeRef.addAll(this.getParentHolds(recordFolder));
            }
        }
        if (!includedInHold) {
            Set<NodeRef> filePlans = this.filePlanService.getFilePlans();
            if (!CollectionUtils.isEmpty(filePlans)) {
                ArrayList holdsNotIncludingNodeRef = new ArrayList();
                filePlans.forEach(filePlan -> {
                    List<NodeRef> allHolds = this.getHolds((NodeRef)filePlan);
                    holdsNotIncludingNodeRef.addAll(ListUtils.subtract(allHolds, new ArrayList(holdsIncludingNodeRef)));
                });
                result = holdsNotIncludingNodeRef;
            }
        } else {
            result = new ArrayList<NodeRef>(holdsIncludingNodeRef);
        }
        return result;
    }

    private Set<NodeRef> getParentHolds(NodeRef nodeRef) {
        List holdsAssocs = this.nodeService.getParentAssocs(nodeRef, (QNamePattern)ASSOC_FROZEN_CONTENT, (QNamePattern)ASSOC_FROZEN_CONTENT);
        HashSet<NodeRef> holds = new HashSet<NodeRef>(holdsAssocs.size());
        for (ChildAssociationRef holdAssoc : holdsAssocs) {
            holds.add(holdAssoc.getParentRef());
        }
        return holds;
    }

    @Override
    public NodeRef getHold(NodeRef filePlan, String name) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        ParameterCheck.mandatory((String)"name", (Object)name);
        NodeRef holdContainer = this.filePlanService.getHoldContainer(filePlan);
        NodeRef hold = this.nodeService.getChildByName(holdContainer, ContentModel.ASSOC_CONTAINS, name);
        if (hold != null && !this.isHold(hold)) {
            throw new AlfrescoRuntimeException("Can not get hold, because the named node reference isn't a hold.");
        }
        return hold;
    }

    @Override
    public List<NodeRef> getHeld(NodeRef hold) {
        ParameterCheck.mandatory((String)"hold", (Object)hold);
        ArrayList<NodeRef> children = new ArrayList<NodeRef>();
        if (!this.isHold(hold)) {
            throw new AlfrescoRuntimeException("Can't get the node's held, because passed node reference isn't a hold. (hold=" + hold.toString() + ")");
        }
        List childAssocs = this.nodeService.getChildAssocs(hold, (QNamePattern)ASSOC_FROZEN_CONTENT, RegexQNamePattern.MATCH_ALL);
        if (childAssocs != null && !childAssocs.isEmpty()) {
            for (ChildAssociationRef childAssociationRef : childAssocs) {
                children.add(childAssociationRef.getChildRef());
            }
        }
        return children;
    }

    @Override
    public NodeRef createHold(NodeRef filePlan, String name, String reason, String description) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        ParameterCheck.mandatory((String)"name", (Object)name);
        ParameterCheck.mandatory((String)"reason", (Object)reason);
        NodeRef holdContainer = this.filePlanService.getHoldContainer(filePlan);
        this.invokeBeforeCreateHold(holdContainer, name, reason);
        HashMap<QName, String> properties = new HashMap<QName, String>(3);
        properties.put(ContentModel.PROP_NAME, name);
        properties.put(PROP_HOLD_REASON, reason);
        if (description != null && !description.isEmpty()) {
            properties.put(ContentModel.PROP_DESCRIPTION, description);
        }
        QName assocName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(holdContainer, ContentModel.ASSOC_CONTAINS, assocName, TYPE_HOLD, properties);
        NodeRef holdNodeRef = childAssocRef.getChildRef();
        this.invokeOnCreateHold(holdNodeRef);
        return holdNodeRef;
    }

    @Override
    public String getHoldReason(NodeRef hold) {
        ParameterCheck.mandatory((String)"hold", (Object)hold);
        String reason = null;
        if (this.nodeService.exists(hold) && this.isHold(hold)) {
            reason = (String)((Object)this.nodeService.getProperty(hold, PROP_HOLD_REASON));
        }
        return reason;
    }

    @Override
    public void setHoldReason(NodeRef hold, String reason) {
        ParameterCheck.mandatory((String)"hold", (Object)hold);
        ParameterCheck.mandatory((String)"reason", (Object)reason);
        if (this.nodeService.exists(hold) && this.isHold(hold)) {
            this.nodeService.setProperty(hold, PROP_HOLD_REASON, (Serializable)((Object)reason));
        }
    }

    @Override
    public void setHoldDeletionReason(NodeRef hold, String reason) {
        ParameterCheck.mandatory((String)"hold", (Object)hold);
        ParameterCheck.mandatory((String)"reason", (Object)reason);
        if (this.nodeService.exists(hold) && this.isHold(hold)) {
            this.nodeService.setProperty(hold, PROP_HOLD_DELETION_REASON, (Serializable)((Object)reason));
        }
    }

    @Override
    public void updateHold(NodeRef hold, String name, String reason, String description) {
        ParameterCheck.mandatory((String)"hold", (Object)hold);
        ParameterCheck.mandatory((String)"name", (Object)name);
        ParameterCheck.mandatory((String)"reason", (Object)reason);
        if (this.nodeService.exists(hold) && this.isHold(hold)) {
            this.nodeService.setProperty(hold, ContentModel.PROP_NAME, (Serializable)((Object)name));
            this.nodeService.setProperty(hold, PROP_HOLD_REASON, (Serializable)((Object)reason));
            this.nodeService.setProperty(hold, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)description));
        }
    }

    @Override
    public void deleteHold(NodeRef hold) {
        ParameterCheck.mandatory((String)"hold", (Object)hold);
        if (!this.isHold(hold)) {
            throw new AlfrescoRuntimeException("Can't delete hold, because passed node is not a hold. (hold=" + hold.toString() + ")");
        }
        this.invokeBeforeDeleteHold(hold);
        String holdName = (String)((Object)this.nodeService.getProperty(hold, ContentModel.PROP_NAME));
        Set<QName> classQNames = this.getTypeAndApsects(hold);
        this.nodeService.deleteNode(hold);
        this.invokeOnDeleteHold(holdName, classQNames);
    }

    private void checkPermissionsForDeleteHold(NodeRef hold) {
        List held = (List)AuthenticationUtil.runAsSystem(() -> this.getHeld(hold));
        ArrayList<String> heldNames = new ArrayList<String>();
        for (NodeRef nodeRef : held) {
            try {
                String permission = this.recordService.isRecord(nodeRef) || this.recordFolderService.isRecordFolder(nodeRef) ? "Filing" : "Read";
                if (this.permissionService.hasPermission(nodeRef, permission) != AccessStatus.DENIED) continue;
                heldNames.add((String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME)));
            }
            catch (AccessDeniedException ade) {
                throw new AccessDeniedException(I18NUtil.getMessage((String)MSG_ERR_HOLD_PERMISSION_GENERIC_ERROR), (Throwable)ade);
            }
        }
        if (heldNames.size() > 0) {
            StringBuilder sb = new StringBuilder();
            Stream stream1 = heldNames.stream();
            stream1.limit(5L).forEach(name -> {
                sb.append("\n ");
                sb.append("'");
                sb.append((String)name);
                sb.append("'");
            });
            throw new AccessDeniedException(I18NUtil.getMessage((String)MSG_ERR_HOLD_PERMISSION_DETAILED_ERROR) + sb.toString());
        }
    }

    @Override
    public void addToHold(NodeRef hold, NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"hold", (Object)hold);
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ArrayList<NodeRef> holds = new ArrayList<NodeRef>(1);
        holds.add(hold);
        this.addToHolds(Collections.unmodifiableList(holds), nodeRef);
    }

    @Override
    public void addToHold(NodeRef hold, List<NodeRef> nodeRefs) {
        ParameterCheck.mandatory((String)"hold", (Object)hold);
        ParameterCheck.mandatory((String)"nodeRefs", nodeRefs);
        for (NodeRef nodeRef : nodeRefs) {
            this.addToHold(hold, nodeRef);
        }
    }

    @Override
    public void addToHolds(List<NodeRef> holds, NodeRef nodeRef) {
        ParameterCheck.mandatoryCollection((String)"holds", holds);
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        this.checkNodeCanBeAddedToHold(nodeRef);
        for (NodeRef hold : holds) {
            if (!this.isHold(hold)) {
                String holdName = (String)((Object)this.nodeService.getProperty(hold, ContentModel.PROP_NAME));
                throw new IntegrityException(I18NUtil.getMessage((String)"rm.hold.not-hold", (Object[])new Object[]{holdName}), null);
            }
            if (!AccessStatus.ALLOWED.equals((Object)this.capabilityService.getCapabilityAccessState(hold, "AddToHold"))) {
                throw new AccessDeniedException(I18NUtil.getMessage((String)MSG_ERR_ACCESS_DENIED));
            }
            if (this.getHeld(hold).contains(nodeRef)) continue;
            this.invokeBeforeAddToHold(hold, nodeRef);
            this.authenticationUtil.runAsSystem(() -> {
                HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(2);
                props.put(PROP_FROZEN_AT, new Date());
                props.put(PROP_FROZEN_BY, (Serializable)((Object)AuthenticationUtil.getFullyAuthenticatedUser()));
                this.addFrozenAspect(nodeRef, props);
                this.transactionalResourceHelper.getSet("frozen").add(nodeRef);
                this.nodeService.addChild(hold, nodeRef, ASSOC_FROZEN_CONTENT, ASSOC_FROZEN_CONTENT);
                ChildAssociationRef parentAssoc = this.nodeService.getPrimaryParent(nodeRef);
                this.nodeService.addChild(hold, nodeRef, ContentModel.ASSOC_CONTAINS, parentAssoc.getQName());
                if (this.isRecordFolder(nodeRef)) {
                    List<NodeRef> records = this.recordService.getRecords(nodeRef);
                    records.forEach(record -> this.addFrozenAspect((NodeRef)record, (Map<QName, Serializable>)props));
                }
                return null;
            });
            this.invokeOnAddToHold(hold, nodeRef);
        }
    }

    private void checkNodeCanBeAddedToHold(NodeRef nodeRef) {
        if (!this.isRecordFolder(nodeRef) && !this.instanceOf(nodeRef, ContentModel.TYPE_CONTENT)) {
            String nodeName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            throw new IntegrityException(I18NUtil.getMessage((String)"rm.hold.add-to-hold-invalid-type", (Object[])new Object[]{nodeName}), null);
        }
        if ((this.isRecord(nodeRef) || this.isRecordFolder(nodeRef)) && this.permissionService.hasPermission(nodeRef, "Filing") == AccessStatus.DENIED || this.instanceOf(nodeRef, ContentModel.TYPE_CONTENT) && this.permissionService.hasPermission(nodeRef, "Write") == AccessStatus.DENIED) {
            throw new AccessDeniedException(I18NUtil.getMessage((String)MSG_ERR_ACCESS_DENIED));
        }
        if (this.nodeService.hasAspect(nodeRef, ASPECT_ARCHIVED)) {
            throw new IntegrityException(I18NUtil.getMessage((String)"rm.hold.add-to-hold-archived-node"), null);
        }
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
            throw new IntegrityException(I18NUtil.getMessage((String)"rm.hold.add-to-hold-locked-node"), null);
        }
    }

    private void addFrozenAspect(NodeRef nodeRef, Map<QName, Serializable> props) {
        if (!this.nodeService.hasAspect(nodeRef, ASPECT_FROZEN)) {
            this.transactionalResourceHelper.getSet("frozen").add(nodeRef);
            this.nodeService.addAspect(nodeRef, ASPECT_FROZEN, props);
            if (logger.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Frozen aspect applied to '").append(nodeRef).append("'.");
                logger.debug((Object)msg.toString());
            }
        }
    }

    @Override
    public void addToHolds(List<NodeRef> holds, List<NodeRef> nodeRefs) {
        ParameterCheck.mandatoryCollection((String)"holds", holds);
        ParameterCheck.mandatoryCollection((String)"nodeRefs", nodeRefs);
        for (NodeRef nodeRef : nodeRefs) {
            this.addToHolds(holds, nodeRef);
        }
    }

    @Override
    public void removeFromHold(NodeRef hold, NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"hold", (Object)hold);
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ArrayList<NodeRef> holds = new ArrayList<NodeRef>(1);
        holds.add(hold);
        this.removeFromHolds(Collections.unmodifiableList(holds), nodeRef);
    }

    @Override
    public void removeFromHold(NodeRef hold, List<NodeRef> nodeRefs) {
        ParameterCheck.mandatory((String)"hold", (Object)hold);
        ParameterCheck.mandatory((String)"nodeRefs", nodeRefs);
        for (NodeRef nodeRef : nodeRefs) {
            this.removeFromHold(hold, nodeRef);
        }
    }

    @Override
    public void removeFromHolds(List<NodeRef> holds, NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"holds", holds);
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        if (!holds.isEmpty()) {
            ArrayList<NodeRef> removedHolds = new ArrayList<NodeRef>();
            for (NodeRef hold : holds) {
                if (!this.isHold(hold)) {
                    String holdName = (String)((Object)this.nodeService.getProperty(hold, ContentModel.PROP_NAME));
                    throw new IntegrityException(I18NUtil.getMessage((String)"rm.hold.not-hold", (Object[])new Object[]{holdName}), null);
                }
                if (!AccessStatus.ALLOWED.equals((Object)this.capabilityService.getCapabilityAccessState(hold, "RemoveFromHold"))) {
                    throw new AccessDeniedException(I18NUtil.getMessage((String)MSG_ERR_ACCESS_DENIED));
                }
                if (!this.getHeld(hold).contains(nodeRef)) continue;
                this.invokeBeforeRemoveFromHold(hold, nodeRef);
                this.authenticationUtil.runAsSystem(() -> {
                    this.transactionalResourceHelper.getSet("frozen").add(nodeRef);
                    this.nodeService.removeChild(hold, nodeRef);
                    return null;
                });
                removedHolds.add(hold);
            }
            this.authenticationUtil.runAsSystem(() -> {
                this.removeFreezeAspect(nodeRef, 0);
                return null;
            });
            for (NodeRef removedHold : removedHolds) {
                this.invokeOnRemoveFromHold(removedHold, nodeRef);
            }
        }
    }

    @Override
    public void removeFromHolds(List<NodeRef> holds, List<NodeRef> nodeRefs) {
        ParameterCheck.mandatoryCollection((String)"holds", holds);
        ParameterCheck.mandatoryCollection((String)"nodeRefs", nodeRefs);
        for (NodeRef nodeRef : nodeRefs) {
            this.removeFromHolds(holds, nodeRef);
        }
    }

    @Override
    public void removeFromAllHolds(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        List<NodeRef> holds = this.heldBy(nodeRef, true);
        for (NodeRef hold : holds) {
            this.removeFromHold(hold, nodeRef);
        }
    }

    @Override
    public void removeFromAllHolds(List<NodeRef> nodeRefs) {
        ParameterCheck.mandatory((String)"nodeRefs", nodeRefs);
        for (NodeRef nodeRef : nodeRefs) {
            this.removeFromAllHolds(nodeRef);
        }
    }

    protected void invokeBeforeCreateHold(NodeRef nodeRef, String name, String reason) {
        HoldServicePolicies.BeforeCreateHoldPolicy policy = (HoldServicePolicies.BeforeCreateHoldPolicy)this.beforeCreateHoldPolicyDelegate.get(this.getTypeAndApsects(nodeRef));
        policy.beforeCreateHold(name, reason);
    }

    protected void invokeOnCreateHold(NodeRef nodeRef) {
        HoldServicePolicies.OnCreateHoldPolicy policy = (HoldServicePolicies.OnCreateHoldPolicy)this.onCreateHoldPolicyDelegate.get(this.getTypeAndApsects(nodeRef));
        policy.onCreateHold(nodeRef);
    }

    protected void invokeBeforeDeleteHold(NodeRef nodeRef) {
        HoldServicePolicies.BeforeDeleteHoldPolicy policy = (HoldServicePolicies.BeforeDeleteHoldPolicy)this.beforeDeleteHoldPolicyDelegate.get(this.getTypeAndApsects(nodeRef));
        policy.beforeDeleteHold(nodeRef);
    }

    protected void invokeOnDeleteHold(String holdName, Set<QName> classQNames) {
        HoldServicePolicies.OnDeleteHoldPolicy policy = (HoldServicePolicies.OnDeleteHoldPolicy)this.onDeleteHoldPolicyDelegate.get(classQNames);
        policy.onDeleteHold(holdName);
    }

    protected void invokeBeforeAddToHold(NodeRef hold, NodeRef contentNodeRef) {
        HoldServicePolicies.BeforeAddToHoldPolicy policy = (HoldServicePolicies.BeforeAddToHoldPolicy)this.beforeAddToHoldPolicyDelegate.get(this.getTypeAndApsects(hold));
        policy.beforeAddToHold(hold, contentNodeRef);
    }

    protected void invokeOnAddToHold(NodeRef hold, NodeRef contentNodeRef) {
        HoldServicePolicies.OnAddToHoldPolicy policy = (HoldServicePolicies.OnAddToHoldPolicy)this.onAddToHoldPolicyDelegate.get(this.getTypeAndApsects(hold));
        policy.onAddToHold(hold, contentNodeRef);
    }

    protected void invokeBeforeRemoveFromHold(NodeRef hold, NodeRef contentNodeRef) {
        HoldServicePolicies.BeforeRemoveFromHoldPolicy policy = (HoldServicePolicies.BeforeRemoveFromHoldPolicy)this.beforeRemoveFromHoldPolicyDelegate.get(this.getTypeAndApsects(hold));
        policy.beforeRemoveFromHold(hold, contentNodeRef);
    }

    protected void invokeOnRemoveFromHold(NodeRef hold, NodeRef contentNodeRef) {
        HoldServicePolicies.OnRemoveFromHoldPolicy policy = (HoldServicePolicies.OnRemoveFromHoldPolicy)this.onRemoveFromHoldPolicyDelegate.get(this.getTypeAndApsects(hold));
        policy.onRemoveFromHold(hold, contentNodeRef);
    }
}

