/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.audit;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditQueryParameters;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditService;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditServiceImpl;
import org.alfresco.module.org_alfresco_module_rm.dod5015.DOD5015Model;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.audit.AuditComponent;
import org.alfresco.service.cmr.audit.AuditQueryParameters;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class RecordsManagementAuditServiceImplUnitTest {
    private static final int MAX_ENTRIES = 10;
    private static final NodeRef FILE_PLAN_NODE = new NodeRef("file://plan/node");
    private static final NodeRef RM_SITE_NODE = new NodeRef("rm://site/node");
    @InjectMocks
    private RecordsManagementAuditServiceImpl recordsManagementAuditServiceImpl;
    @Mock
    private NodeService mockNodeService;
    @Mock
    private SiteService mockSiteService;
    @Mock
    private AuditService mockAuditService;
    @Mock
    private FilePlanService mockFilePlanService;
    @Mock
    AuditComponent mockAuditComponent;
    @Mock
    private Writer mockWriter;
    @Mock
    private SiteInfo mockSiteInfo;
    @Captor
    private ArgumentCaptor<AuditQueryParameters> queryParamsCaptor;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockFilePlanService.getFilePlanBySiteId("rm")).thenReturn((Object)FILE_PLAN_NODE);
        Mockito.when((Object)this.mockSiteService.getSite("rm")).thenReturn((Object)this.mockSiteInfo);
        Mockito.when((Object)this.mockSiteInfo.getNodeRef()).thenReturn((Object)RM_SITE_NODE);
        this.recordsManagementAuditServiceImpl.setIgnoredAuditProperties(Collections.emptyList());
    }

    @Test
    public void testAuditWithoutDOD() throws IOException {
        RecordsManagementAuditQueryParameters params = new RecordsManagementAuditQueryParameters();
        params.setMaxEntries(10);
        ArrayList results = new ArrayList();
        Mockito.when((Object)this.mockNodeService.getType(RM_SITE_NODE)).thenReturn((Object)RecordsManagementModel.TYPE_RM_SITE);
        this.recordsManagementAuditServiceImpl.getAuditTrailImpl(params, results, this.mockWriter, RecordsManagementAuditService.ReportFormat.JSON);
        ((AuditService)Mockito.verify((Object)this.mockAuditService, (VerificationMode)Mockito.times((int)1))).auditQuery((AuditService.AuditQueryCallback)ArgumentMatchers.any(AuditService.AuditQueryCallback.class), (AuditQueryParameters)this.queryParamsCaptor.capture(), ArgumentMatchers.eq((int)10));
        Assert.assertEquals((String)"The application name should be the standard RM application", (Object)"RM", (Object)((AuditQueryParameters)this.queryParamsCaptor.getValue()).getApplicationName());
        ((AuditComponent)Mockito.verify((Object)this.mockAuditComponent)).recordAuditValues((String)ArgumentMatchers.eq((Object)"/RM"), (Map)ArgumentMatchers.any(Map.class));
    }

    @Test
    public void testAuditWithDOD() throws IOException {
        RecordsManagementAuditQueryParameters params = new RecordsManagementAuditQueryParameters();
        params.setMaxEntries(10);
        ArrayList results = new ArrayList();
        Mockito.when((Object)this.mockNodeService.getType(RM_SITE_NODE)).thenReturn((Object)DOD5015Model.TYPE_DOD_5015_SITE);
        this.recordsManagementAuditServiceImpl.getAuditTrailImpl(params, results, this.mockWriter, RecordsManagementAuditService.ReportFormat.JSON);
        ((AuditService)Mockito.verify((Object)this.mockAuditService, (VerificationMode)Mockito.times((int)2))).auditQuery((AuditService.AuditQueryCallback)ArgumentMatchers.any(AuditService.AuditQueryCallback.class), (AuditQueryParameters)this.queryParamsCaptor.capture(), ArgumentMatchers.eq((int)10));
        Set apps = this.queryParamsCaptor.getAllValues().stream().map(AuditQueryParameters::getApplicationName).collect(Collectors.toSet());
        Assert.assertEquals((String)"Expected the standard audit query and the DOD audit query.", (Object)Sets.newHashSet((Object[])new String[]{"RM", "DOD5015"}), apps);
        ((AuditComponent)Mockito.verify((Object)this.mockAuditComponent)).recordAuditValues((String)ArgumentMatchers.eq((Object)"/RM"), (Map)ArgumentMatchers.any(Map.class));
    }

    @Test
    public void testGetStartOfDay_null() {
        Date startOfDay = this.recordsManagementAuditServiceImpl.getStartOfDay(null);
        Assert.assertNotNull((String)"Expected date to be created by method.", (Object)startOfDay);
    }

    @Test
    public void testGetStartOfDay_timeDiscarded() throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
        Date date = format.parse("2001-02-03 04:05:06.789");
        Date startOfDay = this.recordsManagementAuditServiceImpl.getStartOfDay(date);
        Assert.assertEquals((String)"Unexpected date truncation.", (Object)format.parse("2001-02-03 00:00:00.000"), (Object)startOfDay);
    }
}

