/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.event;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.RecordsManagementPolicies;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionService;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.event.EventCompletionDetails;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEvent;
import org.alfresco.module.org_alfresco_module_rm.event.SimpleRecordsManagementEventTypeImpl;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

@BehaviourBean
public class OnReferenceCreateEventType
extends SimpleRecordsManagementEventTypeImpl
implements RecordsManagementModel,
RecordsManagementPolicies.OnCreateReference {
    private RecordsManagementActionService recordsManagementActionService;
    private DispositionService dispositionService;
    private QName reference;

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setRecordsManagementActionService(RecordsManagementActionService recordsManagementActionService) {
        this.recordsManagementActionService = recordsManagementActionService;
    }

    public void setReferenceName(String reference) {
        this.reference = QName.createQName((String)reference);
    }

    @Override
    public boolean isAutomaticEvent() {
        return true;
    }

    @Override
    @Behaviour(kind=BehaviourKind.CLASS, type="rma:record", notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onCreateReference(NodeRef fromNodeRef, final NodeRef toNodeRef, final QName reference) {
        AuthenticationUtil.RunAsWork<Object> work = new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                DispositionAction da;
                if (reference.equals((Object)OnReferenceCreateEventType.this.reference) && (da = OnReferenceCreateEventType.this.dispositionService.getNextDispositionAction(toNodeRef)) != null) {
                    List<EventCompletionDetails> events = da.getEventCompletionDetails();
                    for (EventCompletionDetails event : events) {
                        RecordsManagementEvent rmEvent = OnReferenceCreateEventType.this.getRecordsManagementEventService().getEvent(event.getEventName());
                        if (event.isEventComplete() || !rmEvent.getType().equals(OnReferenceCreateEventType.this.getName())) continue;
                        HashMap<String, Serializable> params = new HashMap<String, Serializable>(3);
                        params.put("eventName", (Serializable)((Object)event.getEventName()));
                        params.put("eventCompletedBy", (Serializable)((Object)AuthenticationUtil.getFullyAuthenticatedUser()));
                        params.put("eventCompletedAt", new Date());
                        OnReferenceCreateEventType.this.recordsManagementActionService.executeRecordsManagementAction(toNodeRef, "completeEvent", params);
                        break;
                    }
                }
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)work, (String)AuthenticationUtil.getAdminUserName());
    }
}

