/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.type;

import org.alfresco.module.org_alfresco_module_rm.model.rma.type.RecordFolderType;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.module.org_alfresco_module_rm.test.util.MockAuthenticationUtilHelper;
import org.alfresco.module.org_alfresco_module_rm.util.AuthenticationUtil;
import org.alfresco.module.org_alfresco_module_rm.vital.VitalRecordService;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class RecordFolderTypeUnitTest
extends BaseUnitTest {
    @Mock
    private AuthenticationUtil mockAuthenticationUtil;
    @Mock
    private VitalRecordService mockedVitalRecordService;
    @InjectMocks
    private RecordFolderType recordFolderType;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        MockAuthenticationUtilHelper.setup(this.mockAuthenticationUtil);
        Mockito.when((Object)this.mockedApplicationContext.getBean("dbNodeService")).thenReturn((Object)this.mockedNodeService);
    }

    @Test(expected=IntegrityException.class)
    public void testCreateTransferFolder() throws Exception {
        NodeRef recordFolderNodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_RECORD_FOLDER);
        QName type = AlfMock.generateQName();
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_TRANSFER)).thenReturn((Object)true);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type, true);
        ChildAssociationRef childAssocRef = this.generateChildAssociationRef(recordFolderNodeRef, nodeRef);
        this.recordFolderType.onCreateChildAssociation(childAssocRef, true);
    }

    @Test(expected=IntegrityException.class)
    public void testCreateRecordFolder() throws Exception {
        NodeRef recordFolderNodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_RECORD_FOLDER);
        QName type = AlfMock.generateQName();
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_RECORD_FOLDER)).thenReturn((Object)true);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type, true);
        ChildAssociationRef childAssocRef = this.generateChildAssociationRef(recordFolderNodeRef, nodeRef);
        this.recordFolderType.onCreateChildAssociation(childAssocRef, true);
    }

    @Test(expected=IntegrityException.class)
    public void testCreateSubTypesOfRecordManagementContainer() throws Exception {
        NodeRef recordFolderNodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_RECORD_FOLDER);
        QName type = AlfMock.generateQName();
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_RECORDS_MANAGEMENT_CONTAINER)).thenReturn((Object)true);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type, true);
        ChildAssociationRef childAssocRef = this.generateChildAssociationRef(recordFolderNodeRef, nodeRef);
        this.recordFolderType.onCreateChildAssociation(childAssocRef, true);
    }

    @Test
    public void testCreateFolderSubType() throws Exception {
        NodeRef recordFolderNodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_RECORD_FOLDER);
        QName type = AlfMock.generateQName();
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_FOLDER)).thenReturn((Object)true);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type, true);
        ChildAssociationRef childAssocRef = this.generateChildAssociationRef(recordFolderNodeRef, nodeRef);
        this.recordFolderType.onCreateChildAssociation(childAssocRef, true);
    }

    @Test(expected=IntegrityException.class)
    public void testCreateNonFolderSubType() throws Exception {
        NodeRef recordFolderNodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_RECORD_FOLDER);
        QName type = AlfMock.generateQName();
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_FOLDER)).thenReturn((Object)false);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type, true);
        ChildAssociationRef childAssocRef = this.generateChildAssociationRef(recordFolderNodeRef, nodeRef);
        this.recordFolderType.onCreateChildAssociation(childAssocRef, true);
    }

    public void testCreateContent() throws Exception {
        NodeRef recordFolderNodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_RECORD_FOLDER);
        QName type = AlfMock.generateQName();
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_CONTENT)).thenReturn((Object)true);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type, true);
        ChildAssociationRef childAssocRef = this.generateChildAssociationRef(recordFolderNodeRef, nodeRef);
        this.recordFolderType.onCreateChildAssociation(childAssocRef, true);
    }

    @Test(expected=IntegrityException.class)
    public void testCreateNonContent() throws Exception {
        NodeRef recordFolderNodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_RECORD_FOLDER);
        QName type = AlfMock.generateQName();
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_CONTENT)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_FOLDER)).thenReturn((Object)false);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type, true);
        ChildAssociationRef childAssocRef = this.generateChildAssociationRef(recordFolderNodeRef, nodeRef);
        this.recordFolderType.onCreateChildAssociation(childAssocRef, true);
    }

    @Test(expected=IntegrityException.class)
    public void testCreateNotHiddenFolderSubTypeOnCommit() throws Exception {
        NodeRef recordFolderNodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_RECORD_FOLDER);
        QName type = AlfMock.generateQName();
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_FOLDER)).thenReturn((Object)true);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type, true);
        ChildAssociationRef childAssocRef = this.generateChildAssociationRef(recordFolderNodeRef, nodeRef);
        this.recordFolderType.onCreateChildAssociationOnCommit(childAssocRef, true);
    }

    @Test
    public void testCreateHiddenFolderSubTypeOnCommit() throws Exception {
        NodeRef recordFolderNodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_RECORD_FOLDER);
        QName type = AlfMock.generateQName();
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type, true);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_FOLDER)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ASPECT_HIDDEN)).thenReturn((Object)true);
        ChildAssociationRef mockedPrimaryParentAssoc = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)this.mockedNodeService.getPrimaryParent(nodeRef)).thenReturn((Object)mockedPrimaryParentAssoc);
        ChildAssociationRef childAssocRef = this.generateChildAssociationRef(recordFolderNodeRef, nodeRef);
        this.recordFolderType.onCreateChildAssociationOnCommit(childAssocRef, true);
    }

    @Test
    public void testCreateNonFolderSubTypeOnCommit() throws Exception {
        NodeRef recordFolderNodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_RECORD_FOLDER);
        QName type = AlfMock.generateQName();
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type, true);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_FOLDER)).thenReturn((Object)false);
        ChildAssociationRef mockedPrimaryParentAssoc = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)this.mockedNodeService.getPrimaryParent(nodeRef)).thenReturn((Object)mockedPrimaryParentAssoc);
        ChildAssociationRef childAssocRef = this.generateChildAssociationRef(recordFolderNodeRef, nodeRef);
        this.recordFolderType.onCreateChildAssociationOnCommit(childAssocRef, true);
    }
}

