/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.capability.declarative.condition;

import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.capability.declarative.AbstractCapabilityCondition;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;

public class HoldCapabilityCondition
extends AbstractCapabilityCondition {
    private boolean includedInHold = false;
    private HoldService holdService;

    public void setIncludedInHold(boolean includedInHold) {
        this.includedInHold = includedInHold;
    }

    public void setHoldService(HoldService holdService) {
        this.holdService = holdService;
    }

    @Override
    public boolean evaluateImpl(NodeRef nodeRef) {
        boolean result = false;
        if (this.holdService.isHold(nodeRef)) {
            result = AccessStatus.ALLOWED.equals((Object)this.permissionService.hasPermission(nodeRef, "Filing"));
        } else {
            List<NodeRef> holds = this.holdService.heldBy(nodeRef, this.includedInHold);
            for (NodeRef hold : holds) {
                if (!AccessStatus.ALLOWED.equals((Object)this.permissionService.hasPermission(hold, "Filing"))) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

