/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.type;

import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.model.rma.type.NonElectronicRecordType;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.test.util.MockAuthenticationUtilHelper;
import org.alfresco.module.org_alfresco_module_rm.util.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.GUID;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class NonElectronicRecordTypeUnitTest
implements RecordsManagementModel,
ContentModel {
    private static final NodeRef CHILD_NODE_REF = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate());
    private static final NodeRef PARENT_NODE_REF = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate());
    @InjectMocks
    NonElectronicRecordType nonElectronicRecordType;
    @Mock
    AuthenticationUtil mockAuthenticationUtil;
    @Mock
    RecordService mockedRecordService;
    @Mock
    NodeService mockedNodeService;

    @Before
    public void setUp() {
        MockAuthenticationUtilHelper.setup(this.mockAuthenticationUtil);
        Mockito.when((Object)this.mockedNodeService.exists(CHILD_NODE_REF)).thenReturn((Object)true);
        ChildAssociationRef generateChildAssociationRef = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)generateChildAssociationRef.getParentRef()).thenReturn((Object)PARENT_NODE_REF);
        Mockito.when((Object)this.mockedNodeService.getPrimaryParent(CHILD_NODE_REF)).thenReturn((Object)generateChildAssociationRef);
        Mockito.when((Object)this.mockedNodeService.getType(PARENT_NODE_REF)).thenReturn((Object)TYPE_UNFILED_RECORD_FOLDER);
        this.nonElectronicRecordType.setNodeService(this.mockedNodeService);
    }

    @Test
    public void testOnUpdateWithAspectsAlreadyPresent() {
        Mockito.when((Object)this.mockedNodeService.hasAspect(CHILD_NODE_REF, ASPECT_FILE_PLAN_COMPONENT)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedNodeService.hasAspect(CHILD_NODE_REF, ASPECT_RECORD)).thenReturn((Object)true);
        this.nonElectronicRecordType.onUpdateNode(CHILD_NODE_REF);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).addAspect(CHILD_NODE_REF, ASPECT_FILE_PLAN_COMPONENT, null);
        ((RecordService)Mockito.verify((Object)this.mockedRecordService, (VerificationMode)Mockito.never())).makeRecord(CHILD_NODE_REF);
    }

    @Test
    public void testOnUpdateWithoutTheAspects() {
        Mockito.when((Object)this.mockedNodeService.hasAspect(CHILD_NODE_REF, ASPECT_FILE_PLAN_COMPONENT)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedNodeService.hasAspect(CHILD_NODE_REF, ASPECT_RECORD)).thenReturn((Object)false);
        this.nonElectronicRecordType.onUpdateNode(CHILD_NODE_REF);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).addAspect(CHILD_NODE_REF, ASPECT_FILE_PLAN_COMPONENT, null);
        ((RecordService)Mockito.verify((Object)this.mockedRecordService, (VerificationMode)Mockito.times((int)1))).makeRecord(CHILD_NODE_REF);
    }
}

