/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.type;

import org.alfresco.module.org_alfresco_module_rm.model.BaseBehaviourBean;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

@BehaviourBean(defaultType="rma:nonElectronicDocument")
public class NonElectronicRecordType
extends BaseBehaviourBean
implements NodeServicePolicies.OnUpdateNodePolicy {
    protected RecordService recordService;

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void onUpdateNode(final NodeRef nodeRef) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                NodeRef child = nodeRef;
                if (NonElectronicRecordType.this.nodeService.exists(child)) {
                    NodeRef parentRef = NonElectronicRecordType.this.nodeService.getPrimaryParent(child).getParentRef();
                    QName parentType = NonElectronicRecordType.this.nodeService.getType(parentRef);
                    boolean isUnfiledRecordContainer = parentType.equals((Object)RecordsManagementModel.TYPE_UNFILED_RECORD_CONTAINER);
                    boolean isUnfiledRecordFolder = parentType.equals((Object)RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER);
                    if (isUnfiledRecordContainer || isUnfiledRecordFolder) {
                        if (!NonElectronicRecordType.this.nodeService.hasAspect(child, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT)) {
                            NonElectronicRecordType.this.nodeService.addAspect(child, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT, null);
                        }
                        if (!NonElectronicRecordType.this.nodeService.hasAspect(child, RecordsManagementModel.ASPECT_RECORD)) {
                            NonElectronicRecordType.this.recordService.makeRecord(child);
                        }
                    }
                }
                return null;
            }
        });
    }
}

