/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.RecordsManagementServiceRegistry;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.capability.Group;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinitionImpl;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEvent;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.model.Assoc;
import org.alfresco.rest.api.model.AssocChild;
import org.alfresco.rest.api.model.ContentInfo;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.framework.jacksonextensions.BeanPropertiesFilter;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.model.CapabilityModel;
import org.alfresco.rm.rest.api.model.FilePlan;
import org.alfresco.rm.rest.api.model.GroupModel;
import org.alfresco.rm.rest.api.model.HoldModel;
import org.alfresco.rm.rest.api.model.RMNode;
import org.alfresco.rm.rest.api.model.Record;
import org.alfresco.rm.rest.api.model.RecordCategory;
import org.alfresco.rm.rest.api.model.RecordCategoryChild;
import org.alfresco.rm.rest.api.model.RecordFolder;
import org.alfresco.rm.rest.api.model.RetentionPeriod;
import org.alfresco.rm.rest.api.model.RetentionSchedule;
import org.alfresco.rm.rest.api.model.RetentionScheduleActionDefinition;
import org.alfresco.rm.rest.api.model.RetentionSteps;
import org.alfresco.rm.rest.api.model.RoleModel;
import org.alfresco.rm.rest.api.model.Transfer;
import org.alfresco.rm.rest.api.model.TransferChild;
import org.alfresco.rm.rest.api.model.TransferContainer;
import org.alfresco.rm.rest.api.model.UnfiledChild;
import org.alfresco.rm.rest.api.model.UnfiledContainer;
import org.alfresco.rm.rest.api.model.UnfiledContainerChild;
import org.alfresco.rm.rest.api.model.UnfiledRecordFolder;
import org.alfresco.rm.rest.api.model.UnfiledRecordFolderChild;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiNodesModelFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiNodesModelFactory.class);
    public static final List<String> EXCLUDED_NS = Arrays.asList("http://www.alfresco.org/model/system/1.0");
    public static final List<QName> EXCLUDED_ASPECTS = Arrays.asList(new QName[0]);
    public static final List<QName> EXCLUDED_PROPS = Arrays.asList(ContentModel.PROP_NAME, ContentModel.PROP_MODIFIER, ContentModel.PROP_MODIFIED, ContentModel.PROP_CREATOR, ContentModel.PROP_CREATED, ContentModel.PROP_CONTENT, ContentModel.PROP_INITIAL_VERSION, ContentModel.PROP_AUTO_VERSION_PROPS, ContentModel.PROP_AUTO_VERSION);
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private Nodes nodes;
    private FilePlanComponentsApiUtils apiUtils;
    private PersonService personService;
    private DispositionService dispositionService;
    private ServiceRegistry serviceRegistry;
    private RecordsManagementServiceRegistry services;

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public DispositionService getDispositionService() {
        return this.dispositionService;
    }

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setRecordsManagementServiceRegistry(RecordsManagementServiceRegistry services) {
        this.services = services;
    }

    private void mapBasicInfo(RMNode rmNode, FileInfo info, BeanPropertiesFilter propertyFilter, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        if (propertyFilter.isAllowed("id")) {
            rmNode.setNodeRef(info.getNodeRef());
        }
        if (propertyFilter.isAllowed("parentId")) {
            rmNode.setParentId(this.nodeService.getPrimaryParent(info.getNodeRef()).getParentRef());
        }
        if (propertyFilter.isAllowed("name")) {
            rmNode.setName(info.getName());
        }
        if (propertyFilter.isAllowed("nodeType")) {
            rmNode.setNodeType(info.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService));
        }
        if (propertyFilter.isAllowed("modifiedAt")) {
            rmNode.setModifiedAt(info.getModifiedDate());
        }
        if (propertyFilter.isAllowed("modifiedByUser")) {
            if (mapUserInfo == null) {
                mapUserInfo = new HashMap<String, UserInfo>(2);
            }
            UserInfo modifer = Node.lookupUserInfo((String)((String)info.getProperties().get(ContentModel.PROP_MODIFIER)), mapUserInfo, (PersonService)this.personService);
            rmNode.setModifiedByUser(modifer);
        }
        if (propertyFilter.isAllowed("createdAt")) {
            rmNode.setCreatedAt(info.getCreatedDate());
        }
        if (propertyFilter.isAllowed("createdByUser")) {
            if (mapUserInfo == null) {
                mapUserInfo = new HashMap<String, UserInfo>(2);
            }
            UserInfo creator = Node.lookupUserInfo((String)((String)info.getProperties().get(ContentModel.PROP_CREATOR)), mapUserInfo, (PersonService)this.personService);
            rmNode.setCreatedByUser(creator);
        }
        if (!isMinimalInfo && propertyFilter.isAllowed("aspectNames")) {
            rmNode.setAspectNames(this.mapFromNodeAspects(this.nodeService.getAspects(info.getNodeRef())));
        }
        if (!isMinimalInfo && propertyFilter.isAllowed("properties")) {
            rmNode.setProperties(this.mapFromNodeProperties(info.getProperties()));
        }
    }

    private void mapOptionalInfo(RMNode rmNode, FileInfo info, List<String> includeParam, boolean isMinimalInfo) {
        if (includeParam == null || includeParam.isEmpty()) {
            return;
        }
        if (includeParam.contains("allowableOperations")) {
            rmNode.setAllowableOperations(this.apiUtils.getAllowableOperations(info.getNodeRef(), info.getType()));
        }
        if (includeParam.contains("path")) {
            rmNode.setPath(this.nodes.lookupPathInfo(info.getNodeRef(), null));
        }
        if (isMinimalInfo && includeParam.contains("aspectNames")) {
            rmNode.setAspectNames(this.mapFromNodeAspects(this.nodeService.getAspects(info.getNodeRef())));
        }
        if (isMinimalInfo && includeParam.contains("properties")) {
            rmNode.setProperties(this.mapFromNodeProperties(info.getProperties()));
        }
    }

    private void mapUnfiledChildInfo(UnfiledChild unfiledChild, FileInfo info, BeanPropertiesFilter propertyFilter) {
        if (RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER.equals((Object)info.getType())) {
            if (propertyFilter.isAllowed("isUnfiledRecordFolder")) {
                unfiledChild.setIsUnfiledRecordFolder(true);
            }
            if (propertyFilter.isAllowed("isRecord")) {
                unfiledChild.setIsRecord(false);
            }
        } else {
            if (propertyFilter.isAllowed("isUnfiledRecordFolder")) {
                unfiledChild.setIsUnfiledRecordFolder(false);
            }
            if (propertyFilter.isAllowed("isRecord")) {
                unfiledChild.setIsRecord(true);
            }
        }
    }

    private void mapTransferContainerInfo(TransferContainer transferContainer, FileInfo info, Map<String, UserInfo> mapUserInfo, BeanPropertiesFilter propertyFilter, List<String> includeParam, boolean isMinimalInfo) {
        if (propertyFilter.isAllowed("id")) {
            transferContainer.setNodeRef(info.getNodeRef());
        }
        if (propertyFilter.isAllowed("parentId")) {
            transferContainer.setParentId(this.nodeService.getPrimaryParent(info.getNodeRef()).getParentRef());
        }
        if (propertyFilter.isAllowed("name")) {
            transferContainer.setName(info.getName());
        }
        if (propertyFilter.isAllowed("nodeType")) {
            transferContainer.setNodeType(info.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService));
        }
        if (propertyFilter.isAllowed("modifiedAt")) {
            transferContainer.setModifiedAt(info.getModifiedDate());
        }
        if (propertyFilter.isAllowed("modifiedByUser")) {
            if (mapUserInfo == null) {
                mapUserInfo = new HashMap<String, UserInfo>(2);
            }
            UserInfo modifer = Node.lookupUserInfo((String)((String)info.getProperties().get(ContentModel.PROP_MODIFIER)), mapUserInfo, (PersonService)this.personService);
            transferContainer.setModifiedByUser(modifer);
        }
        if (propertyFilter.isAllowed("createdAt")) {
            transferContainer.setCreatedAt(info.getCreatedDate());
        }
        if (propertyFilter.isAllowed("createdByUser")) {
            if (mapUserInfo == null) {
                mapUserInfo = new HashMap<String, UserInfo>(2);
            }
            UserInfo creator = Node.lookupUserInfo((String)((String)info.getProperties().get(ContentModel.PROP_CREATOR)), mapUserInfo, (PersonService)this.personService);
            transferContainer.setCreatedByUser(creator);
        }
        if (!isMinimalInfo && propertyFilter.isAllowed("aspectNames")) {
            transferContainer.setAspectNames(this.mapFromNodeAspects(this.nodeService.getAspects(info.getNodeRef())));
        }
        if (!isMinimalInfo && propertyFilter.isAllowed("properties")) {
            transferContainer.setProperties(this.mapFromNodeProperties(info.getProperties()));
        }
        if (includeParam == null || includeParam.isEmpty()) {
            return;
        }
        if (includeParam.contains("allowableOperations")) {
            transferContainer.setAllowableOperations(this.apiUtils.getAllowableOperations(info.getNodeRef(), info.getType()));
        }
        if (isMinimalInfo && includeParam.contains("aspectNames")) {
            transferContainer.setAspectNames(this.mapFromNodeAspects(this.nodeService.getAspects(info.getNodeRef())));
        }
        if (isMinimalInfo && includeParam.contains("properties")) {
            transferContainer.setProperties(this.mapFromNodeProperties(info.getProperties()));
        }
    }

    private void mapTransferInfo(Transfer transfer, FileInfo info, Map<String, UserInfo> mapUserInfo, BeanPropertiesFilter propertyFilter, List<String> includeParam, boolean isMinimalInfo) {
        if (propertyFilter.isAllowed("id")) {
            transfer.setNodeRef(info.getNodeRef());
        }
        if (propertyFilter.isAllowed("parentId")) {
            transfer.setParentId(this.nodeService.getPrimaryParent(info.getNodeRef()).getParentRef());
        }
        if (propertyFilter.isAllowed("name")) {
            transfer.setName(info.getName());
        }
        if (propertyFilter.isAllowed("nodeType")) {
            transfer.setNodeType(info.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService));
        }
        if (propertyFilter.isAllowed("createdAt")) {
            transfer.setCreatedAt(info.getCreatedDate());
        }
        if (propertyFilter.isAllowed("createdByUser")) {
            if (mapUserInfo == null) {
                mapUserInfo = new HashMap<String, UserInfo>(2);
            }
            UserInfo creator = Node.lookupUserInfo((String)((String)info.getProperties().get(ContentModel.PROP_CREATOR)), mapUserInfo, (PersonService)this.personService);
            transfer.setCreatedByUser(creator);
        }
        if (!isMinimalInfo && propertyFilter.isAllowed("aspectNames")) {
            transfer.setAspectNames(this.mapFromNodeAspects(this.nodeService.getAspects(info.getNodeRef())));
        }
        if (!isMinimalInfo && propertyFilter.isAllowed("properties")) {
            transfer.setProperties(this.mapFromNodeProperties(info.getProperties()));
        }
        if (isMinimalInfo && includeParam == null || includeParam.isEmpty()) {
            return;
        }
        if (includeParam.contains("allowableOperations")) {
            transfer.setAllowableOperations(this.apiUtils.getAllowableOperations(info.getNodeRef(), info.getType()));
        }
        if (isMinimalInfo && includeParam.contains("aspectNames")) {
            transfer.setAspectNames(this.mapFromNodeAspects(this.nodeService.getAspects(info.getNodeRef())));
        }
        if (isMinimalInfo && includeParam.contains("properties")) {
            transfer.setProperties(this.mapFromNodeProperties(info.getProperties()));
        }
        if (!isMinimalInfo && propertyFilter.isAllowed("transferAccessionIndicator") || isMinimalInfo && includeParam.contains("transferAccessionIndicator")) {
            transfer.setTransferAccessionIndicator((Boolean)this.nodeService.getProperty(info.getNodeRef(), RecordsManagementModel.PROP_TRANSFER_ACCESSION_INDICATOR));
        }
        if (!isMinimalInfo && propertyFilter.isAllowed("transferLocation") || isMinimalInfo && includeParam.contains("transferLocation")) {
            transfer.setTransferLocation((String)((Object)this.nodeService.getProperty(info.getNodeRef(), RecordsManagementModel.PROP_TRANSFER_LOCATION)));
        }
        if (!isMinimalInfo && propertyFilter.isAllowed("transferPDFIndicator") || isMinimalInfo && includeParam.contains("transferPDFIndicator")) {
            transfer.setTransferPDFIndicator((Boolean)this.nodeService.getProperty(info.getNodeRef(), RecordsManagementModel.PROP_TRANSFER_PDF_INDICATOR));
        }
    }

    private void mapTransferChildInfo(TransferChild transferChild, FileInfo info, List<String> includeParam, boolean isMinimalInfo) {
        if (includeParam == null || includeParam.isEmpty()) {
            return;
        }
        if (RecordsManagementModel.TYPE_RECORD_FOLDER.equals((Object)info.getType())) {
            if (isMinimalInfo && includeParam.contains("isRecordFolder")) {
                transferChild.setIsRecordFolder(true);
            }
            if (isMinimalInfo && includeParam.contains("isRecord")) {
                transferChild.setIsRecord(false);
            }
            if (isMinimalInfo && includeParam.contains("isClosed")) {
                transferChild.setIsClosed((Boolean)this.nodeService.getProperty(info.getNodeRef(), RecordsManagementModel.PROP_IS_CLOSED));
            }
        } else {
            if (isMinimalInfo && includeParam.contains("isRecordFolder")) {
                transferChild.setIsRecordFolder(false);
            }
            if (isMinimalInfo && includeParam.contains("isRecord")) {
                transferChild.setIsRecord(true);
            }
            if (isMinimalInfo && includeParam.contains("isClosed")) {
                transferChild.setIsClosed(null);
            }
        }
    }

    private void mapRecordCategoryChildInfo(RecordCategoryChild recordCategoryChild, FileInfo info, List<String> includeParam, BeanPropertiesFilter propertyFilter, boolean isMinimalInfo) {
        if (isMinimalInfo && (includeParam == null || includeParam.isEmpty())) {
            return;
        }
        if (RecordsManagementModel.TYPE_RECORD_FOLDER.equals((Object)info.getType())) {
            if (this.isRecordFolder(isMinimalInfo, propertyFilter, includeParam)) {
                recordCategoryChild.setIsRecordFolder(true);
            }
            if (this.isRecordCategory(isMinimalInfo, propertyFilter, includeParam)) {
                recordCategoryChild.setIsRecordCategory(false);
            }
            if (this.isRecordCategoryChildClosed(isMinimalInfo, propertyFilter, includeParam)) {
                recordCategoryChild.setIsClosed((Boolean)this.nodeService.getProperty(info.getNodeRef(), RecordsManagementModel.PROP_IS_CLOSED));
            }
            if (includeParam.contains("hasRetentionSchedule")) {
                recordCategoryChild.setHasRetentionSchedule(null);
            }
        } else {
            if (this.isRecordFolder(isMinimalInfo, propertyFilter, includeParam)) {
                recordCategoryChild.setIsRecordFolder(false);
            }
            if (this.isRecordCategory(isMinimalInfo, propertyFilter, includeParam)) {
                recordCategoryChild.setIsRecordCategory(true);
            }
            if (includeParam.contains("hasRetentionSchedule")) {
                DispositionSchedule ds = this.dispositionService.getDispositionSchedule(info.getNodeRef());
                recordCategoryChild.setHasRetentionSchedule(ds != null);
            }
            if (this.isRecordCategoryChildClosed(isMinimalInfo, propertyFilter, includeParam)) {
                recordCategoryChild.setIsClosed(null);
            }
        }
    }

    private boolean isRecordCategoryChildClosed(boolean isMinimalInfo, BeanPropertiesFilter propertyFilter, List<String> includeParam) {
        return !isMinimalInfo && propertyFilter.isAllowed("isClosed") || isMinimalInfo && includeParam.contains("isClosed");
    }

    private boolean isRecordCategory(boolean isMinimalInfo, BeanPropertiesFilter propertyFilter, List<String> includeParam) {
        return !isMinimalInfo && propertyFilter.isAllowed("isRecordCategory") || isMinimalInfo && includeParam.contains("isRecordCategory");
    }

    private boolean isRecordFolder(boolean isMinimalInfo, BeanPropertiesFilter propertyFilter, List<String> includeParam) {
        return !isMinimalInfo && propertyFilter.isAllowed("isRecordFolder") || isMinimalInfo && includeParam.contains("isRecordFolder");
    }

    private void mapRecordInfo(Record record, FileInfo info, List<String> includeParam) {
        Serializable val;
        if (includeParam == null || includeParam.isEmpty()) {
            return;
        }
        if (includeParam.contains("isCompleted")) {
            record.setIsCompleted(this.nodeService.hasAspect(info.getNodeRef(), RecordsManagementModel.ASPECT_DECLARED_RECORD));
        }
        if (includeParam.contains("content") && (val = (Serializable)info.getProperties().get(ContentModel.PROP_CONTENT)) instanceof ContentData) {
            ContentData cd = (ContentData)val;
            String mimeType = cd.getMimetype();
            String mimeTypeName = (String)this.serviceRegistry.getMimetypeService().getDisplaysByMimetype().get(mimeType);
            ContentInfo contentInfo = new ContentInfo(mimeType, mimeTypeName, Long.valueOf(cd.getSize()), cd.getEncoding());
            record.setContent(contentInfo);
        }
    }

    private List<String> mapFromNodeAspects(Set<QName> nodeAspects) {
        return this.nodes.mapFromNodeAspects(nodeAspects, EXCLUDED_NS, EXCLUDED_ASPECTS);
    }

    private Map<String, Object> mapFromNodeProperties(Map<QName, Serializable> properties) {
        return this.nodes.mapFromNodeProperties(properties, new ArrayList(), new HashMap(), EXCLUDED_NS, EXCLUDED_PROPS);
    }

    private void mapAssociations(RMNode rmNode, FileInfo info, List<String> includeParam) {
        if (includeParam.contains("association")) {
            QName assocTypeQName;
            NodeRef nodeRef = info.getNodeRef();
            ChildAssociationRef parentAssocRef = this.nodeService.getPrimaryParent(nodeRef);
            if (parentAssocRef == null || parentAssocRef.getParentRef() == null || !parentAssocRef.getParentRef().equals((Object)rmNode.getParentId())) {
                List parentAssocRefs = this.nodeService.getParentAssocs(nodeRef);
                for (ChildAssociationRef pAssocRef : parentAssocRefs) {
                    if (!pAssocRef.getParentRef().equals((Object)rmNode.getParentId())) continue;
                    parentAssocRef = pAssocRef;
                    break;
                }
            }
            if (parentAssocRef != null && (assocTypeQName = parentAssocRef.getTypeQName()) != null && !EXCLUDED_NS.contains(assocTypeQName.getNamespaceURI())) {
                AssocChild childAssoc = new AssocChild(assocTypeQName.toPrefixString((NamespacePrefixResolver)this.namespaceService), parentAssocRef.isPrimary());
                rmNode.setAssociation((Assoc)childAssoc);
            }
        }
    }

    public HoldModel createHoldModel(FileInfo info) {
        return new HoldModel(info.getNodeRef().getId(), (String)info.getProperties().get(ContentModel.PROP_NAME), (String)info.getProperties().get(ContentModel.PROP_DESCRIPTION), (String)info.getProperties().get(RecordsManagementModel.PROP_HOLD_REASON));
    }

    public RoleModel createRoleModel(Role role, List<String> assignedUsers, List<String> assignedGroups) {
        return new RoleModel(role.getName(), role.getDisplayLabel(), role.getCapabilities().stream().map(this::createCapabilityModel).sorted(Comparator.comparing(CapabilityModel::name)).toList(), role.getRoleGroupName(), role.getGroupShortName(), assignedUsers, assignedGroups);
    }

    public CapabilityModel createCapabilityModel(Capability capability) {
        return new CapabilityModel(capability.getName(), capability.getTitle(), capability.getDescription(), this.createGroupModel(capability.getGroup()), capability.getIndex());
    }

    public GroupModel createGroupModel(Group group) {
        if (group == null) {
            return null;
        }
        return new GroupModel(group.getId(), group.getTitle());
    }

    public FilePlan createFilePlan(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        FilePlan filePlan = new FilePlan();
        this.mapBasicInfo(filePlan, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(filePlan, info, parameters.getInclude(), isMinimalInfo);
        return filePlan;
    }

    public RecordCategory createRecordCategory(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        RecordCategory recordCategory = new RecordCategory();
        this.mapBasicInfo(recordCategory, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(recordCategory, info, parameters.getInclude(), isMinimalInfo);
        if (parameters.getInclude().contains("hasRetentionSchedule")) {
            DispositionSchedule ds = this.dispositionService.getDispositionSchedule(info.getNodeRef());
            recordCategory.setHasRetentionSchedule(ds != null);
        }
        return recordCategory;
    }

    public RecordFolder createRecordFolder(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        RecordFolder recordFolder = new RecordFolder();
        this.mapBasicInfo(recordFolder, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(recordFolder, info, parameters.getInclude(), isMinimalInfo);
        if (parameters.getInclude().contains("isClosed")) {
            recordFolder.setIsClosed((Boolean)this.nodeService.getProperty(info.getNodeRef(), RecordsManagementModel.PROP_IS_CLOSED));
        }
        return recordFolder;
    }

    public UnfiledContainer createUnfiledContainer(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        UnfiledContainer unfiledContainer = new UnfiledContainer();
        this.mapBasicInfo(unfiledContainer, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(unfiledContainer, info, parameters.getInclude(), isMinimalInfo);
        return unfiledContainer;
    }

    public TransferContainer createTransferContainer(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        TransferContainer transferContainer = new TransferContainer();
        this.mapTransferContainerInfo(transferContainer, info, mapUserInfo, parameters.getFilter(), parameters.getInclude(), isMinimalInfo);
        return transferContainer;
    }

    public Transfer createTransfer(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        Transfer transfer = new Transfer();
        this.mapTransferInfo(transfer, info, mapUserInfo, parameters.getFilter(), parameters.getInclude(), isMinimalInfo);
        return transfer;
    }

    public TransferChild createTransferChild(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        TransferChild transferChild = new TransferChild();
        this.mapBasicInfo(transferChild, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(transferChild, info, parameters.getInclude(), isMinimalInfo);
        this.mapTransferChildInfo(transferChild, info, parameters.getInclude(), isMinimalInfo);
        return transferChild;
    }

    public UnfiledContainerChild createUnfiledContainerChild(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        UnfiledContainerChild unfiledContainerChild = new UnfiledContainerChild();
        this.mapBasicInfo(unfiledContainerChild, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(unfiledContainerChild, info, parameters.getInclude(), isMinimalInfo);
        this.mapUnfiledChildInfo(unfiledContainerChild, info, parameters.getFilter());
        if (unfiledContainerChild.getIsRecord().booleanValue()) {
            this.mapAssociations(unfiledContainerChild, info, parameters.getInclude());
        }
        return unfiledContainerChild;
    }

    public UnfiledRecordFolder createUnfiledRecordFolder(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        UnfiledRecordFolder unfiledChild = new UnfiledRecordFolder();
        this.mapBasicInfo(unfiledChild, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(unfiledChild, info, parameters.getInclude(), isMinimalInfo);
        return unfiledChild;
    }

    public UnfiledRecordFolderChild createUnfiledRecordFolderChild(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        UnfiledRecordFolderChild unfiledRecordFolderChild = new UnfiledRecordFolderChild();
        this.mapBasicInfo(unfiledRecordFolderChild, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(unfiledRecordFolderChild, info, parameters.getInclude(), isMinimalInfo);
        this.mapUnfiledChildInfo(unfiledRecordFolderChild, info, parameters.getFilter());
        if (unfiledRecordFolderChild.getIsRecord().booleanValue()) {
            this.mapAssociations(unfiledRecordFolderChild, info, parameters.getInclude());
        }
        return unfiledRecordFolderChild;
    }

    public RecordCategoryChild createRecordCategoryChild(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        RecordCategoryChild recordCategoryChild = new RecordCategoryChild();
        this.mapBasicInfo(recordCategoryChild, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(recordCategoryChild, info, parameters.getInclude(), isMinimalInfo);
        this.mapRecordCategoryChildInfo(recordCategoryChild, info, parameters.getInclude(), parameters.getFilter(), isMinimalInfo);
        return recordCategoryChild;
    }

    public Record createRecord(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        Record record = new Record();
        this.mapBasicInfo(record, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(record, info, parameters.getInclude(), isMinimalInfo);
        this.mapRecordInfo(record, info, parameters.getInclude());
        this.mapAssociations(record, info, parameters.getInclude());
        return record;
    }

    public RetentionSchedule mapRetentionScheduleData(DispositionSchedule dispositionSchedule) {
        RetentionSchedule retentionSchedule = new RetentionSchedule();
        retentionSchedule.setId(dispositionSchedule.getNodeRef().getId());
        if (dispositionSchedule.getNodeRef() != null) {
            NodeRef parent = this.nodeService.getPrimaryParent(dispositionSchedule.getNodeRef()).getParentRef();
            retentionSchedule.setParentId(parent.getId());
        }
        retentionSchedule.setInstructions(dispositionSchedule.getDispositionInstructions());
        retentionSchedule.setAuthority(dispositionSchedule.getDispositionAuthority());
        retentionSchedule.setIsRecordLevel(dispositionSchedule.isRecordLevelDisposition());
        boolean unpublishedUpdates = dispositionSchedule.getDispositionActionDefinitions().stream().map(DispositionActionDefinition::getNodeRef).anyMatch(actionDefNodeRef -> this.nodeService.hasAspect(actionDefNodeRef, RecordsManagementModel.ASPECT_UNPUBLISHED_UPDATE));
        retentionSchedule.setUnpublishedUpdates(unpublishedUpdates);
        return retentionSchedule;
    }

    public RetentionScheduleActionDefinition mapRetentionScheduleActionDefData(DispositionActionDefinition dispositionActionDefinition) {
        RetentionScheduleActionDefinition retentionScheduleActionDefinition = new RetentionScheduleActionDefinition();
        this.mapRetentionActionProperties(dispositionActionDefinition, retentionScheduleActionDefinition);
        this.mapPeriodProperties(dispositionActionDefinition, retentionScheduleActionDefinition);
        this.mapEventsProperties(dispositionActionDefinition, retentionScheduleActionDefinition);
        return retentionScheduleActionDefinition;
    }

    private void mapRetentionActionProperties(DispositionActionDefinition dispositionActionDefinition, RetentionScheduleActionDefinition retentionScheduleActionDefinition) {
        retentionScheduleActionDefinition.setId(dispositionActionDefinition.getId());
        retentionScheduleActionDefinition.setName(dispositionActionDefinition.getName());
        retentionScheduleActionDefinition.setDescription(dispositionActionDefinition.getDescription());
        retentionScheduleActionDefinition.setEligibleOnFirstCompleteEvent(dispositionActionDefinition.eligibleOnFirstCompleteEvent());
        if (this.nodeService.getProperty(dispositionActionDefinition.getNodeRef(), RecordsManagementModel.PROP_COMBINE_DISPOSITION_STEP_CONDITIONS) != null) {
            retentionScheduleActionDefinition.setCombineRetentionStepConditions((Boolean)this.nodeService.getProperty(dispositionActionDefinition.getNodeRef(), RecordsManagementModel.PROP_COMBINE_DISPOSITION_STEP_CONDITIONS));
        }
        retentionScheduleActionDefinition.setLocation(dispositionActionDefinition.getLocation());
        if (dispositionActionDefinition.getGhostOnDestroy() != null) {
            retentionScheduleActionDefinition.setRetainRecordMetadataAfterDestruction(dispositionActionDefinition.getGhostOnDestroy().equals("ghost"));
        }
        retentionScheduleActionDefinition.setIndex(dispositionActionDefinition.getIndex());
    }

    private void mapPeriodProperties(DispositionActionDefinition dispositionActionDefinition, RetentionScheduleActionDefinition retentionScheduleActionDefinition) {
        String period;
        if (dispositionActionDefinition.getPeriodProperty() != null) {
            retentionScheduleActionDefinition.setPeriodProperty(dispositionActionDefinition.getPeriodProperty().toPrefixString((NamespacePrefixResolver)this.namespaceService));
        }
        if (!(period = dispositionActionDefinition.getPeriod().toString()).isEmpty()) {
            String[] periodArray = period.split("\\|");
            if (periodArray.length > 0) {
                retentionScheduleActionDefinition.setPeriod(periodArray[0]);
            }
            if (periodArray.length > 1) {
                try {
                    retentionScheduleActionDefinition.setPeriodAmount(Integer.parseInt(periodArray[1]));
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("Error parsing period amount: {}{}", new Object[]{numberFormatException.getMessage(), periodArray[1], numberFormatException});
                    throw numberFormatException;
                }
            }
        }
    }

    private void mapEventsProperties(DispositionActionDefinition dispositionActionDefinition, RetentionScheduleActionDefinition retentionScheduleActionDefinition) {
        List<RecordsManagementEvent> events = dispositionActionDefinition.getEvents();
        if (events != null && !events.isEmpty()) {
            List<String> eventNames = events.stream().map(RecordsManagementEvent::getName).collect(Collectors.toList());
            retentionScheduleActionDefinition.setEvents(eventNames);
        }
    }

    public void mapRetentionScheduleOptionalInfo(RetentionSchedule retentionSchedule, DispositionSchedule schedule, List<String> includeParam) {
        if (includeParam != null && !includeParam.isEmpty() && includeParam.contains("actions")) {
            List<RetentionScheduleActionDefinition> actions = schedule.getDispositionActionDefinitions().stream().map(this::mapRetentionScheduleActionDefData).collect(Collectors.toList());
            retentionSchedule.setActions(actions);
        }
    }

    public Map<QName, Serializable> createRetentionActionDefinitionParams(RetentionScheduleActionDefinition nodeInfo) {
        HashMap<QName, Serializable> actionDefinitionParams = new HashMap<QName, Serializable>();
        String retentionActionName = nodeInfo.getName();
        if (nodeInfo.getName().equals(RetentionSteps.DESTROY_NODE.stepName) || nodeInfo.getName().equals(RetentionSteps.DESTROY_CONTENT.stepName)) {
            retentionActionName = "destroy";
        }
        actionDefinitionParams.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_NAME, (Serializable)((Object)retentionActionName));
        actionDefinitionParams.put(RecordsManagementModel.PROP_DISPOSITION_DESCRIPTION, (Serializable)((Object)nodeInfo.getDescription()));
        StringBuilder retentionPeriod = new StringBuilder(nodeInfo.getPeriod()).append("|");
        if (this.isPeriodAmountApplicable(nodeInfo.getPeriod())) {
            retentionPeriod.append(nodeInfo.getPeriodAmount());
        }
        actionDefinitionParams.put(RecordsManagementModel.PROP_DISPOSITION_PERIOD, (Serializable)((Object)retentionPeriod.toString()));
        QName periodProperty = QName.createQName((String)nodeInfo.getPeriodProperty(), (NamespacePrefixResolver)this.namespaceService);
        actionDefinitionParams.put(RecordsManagementModel.PROP_DISPOSITION_PERIOD_PROPERTY, (Serializable)periodProperty);
        actionDefinitionParams.put(RecordsManagementModel.PROP_DISPOSITION_EVENT_COMBINATION, Boolean.valueOf(nodeInfo.isEligibleOnFirstCompleteEvent()));
        boolean combineConditions = nodeInfo.getName().equals(RetentionSteps.ACCESSION.stepName) && nodeInfo.isCombineRetentionStepConditions();
        actionDefinitionParams.put(RecordsManagementModel.PROP_COMBINE_DISPOSITION_STEP_CONDITIONS, Boolean.valueOf(combineConditions));
        if (nodeInfo.getLocation() != null && nodeInfo.getName().equals(RetentionSteps.TRANSFER.stepName)) {
            actionDefinitionParams.put(RecordsManagementModel.PROP_DISPOSITION_LOCATION, (Serializable)((Object)nodeInfo.getLocation()));
        }
        List<String> inputEvents = nodeInfo.getEvents();
        actionDefinitionParams.put(RecordsManagementModel.PROP_DISPOSITION_EVENT, (Serializable)((Object)inputEvents));
        if (RetentionSteps.DESTROY_CONTENT.stepName.equals(nodeInfo.getName())) {
            actionDefinitionParams.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_GHOST_ON_DESTROY, (Serializable)((Object)"ghost"));
        } else if (RetentionSteps.DESTROY_NODE.stepName.equals(nodeInfo.getName())) {
            actionDefinitionParams.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_GHOST_ON_DESTROY, (Serializable)((Object)"delete"));
        }
        return actionDefinitionParams;
    }

    public List<DispositionActionDefinition> getRetentionActions(NodeRef retentionScheduleNodeRef) {
        List assocs = this.nodeService.getChildAssocs(retentionScheduleNodeRef, (QNamePattern)RecordsManagementModel.ASSOC_DISPOSITION_ACTION_DEFINITIONS, RegexQNamePattern.MATCH_ALL);
        List<DispositionActionDefinition> actions = IntStream.range(0, assocs.size()).mapToObj(index -> {
            ChildAssociationRef assoc = (ChildAssociationRef)assocs.get(index);
            return new DispositionActionDefinitionImpl(this.services.getRecordsManagementEventService(), this.services.getRecordsManagementActionService(), this.nodeService, assoc.getChildRef(), index);
        }).collect(Collectors.toList());
        return actions;
    }

    private boolean isPeriodAmountApplicable(String period) {
        return period.equals(RetentionPeriod.DAY.periodName) || period.equals(RetentionPeriod.MONTH.periodName) || period.equals(RetentionPeriod.QUARTER.periodName) || period.equals(RetentionPeriod.WEEK.periodName) || period.equals(RetentionPeriod.XML_DURATION.periodName) || period.equals(RetentionPeriod.YEAR.periodName);
    }
}

