/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.disposition;

import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.webscripts.GUID;

public class CutOffTest
extends BaseRMTestCase {
    public void testCutOffRecordFolder() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef recordFolder = null;

            @Override
            public void given() {
                this.recordFolder = CutOffTest.this.recordFolderService.createRecordFolder(CutOffTest.this.rmContainer, GUID.generate());
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("eventName", "case_closed");
                CutOffTest.this.rmActionService.executeRecordsManagementAction(this.recordFolder, "completeEvent", params);
            }

            @Override
            public void when() {
                CutOffTest.this.rmActionService.executeRecordsManagementAction(this.recordFolder, "cutoff", null);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)CutOffTest.this.dispositionService.isDisposableItemCutoff(this.recordFolder));
            }
        });
    }

    public void testCutOffClosedRecordFolder() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef recordFolder = null;

            @Override
            public void given() {
                this.recordFolder = CutOffTest.this.recordFolderService.createRecordFolder(CutOffTest.this.rmContainer, GUID.generate());
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("eventName", "case_closed");
                CutOffTest.this.rmActionService.executeRecordsManagementAction(this.recordFolder, "completeEvent", params);
                CutOffTest.this.recordFolderService.closeRecordFolder(this.recordFolder);
            }

            @Override
            public void when() {
                CutOffTest.this.rmActionService.executeRecordsManagementAction(this.recordFolder, "cutoff", null);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)CutOffTest.this.dispositionService.isDisposableItemCutoff(this.recordFolder));
            }
        });
    }

    public void testCutOffUncutOffRecordFolder() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef recordFolder = null;

            @Override
            public void given() {
                this.recordFolder = CutOffTest.this.recordFolderService.createRecordFolder(CutOffTest.this.rmContainer, GUID.generate());
                CutOffTest.this.nodeService.addAspect(this.recordFolder, RecordsManagementModel.ASPECT_UNCUT_OFF, null);
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("eventName", "case_closed");
                CutOffTest.this.rmActionService.executeRecordsManagementAction(this.recordFolder, "completeEvent", params);
            }

            @Override
            public void when() {
                CutOffTest.this.rmActionService.executeRecordsManagementAction(this.recordFolder, "cutoff", null);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)CutOffTest.this.dispositionService.isDisposableItemCutoff(this.recordFolder));
            }
        });
    }

    public void testCutOffUncutOffRecordFolderFromSchedule() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef recordFolder = null;

            @Override
            public void given() {
                this.recordFolder = CutOffTest.this.recordFolderService.createRecordFolder(CutOffTest.this.rmContainer, GUID.generate());
                CutOffTest.this.nodeService.addAspect(this.recordFolder, RecordsManagementModel.ASPECT_UNCUT_OFF, null);
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("eventName", "case_closed");
                CutOffTest.this.rmActionService.executeRecordsManagementAction(this.recordFolder, "completeEvent", params);
            }

            @Override
            public void when() {
                HashMap<String, Boolean> params = new HashMap<String, Boolean>(1);
                params.put("rm.no-error-check", Boolean.FALSE);
                try {
                    CutOffTest.this.rmActionService.executeRecordsManagementAction(this.recordFolder, "cutoff", params);
                }
                catch (AlfrescoRuntimeException alfrescoRuntimeException) {
                    // empty catch block
                }
            }

            @Override
            public void then() {
                TestCase.assertFalse((boolean)CutOffTest.this.dispositionService.isDisposableItemCutoff(this.recordFolder));
            }
        });
    }
}

