/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.action;

import java.io.Serializable;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class CreateRecordActionTest
extends BaseRMTestCase {
    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    public void testCreateRecordAction() {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)CreateRecordActionTest.this.permissionService.hasPermission(CreateRecordActionTest.this.dmDocument, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)CreateRecordActionTest.this.permissionService.hasPermission(CreateRecordActionTest.this.filePlan, "ViewRecords"));
                Action action = CreateRecordActionTest.this.actionService.createAction("create-record");
                action.setParameterValue("hide-record", (Serializable)Boolean.valueOf(false));
                action.setParameterValue("file-plan", (Serializable)CreateRecordActionTest.this.filePlan);
                CreateRecordActionTest.this.actionService.executeAction(action, CreateRecordActionTest.this.dmDocument);
                return null;
            }

            public void test(Void result) throws Exception {
                TestCase.assertTrue((boolean)CreateRecordActionTest.this.recordService.isRecord(CreateRecordActionTest.this.dmDocument));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)CreateRecordActionTest.this.permissionService.hasPermission(CreateRecordActionTest.this.dmDocument, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)CreateRecordActionTest.this.permissionService.hasPermission(CreateRecordActionTest.this.filePlan, "ViewRecords"));
            }
        }, this.dmCollaborator);
    }

    public void testCreateRecordActionWithLocation() {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertFalse((boolean)CreateRecordActionTest.this.recordService.isRecord(CreateRecordActionTest.this.dmDocument1));
                Action action = CreateRecordActionTest.this.actionService.createAction("create-record");
                action.setParameterValue("hide-record", (Serializable)Boolean.valueOf(false));
                action.setParameterValue("file-plan", (Serializable)CreateRecordActionTest.this.filePlan);
                action.setParameterValue("path", (Serializable)((Object)"rmContainer/rmFolder"));
                CreateRecordActionTest.this.actionService.executeAction(action, CreateRecordActionTest.this.dmDocument1);
                return null;
            }

            public void test(Void result) throws Exception {
                TestCase.assertTrue((boolean)CreateRecordActionTest.this.recordService.isRecord(CreateRecordActionTest.this.dmDocument1));
                TestCase.assertTrue((boolean)CreateRecordActionTest.this.recordService.isFiled(CreateRecordActionTest.this.dmDocument1));
                NodeRef parent = CreateRecordActionTest.this.nodeService.getPrimaryParent(CreateRecordActionTest.this.dmDocument1).getParentRef();
                TestCase.assertEquals((Object)CreateRecordActionTest.this.rmFolder, (Object)parent);
            }
        }, "admin");
    }

    public void testCreateRecordActionWithLocationWithSpaces() {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertFalse((boolean)CreateRecordActionTest.this.recordService.isRecord(CreateRecordActionTest.this.dmDocument1));
                Action action = CreateRecordActionTest.this.actionService.createAction("create-record");
                action.setParameterValue("hide-record", (Serializable)Boolean.valueOf(false));
                action.setParameterValue("file-plan", (Serializable)CreateRecordActionTest.this.filePlan);
                action.setParameterValue("path", (Serializable)((Object)"rm Container/rm Folder"));
                CreateRecordActionTest.this.actionService.executeAction(action, CreateRecordActionTest.this.dmDocument1);
                return null;
            }

            public void test(Void result) throws Exception {
                TestCase.assertTrue((boolean)CreateRecordActionTest.this.recordService.isRecord(CreateRecordActionTest.this.dmDocument1));
                TestCase.assertTrue((boolean)CreateRecordActionTest.this.recordService.isFiled(CreateRecordActionTest.this.dmDocument1));
                NodeRef parent = CreateRecordActionTest.this.nodeService.getPrimaryParent(CreateRecordActionTest.this.dmDocument1).getParentRef();
                TestCase.assertEquals((Object)CreateRecordActionTest.this.rm_Folder, (Object)parent);
            }
        }, "admin");
    }
}

