/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditService;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.surf.util.ISO8601DateFormat;
import org.springframework.extensions.webscripts.DeclarativeWebScript;

public class BaseAuditAdminWebScript
extends DeclarativeWebScript {
    protected RecordsManagementAuditService rmAuditService;
    protected FilePlanService filePlanService;

    public void setRecordsManagementAuditService(RecordsManagementAuditService rmAuditService) {
        this.rmAuditService = rmAuditService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    protected Map<String, Object> createAuditStatusModel() {
        HashMap<String, Object> auditStatus = new HashMap<String, Object>(3);
        auditStatus.put("started", ISO8601DateFormat.format((Date)this.rmAuditService.getDateAuditLogLastStarted(this.getDefaultFilePlan())));
        auditStatus.put("stopped", ISO8601DateFormat.format((Date)this.rmAuditService.getDateAuditLogLastStopped(this.getDefaultFilePlan())));
        auditStatus.put("enabled", this.rmAuditService.isAuditLogEnabled(this.getDefaultFilePlan()));
        return auditStatus;
    }

    protected NodeRef getDefaultFilePlan() {
        NodeRef filePlan = this.filePlanService.getFilePlanBySiteId("rm");
        if (filePlan == null) {
            throw new AlfrescoRuntimeException("Default file plan not found.");
        }
        return filePlan;
    }
}

