/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.dm;

import java.io.Serializable;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionModel;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionPolicy;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RecordableVersionConfigAction
extends ActionExecuterAbstractBase {
    private static Log LOGGER = LogFactory.getLog(RecordableVersionConfigAction.class);
    public static final String NAME = "recordable-version-config";
    public static final String PARAM_VERSION = "version";
    private NodeService nodeService;
    private DictionaryService dictionaryService;

    protected NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        if (this.passedChecks(actionedUponNodeRef)) {
            String version = (String)((Object)action.getParameterValue(PARAM_VERSION));
            this.getNodeService().setProperty(actionedUponNodeRef, RecordableVersionModel.PROP_RECORDABLE_VERSION_POLICY, (Serializable)((Object)RecordableVersionPolicy.valueOf(version)));
        }
    }

    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add((ParameterDefinition)new ParameterDefinitionImpl(PARAM_VERSION, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_VERSION), false, "ac-versions"));
    }

    private boolean passedChecks(NodeRef actionedUponNodeRef) {
        String message;
        boolean passedChecks = true;
        if (!this.getNodeService().exists(actionedUponNodeRef)) {
            passedChecks = false;
            if (LOGGER.isDebugEnabled()) {
                String message2 = this.buildLogMessage(actionedUponNodeRef, "' because the node does not exist.");
                LOGGER.debug((Object)message2);
            }
        }
        QName type = this.getNodeService().getType(actionedUponNodeRef);
        if (!this.getDictionaryService().isSubClass(type, ContentModel.TYPE_CONTENT)) {
            passedChecks = false;
            if (LOGGER.isDebugEnabled()) {
                message = this.buildLogMessage(actionedUponNodeRef, "' because the type of the node '" + type.getLocalName() + "' is not supported.");
                LOGGER.debug((Object)message);
            }
        }
        if (this.getNodeService().hasAspect(actionedUponNodeRef, RecordsManagementModel.ASPECT_RECORD)) {
            passedChecks = false;
            if (LOGGER.isDebugEnabled()) {
                message = this.buildLogMessage(actionedUponNodeRef, "' because the rule cannot be applied to records.");
                LOGGER.debug((Object)message);
            }
        }
        if (!this.getNodeService().hasAspect(actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            passedChecks = false;
            if (LOGGER.isDebugEnabled()) {
                String buildLogMessage = this.buildLogMessage(actionedUponNodeRef, "' because the rule cannot be applied to records.");
                LOGGER.debug((Object)buildLogMessage);
            }
        }
        return passedChecks;
    }

    private String buildLogMessage(NodeRef actionedUponNodeRef, String messagePart) {
        StringBuilder sb = new StringBuilder();
        sb.append("Cannot set recordable version config for '");
        sb.append(actionedUponNodeRef.toString());
        sb.append(messagePart);
        return sb.toString();
    }
}

