/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionResult;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.surf.util.ISO8601DateFormat;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RmActionPost
extends DeclarativeWebScript {
    private static Log logger = LogFactory.getLog(RmActionPost.class);
    private static final String PARAM_NAME = "name";
    private static final String PARAM_NODE_REF = "nodeRef";
    private static final String PARAM_NODE_REFS = "nodeRefs";
    private static final String PARAM_PARAMS = "params";
    private NodeService nodeService;
    private RecordsManagementActionService rmActionService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRecordsManagementActionService(RecordsManagementActionService rmActionService) {
        this.rmActionService = rmActionService;
    }

    public Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String reqContentAsString;
        try {
            reqContentAsString = req.getContent().getContent();
        }
        catch (IOException iox) {
            throw new WebScriptException(400, "Could not read content from req.", (Throwable)iox);
        }
        String actionName = null;
        ArrayList<NodeRef> targetNodeRefs = new ArrayList<NodeRef>(1);
        HashMap<String, Serializable> actionParams = new HashMap<String, Serializable>(3);
        try {
            JSONArray jsonArray;
            JSONObject jsonObj = new JSONObject(new JSONTokener(reqContentAsString));
            if (jsonObj.has(PARAM_NAME)) {
                actionName = jsonObj.getString(PARAM_NAME);
            }
            if (jsonObj.has(PARAM_NODE_REF)) {
                NodeRef nodeRef = new NodeRef(jsonObj.getString(PARAM_NODE_REF));
                targetNodeRefs.add(nodeRef);
            }
            if (jsonObj.has(PARAM_NODE_REFS) && (jsonArray = jsonObj.getJSONArray(PARAM_NODE_REFS)).length() != 0) {
                targetNodeRefs = new ArrayList(jsonArray.length());
                for (int i = 0; i < jsonArray.length(); ++i) {
                    NodeRef nodeRef = new NodeRef(jsonArray.getString(i));
                    targetNodeRefs.add(nodeRef);
                }
            }
            if (jsonObj.has(PARAM_PARAMS)) {
                JSONObject paramsObj = jsonObj.getJSONObject(PARAM_PARAMS);
                Iterator iter = paramsObj.keys();
                while (iter.hasNext()) {
                    String nextKeyString = (String)iter.next();
                    Object nextValue = paramsObj.get(nextKeyString);
                    if (nextValue instanceof JSONObject && ((JSONObject)nextValue).has("iso8601")) {
                        String dateStringValue = ((JSONObject)nextValue).getString("iso8601");
                        nextValue = ISO8601DateFormat.parse((String)dateStringValue);
                    }
                    actionParams.put(nextKeyString, (Serializable)nextValue);
                }
            }
        }
        catch (JSONException exception) {
            throw new WebScriptException(400, "Unable to parse request JSON.", (Throwable)exception);
        }
        if (actionName == null) {
            throw new WebScriptException(400, "A mandatory parameter has not been provided in URL");
        }
        StringBuilder targetNodeRefsString = new StringBuilder(30);
        boolean firstTime = true;
        for (NodeRef targetNodeRef : targetNodeRefs) {
            if (!this.nodeService.exists(targetNodeRef)) {
                throw new WebScriptException(404, "The targetNode does not exist (" + targetNodeRef.toString() + ")");
            }
            if (firstTime) {
                firstTime = false;
            } else {
                targetNodeRefsString.append(", ");
            }
            targetNodeRefsString.append(targetNodeRef.toString());
        }
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Executing Record Action ").append(actionName).append(", (").append(targetNodeRefsString.toString()).append("), ").append(actionParams);
            logger.debug((Object)msg.toString());
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (targetNodeRefs.isEmpty()) {
            RecordsManagementActionResult result = this.rmActionService.executeRecordsManagementAction(actionName, actionParams);
            if (result.getValue() != null) {
                model.put("result", result.getValue().toString());
            }
        } else {
            Map<NodeRef, RecordsManagementActionResult> resultMap = this.rmActionService.executeRecordsManagementAction(targetNodeRefs, actionName, actionParams);
            HashMap<String, String> results = new HashMap<String, String>(resultMap.size());
            for (Map.Entry<NodeRef, RecordsManagementActionResult> entry : resultMap.entrySet()) {
                Object value = entry.getValue().getValue();
                if (value == null) continue;
                results.put(entry.getKey().toString(), value.toString());
            }
            model.put("results", results);
        }
        model.put("message", "Successfully queued action [" + actionName + "] on " + targetNodeRefsString.toString());
        return model;
    }
}

