/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.impl;

import org.alfresco.module.org_alfresco_module_rm.dod5015.DOD5015Model;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.rest.api.impl.SitesImpl;
import org.alfresco.rest.api.model.Site;
import org.alfresco.rest.api.model.SiteUpdate;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rm.rest.api.RMSites;
import org.alfresco.rm.rest.api.model.RMSite;
import org.alfresco.rm.rest.api.model.RMSiteCompliance;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;

public class RMSitesImpl
extends SitesImpl
implements RMSites {
    private static final String RM_SITE_PRESET = "rm-site-dashboard";
    private static final String RM_SITE_ID = "rm";
    private static final int SITE_MAXLEN_TITLE = 256;
    private static final int SITE_MAXLEN_DESCRIPTION = 512;

    @Override
    public RMSite createRMSite(RMSite rmSite, Parameters parameters) {
        RMSiteCompliance compliance = rmSite.getCompliance();
        if (compliance == null) {
            compliance = RMSiteCompliance.STANDARD;
        }
        Site site = this.createSite(rmSite, parameters);
        return new RMSite(site, compliance);
    }

    protected SiteInfo createSite(Site site) {
        return this.siteService.createSite(RM_SITE_PRESET, RM_SITE_ID, site.getTitle(), site.getDescription(), SiteVisibility.PUBLIC, this.getRMSiteType((RMSite)site));
    }

    protected Site validateSite(Site site) {
        String siteTitle = site.getTitle();
        if (siteTitle == null || siteTitle.isEmpty()) {
            throw new InvalidArgumentException("Site title is expected: " + siteTitle);
        }
        if (siteTitle.length() > 256) {
            throw new InvalidArgumentException("Site title exceeds max length of 256 characters");
        }
        String siteDescription = site.getDescription();
        if (siteDescription == null) {
            site.setDescription("");
        }
        if (siteDescription != null && siteDescription.length() > 512) {
            throw new InvalidArgumentException("Site description exceeds max length of 512 characters");
        }
        return site;
    }

    @Override
    public RMSite updateRMSite(String siteId, SiteUpdate update, Parameters parameters) {
        Site updatedSite = this.updateSite(siteId, update, parameters);
        SiteInfo siteInfo = this.siteService.getSite(siteId);
        RMSiteCompliance compliance = this.getCompliance(siteInfo);
        return new RMSite(updatedSite, compliance);
    }

    private RMSiteCompliance getCompliance(SiteInfo siteInfo) {
        NodeRef nodeRef = siteInfo.getNodeRef();
        QName siteType = this.nodeService.getType(nodeRef);
        RMSiteCompliance compliance = RecordsManagementModel.TYPE_RM_SITE.equals((Object)siteType) ? RMSiteCompliance.STANDARD : RMSiteCompliance.DOD5015;
        return compliance;
    }

    private QName getRMSiteType(RMSite rmSite) {
        RMSiteCompliance compliance = rmSite.getCompliance();
        if (compliance == null || compliance.equals((Object)RMSiteCompliance.STANDARD)) {
            return RecordsManagementModel.TYPE_RM_SITE;
        }
        return DOD5015Model.TYPE_DOD_5015_SITE;
    }

    @Override
    public RMSite getRMSite(String siteId) {
        Site site = this.getSite(siteId);
        SiteInfo siteInfo = this.siteService.getSite(siteId);
        RMSiteCompliance compliance = this.getCompliance(siteInfo);
        return new RMSite(site, compliance);
    }

    @Override
    public void deleteRMSite(String siteId, Parameters parameters) {
        this.deleteSite(siteId, parameters);
        this.solveRMSiteNodeRefCaching();
    }

    private void solveRMSiteNodeRefCaching() {
        this.siteService.hasSite(RM_SITE_ID);
    }
}

