/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.issue;

import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.RetryingTransactionHelperTestCase;
import org.springframework.extensions.webscripts.GUID;

public class RM4619Test
extends BaseRMTestCase {
    public void testConvertFolderToCategory() throws Exception {
        final NodeRef recordCategory = (NodeRef)this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                FileInfo info = RM4619Test.this.fileFolderService.create(RM4619Test.this.filePlan, GUID.generate(), ContentModel.TYPE_FOLDER);
                return info.getNodeRef();
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                TestCase.assertEquals((Object)RecordsManagementModel.TYPE_RECORD_CATEGORY, (Object)RM4619Test.this.nodeService.getType(recordCategory));
                TestCase.assertNotNull((Object)RM4619Test.this.nodeService.getProperty(recordCategory, RecordsManagementModel.PROP_IDENTIFIER));
                return null;
            }
        }, "admin");
    }

    public void testConvertFolderToRecordFolder() throws Exception {
        final NodeRef recordFolder = (NodeRef)this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                FileInfo info = RM4619Test.this.fileFolderService.create(RM4619Test.this.rmContainer, GUID.generate(), ContentModel.TYPE_FOLDER);
                return info.getNodeRef();
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                TestCase.assertEquals((Object)RecordsManagementModel.TYPE_RECORD_FOLDER, (Object)RM4619Test.this.nodeService.getType(recordFolder));
                TestCase.assertNotNull((Object)RM4619Test.this.nodeService.getProperty(recordFolder, RecordsManagementModel.PROP_IDENTIFIER));
                return null;
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                TestCase.assertTrue((boolean)RM4619Test.this.nodeService.hasAspect(recordFolder, RecordsManagementModel.ASPECT_RM_SEARCH));
                return null;
            }
        }, "admin");
    }

    public void testConvertFolderToUnfiledRecordFolder() throws Exception {
        final NodeRef folder1 = (NodeRef)this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                FileInfo folder = RM4619Test.this.fileFolderService.create(RM4619Test.this.unfiledContainer, GUID.generate(), ContentModel.TYPE_FOLDER);
                return folder.getNodeRef();
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                TestCase.assertEquals((Object)RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER, (Object)RM4619Test.this.nodeService.getType(folder1));
                TestCase.assertNotNull((Object)RM4619Test.this.nodeService.getProperty(folder1, RecordsManagementModel.PROP_IDENTIFIER));
                return null;
            }
        }, "admin");
        final NodeRef folder2 = (NodeRef)this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                FileInfo folder = RM4619Test.this.fileFolderService.create(folder1, GUID.generate(), ContentModel.TYPE_FOLDER);
                return folder.getNodeRef();
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                TestCase.assertEquals((Object)RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER, (Object)RM4619Test.this.nodeService.getType(folder2));
                TestCase.assertNotNull((Object)RM4619Test.this.nodeService.getProperty(folder2, RecordsManagementModel.PROP_IDENTIFIER));
                return null;
            }
        }, "admin");
    }
}

