/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.issue;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteServiceImpl;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;

public class RM978Test
extends BaseRMTestCase {
    private NodeRef documentLibrary2;
    private String user;

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected void setupCollaborationSiteTestDataImpl() {
        super.setupCollaborationSiteTestDataImpl();
        String collabSiteId2 = GUID.generate();
        this.siteService.createSite("site-dashboard", collabSiteId2, GUID.generate(), GUID.generate(), SiteVisibility.PUBLIC);
        this.documentLibrary2 = SiteServiceImpl.getSiteContainer((String)collabSiteId2, (String)"documentLibrary", (boolean)true, (SiteService)this.siteService, (TransactionService)this.transactionService, (TaggingService)this.taggingService);
        RM978Test.assertNotNull((String)"Collaboration site document library component was not successfully created.", (Object)this.documentLibrary2);
        this.user = GUID.generate();
        this.createPerson(this.user);
        this.siteService.setMembership(this.collabSiteId, this.user, "SiteContributor");
        this.siteService.setMembership(collabSiteId2, this.user, "SiteContributor");
        this.siteService.setMembership(this.siteId, this.user, "SiteConsumer");
        this.filePlanRoleService.assignRoleToAuthority(this.filePlan, "PowerUser", this.user);
    }

    public void testMoveDocumentToFolderInCollabSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.user){
            private NodeRef folder1;
            private NodeRef folder2;
            private NodeRef document1;
            private String document1Name;
            {
                this.document1Name = GUID.generate();
            }

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.document1 = RM978Test.this.fileFolderService.create(this.folder1, this.document1Name, ContentModel.TYPE_CONTENT).getNodeRef();
                this.folder2 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.move(this.document1, this.folder2, null);
            }

            @Override
            public void then() {
                List folder1ChildAssocs = RM978Test.this.nodeService.getChildAssocs(this.folder1);
                TestCase.assertEquals((int)0, (int)folder1ChildAssocs.size());
                List folder2ChildAssocs = RM978Test.this.nodeService.getChildAssocs(this.folder2);
                TestCase.assertNotNull((Object)folder2ChildAssocs);
                TestCase.assertEquals((int)1, (int)folder2ChildAssocs.size());
                NodeRef movedDocument = ((ChildAssociationRef)folder2ChildAssocs.iterator().next()).getChildRef();
                String movedDocumentName = (String)((Object)RM978Test.this.nodeService.getProperty(movedDocument, ContentModel.PROP_NAME));
                TestCase.assertEquals((String)this.document1Name, (String)movedDocumentName);
            }
        });
    }

    public void testMoveDocumentToDocumentLibraryInCollabSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.user){
            private NodeRef folder1;
            private NodeRef document1;
            private String document1Name;
            {
                this.document1Name = GUID.generate();
            }

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.document1 = RM978Test.this.fileFolderService.create(this.folder1, this.document1Name, ContentModel.TYPE_CONTENT).getNodeRef();
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.move(this.document1, RM978Test.this.documentLibrary, null);
            }

            @Override
            public void then() {
                List folder1ChildAssocs = RM978Test.this.nodeService.getChildAssocs(this.folder1);
                TestCase.assertEquals((int)0, (int)folder1ChildAssocs.size());
                List childAssocs = RM978Test.this.nodeService.getChildAssocs(RM978Test.this.documentLibrary);
                TestCase.assertNotNull((Object)childAssocs);
                ArrayList<String> childNames = new ArrayList<String>();
                for (ChildAssociationRef childAssociationRef : childAssocs) {
                    NodeRef childRef = childAssociationRef.getChildRef();
                    childNames.add((String)((Object)RM978Test.this.nodeService.getProperty(childRef, ContentModel.PROP_NAME)));
                }
                TestCase.assertTrue((boolean)childNames.contains(this.document1Name));
            }
        });
    }

    public void testMoveFolderToFolderInCollabSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.user){
            private NodeRef folder1;
            private NodeRef folder2;
            private String folder1Name;
            {
                this.folder1Name = GUID.generate();
            }

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, this.folder1Name, ContentModel.TYPE_FOLDER).getNodeRef();
                this.folder2 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.move(this.folder1, this.folder2, null);
            }

            @Override
            public void then() {
                List folder2ChildAssocs = RM978Test.this.nodeService.getChildAssocs(this.folder2);
                TestCase.assertEquals((int)1, (int)folder2ChildAssocs.size());
                NodeRef movedFolder = ((ChildAssociationRef)folder2ChildAssocs.iterator().next()).getChildRef();
                String movedDocumentName = (String)((Object)RM978Test.this.nodeService.getProperty(movedFolder, ContentModel.PROP_NAME));
                TestCase.assertEquals((String)this.folder1Name, (String)movedDocumentName);
            }
        });
    }

    public void testMoveDocumentToFolderInDifferentCollabSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.user){
            private NodeRef folder1;
            private NodeRef folder2;
            private NodeRef document1;
            private String document1Name;
            {
                this.document1Name = GUID.generate();
            }

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.document1 = RM978Test.this.fileFolderService.create(this.folder1, this.document1Name, ContentModel.TYPE_CONTENT).getNodeRef();
                this.folder2 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary2, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.move(this.document1, this.folder2, null);
            }

            @Override
            public void then() {
                List folder1ChildAssocs = RM978Test.this.nodeService.getChildAssocs(this.folder1);
                TestCase.assertEquals((int)0, (int)folder1ChildAssocs.size());
                List folder2ChildAssocs = RM978Test.this.nodeService.getChildAssocs(this.folder2);
                TestCase.assertNotNull((Object)folder2ChildAssocs);
                TestCase.assertEquals((int)1, (int)folder2ChildAssocs.size());
                NodeRef movedDocument = ((ChildAssociationRef)folder2ChildAssocs.iterator().next()).getChildRef();
                String movedDocumentName = (String)((Object)RM978Test.this.nodeService.getProperty(movedDocument, ContentModel.PROP_NAME));
                TestCase.assertEquals((String)this.document1Name, (String)movedDocumentName);
            }
        });
    }

    public void testMoveDocumentToDocumentLibraryInDifferentCollabSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.user){
            private NodeRef folder1;
            private NodeRef document1;
            private String document1Name;
            {
                this.document1Name = GUID.generate();
            }

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.document1 = RM978Test.this.fileFolderService.create(this.folder1, this.document1Name, ContentModel.TYPE_CONTENT).getNodeRef();
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.move(this.document1, RM978Test.this.documentLibrary2, null);
            }

            @Override
            public void then() {
                List folder1ChildAssocs = RM978Test.this.nodeService.getChildAssocs(this.folder1);
                TestCase.assertEquals((int)0, (int)folder1ChildAssocs.size());
                List childAssocs = RM978Test.this.nodeService.getChildAssocs(RM978Test.this.documentLibrary2);
                TestCase.assertNotNull((Object)childAssocs);
                ArrayList<String> childNames = new ArrayList<String>();
                for (ChildAssociationRef childAssociationRef : childAssocs) {
                    NodeRef childRef = childAssociationRef.getChildRef();
                    childNames.add((String)((Object)RM978Test.this.nodeService.getProperty(childRef, ContentModel.PROP_NAME)));
                }
                TestCase.assertTrue((boolean)childNames.contains(this.document1Name));
            }
        });
    }

    public void testMoveFolderToFolderInDifferentCollabSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.user){
            private NodeRef folder1;
            private NodeRef folder2;
            private String folder1Name;
            {
                this.folder1Name = GUID.generate();
            }

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, this.folder1Name, ContentModel.TYPE_FOLDER).getNodeRef();
                this.folder2 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary2, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.move(this.folder1, this.folder2, null);
            }

            @Override
            public void then() {
                List folder2ChildAssocs = RM978Test.this.nodeService.getChildAssocs(this.folder2);
                TestCase.assertEquals((int)1, (int)folder2ChildAssocs.size());
                NodeRef movedFolder = ((ChildAssociationRef)folder2ChildAssocs.iterator().next()).getChildRef();
                String movedDocumentName = (String)((Object)RM978Test.this.nodeService.getProperty(movedFolder, ContentModel.PROP_NAME));
                TestCase.assertEquals((String)this.folder1Name, (String)movedDocumentName);
            }
        });
    }

    public void testMoveDocumentInFilePlanInRmSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AlfrescoRuntimeException.class, this.user){
            private NodeRef folder1;
            private NodeRef document1;

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.document1 = RM978Test.this.fileFolderService.create(this.folder1, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.move(this.document1, RM978Test.this.filePlan, GUID.generate());
            }
        });
    }

    public void testMoveDocumentInCategoryInRmSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AlfrescoRuntimeException.class, this.user){
            private NodeRef folder1;
            private NodeRef document1;
            private NodeRef rmCategory;

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.document1 = RM978Test.this.fileFolderService.create(this.folder1, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        rmCategory = RM978Test.this.filePlanService.createRecordCategory(RM978Test.this.filePlan, GUID.generate());
                        return null;
                    }
                }, (String)AuthenticationUtil.getAdminUserName());
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.move(this.document1, this.rmCategory, GUID.generate());
            }
        });
    }

    public void testMoveDocumentInFolderInRmSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.user){
            private NodeRef folder1;
            private NodeRef document1;
            private String document1Name;
            private NodeRef rmCategory;
            private NodeRef rmFolder;
            {
                this.document1Name = GUID.generate();
            }

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.document1 = RM978Test.this.fileFolderService.create(this.folder1, this.document1Name, ContentModel.TYPE_CONTENT).getNodeRef();
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        rmCategory = RM978Test.this.filePlanService.createRecordCategory(RM978Test.this.filePlan, GUID.generate());
                        rmFolder = RM978Test.this.recordFolderService.createRecordFolder(rmCategory, GUID.generate());
                        return null;
                    }
                }, (String)AuthenticationUtil.getAdminUserName());
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        RM978Test.this.filePlanPermissionService.setPermission(rmFolder, RM978Test.this.user, "Filing");
                        return null;
                    }
                }, (String)AuthenticationUtil.getAdminUserName());
                RM978Test.this.fileFolderService.move(this.document1, this.rmFolder, null);
            }

            @Override
            public void then() {
                List folder1ChildAssocs = RM978Test.this.nodeService.getChildAssocs(this.folder1);
                TestCase.assertEquals((int)0, (int)folder1ChildAssocs.size());
                List rmFolderChildAssocs = RM978Test.this.nodeService.getChildAssocs(this.rmFolder);
                TestCase.assertEquals((int)1, (int)rmFolderChildAssocs.size());
                NodeRef movedDocument = ((ChildAssociationRef)rmFolderChildAssocs.iterator().next()).getChildRef();
                String recordIdentifier = (String)((Object)RM978Test.this.nodeService.getProperty(movedDocument, RecordsManagementModel.PROP_IDENTIFIER));
                TestCase.assertNotNull((Object)recordIdentifier);
                String movedDocumentName = (String)((Object)RM978Test.this.nodeService.getProperty(movedDocument, ContentModel.PROP_NAME));
                TestCase.assertEquals((String)(this.document1Name + " (" + recordIdentifier + ")"), (String)movedDocumentName);
            }
        });
    }

    public void testMoveFolderInFilePlanInRmSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AlfrescoRuntimeException.class, this.user){
            private NodeRef folder1;

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.move(this.folder1, RM978Test.this.filePlan, GUID.generate());
            }
        });
    }

    public void testMoveFolderInCategoryInRmSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AlfrescoRuntimeException.class, this.user){
            private NodeRef folder1;
            private NodeRef rmCategory;

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        rmCategory = RM978Test.this.filePlanService.createRecordCategory(RM978Test.this.filePlan, GUID.generate());
                        return null;
                    }
                }, (String)AuthenticationUtil.getAdminUserName());
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.move(this.folder1, this.rmCategory, GUID.generate());
            }
        });
    }

    public void testMoveFolderInFolderInRmSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AlfrescoRuntimeException.class, this.user){
            private NodeRef folder1;
            private NodeRef rmCategory;
            private NodeRef rmFolder;

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        rmCategory = RM978Test.this.filePlanService.createRecordCategory(RM978Test.this.filePlan, GUID.generate());
                        rmFolder = RM978Test.this.recordFolderService.createRecordFolder(rmCategory, GUID.generate());
                        return null;
                    }
                }, (String)AuthenticationUtil.getAdminUserName());
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.move(this.folder1, this.rmFolder, GUID.generate());
            }
        });
    }

    public void testCopyDocumentToFolderInCollabSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.user){
            private NodeRef folder1;
            private NodeRef folder2;
            private NodeRef document1;
            private String document1Name;
            {
                this.document1Name = GUID.generate();
            }

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.document1 = RM978Test.this.fileFolderService.create(this.folder1, this.document1Name, ContentModel.TYPE_CONTENT).getNodeRef();
                this.folder2 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.copy(this.document1, this.folder2, null);
            }

            @Override
            public void then() {
                List folder1ChildAssocs = RM978Test.this.nodeService.getChildAssocs(this.folder1);
                TestCase.assertEquals((int)1, (int)folder1ChildAssocs.size());
                List folder2ChildAssocs = RM978Test.this.nodeService.getChildAssocs(this.folder2);
                TestCase.assertNotNull((Object)folder2ChildAssocs);
                TestCase.assertEquals((int)1, (int)folder2ChildAssocs.size());
                NodeRef movedDocument = ((ChildAssociationRef)folder2ChildAssocs.iterator().next()).getChildRef();
                String movedDocumentName = (String)((Object)RM978Test.this.nodeService.getProperty(movedDocument, ContentModel.PROP_NAME));
                TestCase.assertEquals((String)this.document1Name, (String)movedDocumentName);
            }
        });
    }

    public void testCopyDocumentToDocumentLibraryInCollabSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.user){
            private NodeRef folder1;
            private NodeRef document1;
            private String document1Name;
            {
                this.document1Name = GUID.generate();
            }

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.document1 = RM978Test.this.fileFolderService.create(this.folder1, this.document1Name, ContentModel.TYPE_CONTENT).getNodeRef();
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.copy(this.document1, RM978Test.this.documentLibrary, null);
            }

            @Override
            public void then() {
                List folder1ChildAssocs = RM978Test.this.nodeService.getChildAssocs(this.folder1);
                TestCase.assertEquals((int)1, (int)folder1ChildAssocs.size());
                List childAssocs = RM978Test.this.nodeService.getChildAssocs(RM978Test.this.documentLibrary);
                TestCase.assertNotNull((Object)childAssocs);
                ArrayList<String> childNames = new ArrayList<String>();
                for (ChildAssociationRef childAssociationRef : childAssocs) {
                    NodeRef childRef = childAssociationRef.getChildRef();
                    childNames.add((String)((Object)RM978Test.this.nodeService.getProperty(childRef, ContentModel.PROP_NAME)));
                }
                TestCase.assertTrue((boolean)childNames.contains(this.document1Name));
            }
        });
    }

    public void testCopyFolderToFolderInCollabSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.user){
            private NodeRef folder1;
            private NodeRef folder2;
            private String folder1Name;
            {
                this.folder1Name = GUID.generate();
            }

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, this.folder1Name, ContentModel.TYPE_FOLDER).getNodeRef();
                this.folder2 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.copy(this.folder1, this.folder2, null);
            }

            @Override
            public void then() {
                List folder2ChildAssocs = RM978Test.this.nodeService.getChildAssocs(this.folder2);
                TestCase.assertEquals((int)1, (int)folder2ChildAssocs.size());
                NodeRef movedFolder = ((ChildAssociationRef)folder2ChildAssocs.iterator().next()).getChildRef();
                String movedDocumentName = (String)((Object)RM978Test.this.nodeService.getProperty(movedFolder, ContentModel.PROP_NAME));
                TestCase.assertEquals((String)this.folder1Name, (String)movedDocumentName);
            }
        });
    }

    public void testCopyDocumentToFolderInDifferentCollabSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.user){
            private NodeRef folder1;
            private NodeRef folder2;
            private NodeRef document1;
            private String document1Name;
            {
                this.document1Name = GUID.generate();
            }

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.document1 = RM978Test.this.fileFolderService.create(this.folder1, this.document1Name, ContentModel.TYPE_CONTENT).getNodeRef();
                this.folder2 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary2, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.copy(this.document1, this.folder2, null);
            }

            @Override
            public void then() {
                List folder1ChildAssocs = RM978Test.this.nodeService.getChildAssocs(this.folder1);
                TestCase.assertEquals((int)1, (int)folder1ChildAssocs.size());
                List folder2ChildAssocs = RM978Test.this.nodeService.getChildAssocs(this.folder2);
                TestCase.assertNotNull((Object)folder2ChildAssocs);
                TestCase.assertEquals((int)1, (int)folder2ChildAssocs.size());
                NodeRef movedDocument = ((ChildAssociationRef)folder2ChildAssocs.iterator().next()).getChildRef();
                String movedDocumentName = (String)((Object)RM978Test.this.nodeService.getProperty(movedDocument, ContentModel.PROP_NAME));
                TestCase.assertEquals((String)this.document1Name, (String)movedDocumentName);
            }
        });
    }

    public void testCopyDocumentToDocumentLibraryInDifferentCollabSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.user){
            private NodeRef folder1;
            private NodeRef document1;
            private String document1Name;
            {
                this.document1Name = GUID.generate();
            }

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.document1 = RM978Test.this.fileFolderService.create(this.folder1, this.document1Name, ContentModel.TYPE_CONTENT).getNodeRef();
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.copy(this.document1, RM978Test.this.documentLibrary2, null);
            }

            @Override
            public void then() {
                List folder1ChildAssocs = RM978Test.this.nodeService.getChildAssocs(this.folder1);
                TestCase.assertEquals((int)1, (int)folder1ChildAssocs.size());
                List childAssocs = RM978Test.this.nodeService.getChildAssocs(RM978Test.this.documentLibrary2);
                TestCase.assertNotNull((Object)childAssocs);
                ArrayList<String> childNames = new ArrayList<String>();
                for (ChildAssociationRef childAssociationRef : childAssocs) {
                    NodeRef childRef = childAssociationRef.getChildRef();
                    childNames.add((String)((Object)RM978Test.this.nodeService.getProperty(childRef, ContentModel.PROP_NAME)));
                }
                TestCase.assertTrue((boolean)childNames.contains(this.document1Name));
            }
        });
    }

    public void testCopyFolderToFolderInDifferentCollabSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.user){
            private NodeRef folder1;
            private NodeRef folder2;
            private String folder1Name;
            {
                this.folder1Name = GUID.generate();
            }

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, this.folder1Name, ContentModel.TYPE_FOLDER).getNodeRef();
                this.folder2 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary2, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.copy(this.folder1, this.folder2, null);
            }

            @Override
            public void then() {
                List folder2ChildAssocs = RM978Test.this.nodeService.getChildAssocs(this.folder2);
                TestCase.assertEquals((int)1, (int)folder2ChildAssocs.size());
                NodeRef movedFolder = ((ChildAssociationRef)folder2ChildAssocs.iterator().next()).getChildRef();
                String movedDocumentName = (String)((Object)RM978Test.this.nodeService.getProperty(movedFolder, ContentModel.PROP_NAME));
                TestCase.assertEquals((String)this.folder1Name, (String)movedDocumentName);
            }
        });
    }

    public void testCopyDocumentInFilePlanInRmSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AlfrescoRuntimeException.class, this.user){
            private NodeRef folder1;
            private NodeRef document1;

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.document1 = RM978Test.this.fileFolderService.create(this.folder1, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.copy(this.document1, RM978Test.this.filePlan, GUID.generate());
            }
        });
    }

    public void testCopyDocumentInCategoryInRmSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AlfrescoRuntimeException.class, this.user){
            private NodeRef folder1;
            private NodeRef document1;
            private NodeRef rmCategory;

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.document1 = RM978Test.this.fileFolderService.create(this.folder1, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        rmCategory = RM978Test.this.filePlanService.createRecordCategory(RM978Test.this.filePlan, GUID.generate());
                        return null;
                    }
                }, (String)AuthenticationUtil.getAdminUserName());
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.copy(this.document1, this.rmCategory, GUID.generate());
            }
        });
    }

    public void testCopyDocumentInFolderInRmSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AlfrescoRuntimeException.class, this.user){
            private NodeRef folder1;
            private NodeRef document1;
            private String document1Name;
            private NodeRef rmCategory;
            private NodeRef rmFolder;
            {
                this.document1Name = GUID.generate();
            }

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.document1 = RM978Test.this.fileFolderService.create(this.folder1, this.document1Name, ContentModel.TYPE_CONTENT).getNodeRef();
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        rmCategory = RM978Test.this.filePlanService.createRecordCategory(RM978Test.this.filePlan, GUID.generate());
                        rmFolder = RM978Test.this.recordFolderService.createRecordFolder(rmCategory, GUID.generate());
                        return null;
                    }
                }, (String)AuthenticationUtil.getAdminUserName());
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        RM978Test.this.filePlanPermissionService.setPermission(rmFolder, RM978Test.this.user, "Filing");
                        return null;
                    }
                }, (String)AuthenticationUtil.getAdminUserName());
                RM978Test.this.fileFolderService.copy(this.document1, this.rmFolder, null);
            }
        });
    }

    public void testCopyFolderInFilePlanInRmSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AlfrescoRuntimeException.class, this.user){
            private NodeRef folder1;

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.copy(this.folder1, RM978Test.this.filePlan, GUID.generate());
            }
        });
    }

    public void testCopyFolderInCategoryInRmSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AlfrescoRuntimeException.class, this.user){
            private NodeRef folder1;
            private NodeRef rmCategory;

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        rmCategory = RM978Test.this.filePlanService.createRecordCategory(RM978Test.this.filePlan, GUID.generate());
                        return null;
                    }
                }, (String)AuthenticationUtil.getAdminUserName());
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.copy(this.folder1, this.rmCategory, GUID.generate());
            }
        });
    }

    public void testCopyFolderInFolderInRmSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AlfrescoRuntimeException.class, this.user){
            private NodeRef folder1;
            private NodeRef rmCategory;
            private NodeRef rmFolder;

            @Override
            public void given() {
                this.folder1 = RM978Test.this.fileFolderService.create(RM978Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        rmCategory = RM978Test.this.filePlanService.createRecordCategory(RM978Test.this.filePlan, GUID.generate());
                        rmFolder = RM978Test.this.recordFolderService.createRecordFolder(rmCategory, GUID.generate());
                        return null;
                    }
                }, (String)AuthenticationUtil.getAdminUserName());
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                RM978Test.this.fileFolderService.copy(this.folder1, this.rmFolder, GUID.generate());
            }
        });
    }
}

