/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class FilePlanRoleServiceImplTest
extends BaseRMTestCase {
    @Override
    protected boolean isUserTest() {
        return true;
    }

    public void testGetAllRolesContainerGroup() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                String allRolesGroup = FilePlanRoleServiceImplTest.this.filePlanRoleService.getAllRolesContainerGroup(FilePlanRoleServiceImplTest.this.filePlan);
                TestCase.assertNotNull((Object)allRolesGroup);
                return null;
            }
        });
    }

    public void testGetRoles() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                Set roles = FilePlanRoleServiceImplTest.this.filePlanRoleService.getRoles(FilePlanRoleServiceImplTest.this.filePlan);
                TestCase.assertNotNull((Object)roles);
                TestCase.assertTrue((roles.size() != 0 ? 1 : 0) != 0);
                Set rolesIncludingSystemRoles = FilePlanRoleServiceImplTest.this.filePlanRoleService.getRoles(FilePlanRoleServiceImplTest.this.filePlan, true);
                TestCase.assertNotNull((Object)rolesIncludingSystemRoles);
                TestCase.assertTrue((roles.size() != 0 ? 1 : 0) != 0);
                TestCase.assertTrue((roles.size() == rolesIncludingSystemRoles.size() ? 1 : 0) != 0);
                Set rolesWithoutSystemRoles = FilePlanRoleServiceImplTest.this.filePlanRoleService.getRoles(FilePlanRoleServiceImplTest.this.filePlan, false);
                TestCase.assertNotNull((Object)rolesWithoutSystemRoles);
                TestCase.assertTrue((rolesWithoutSystemRoles.size() != 0 ? 1 : 0) != 0);
                TestCase.assertTrue((rolesIncludingSystemRoles.size() > rolesWithoutSystemRoles.size() ? 1 : 0) != 0);
                TestCase.assertTrue((rolesIncludingSystemRoles.size() == rolesWithoutSystemRoles.size() + FilePlanRoleService.SYSTEM_ROLES.size() ? 1 : 0) != 0);
                return null;
            }
        });
    }

    public void testRolesByUser() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                Set roles = FilePlanRoleServiceImplTest.this.filePlanRoleService.getRolesByUser(FilePlanRoleServiceImplTest.this.filePlan, FilePlanRoleServiceImplTest.this.rmUserName);
                TestCase.assertNotNull((Object)roles);
                TestCase.assertEquals((int)1, (int)roles.size());
                Set rolesIncludingSystemRoles = FilePlanRoleServiceImplTest.this.filePlanRoleService.getRolesByUser(FilePlanRoleServiceImplTest.this.filePlan, FilePlanRoleServiceImplTest.this.rmUserName, true);
                TestCase.assertNotNull((Object)rolesIncludingSystemRoles);
                TestCase.assertEquals((int)1, (int)rolesIncludingSystemRoles.size());
                TestCase.assertEquals((int)roles.size(), (int)rolesIncludingSystemRoles.size());
                return null;
            }
        });
    }

    public void testGetRole() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                Role role = FilePlanRoleServiceImplTest.this.filePlanRoleService.getRole(FilePlanRoleServiceImplTest.this.filePlan, "PowerUser");
                TestCase.assertNotNull((Object)role);
                TestCase.assertEquals((String)"PowerUser", (String)role.getName());
                role = FilePlanRoleServiceImplTest.this.filePlanRoleService.getRole(FilePlanRoleServiceImplTest.this.filePlan, "donkey");
                TestCase.assertNull((Object)role);
                return null;
            }
        });
    }

    public void testExistsRole() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertTrue((boolean)FilePlanRoleServiceImplTest.this.filePlanRoleService.existsRole(FilePlanRoleServiceImplTest.this.filePlan, "PowerUser"));
                TestCase.assertFalse((boolean)FilePlanRoleServiceImplTest.this.filePlanRoleService.existsRole(FilePlanRoleServiceImplTest.this.filePlan, "donkey"));
                return null;
            }
        });
    }

    public void testCreateUpdateDeleteRole() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertFalse((boolean)FilePlanRoleServiceImplTest.this.filePlanRoleService.existsRole(FilePlanRoleServiceImplTest.this.filePlan, "Michelle Holt"));
                HashSet<Capability> caps = new HashSet<Capability>(2);
                caps.add(FilePlanRoleServiceImplTest.this.capabilityService.getCapability("AccessAudit"));
                caps.add(FilePlanRoleServiceImplTest.this.capabilityService.getCapability("AddModifyEventDates"));
                Role role = FilePlanRoleServiceImplTest.this.filePlanRoleService.createRole(FilePlanRoleServiceImplTest.this.filePlan, "Michelle Holt", "Michelle Holt", caps);
                TestCase.assertNotNull((Object)role);
                TestCase.assertEquals((String)"Michelle Holt", (String)role.getName());
                TestCase.assertEquals((int)2, (int)role.getCapabilities().size());
                TestCase.assertTrue((boolean)FilePlanRoleServiceImplTest.this.filePlanRoleService.existsRole(FilePlanRoleServiceImplTest.this.filePlan, "Michelle Holt"));
                caps.add(FilePlanRoleServiceImplTest.this.capabilityService.getCapability("AuthorizeAllTransfers"));
                role = FilePlanRoleServiceImplTest.this.filePlanRoleService.updateRole(FilePlanRoleServiceImplTest.this.filePlan, "Michelle Holt", "Michelle Wetherall", caps);
                TestCase.assertNotNull((Object)role);
                TestCase.assertEquals((String)"Michelle Holt", (String)role.getName());
                TestCase.assertEquals((int)3, (int)role.getCapabilities().size());
                TestCase.assertTrue((boolean)FilePlanRoleServiceImplTest.this.filePlanRoleService.existsRole(FilePlanRoleServiceImplTest.this.filePlan, "Michelle Holt"));
                FilePlanRoleServiceImplTest.this.filePlanRoleService.deleteRole(FilePlanRoleServiceImplTest.this.filePlan, "Michelle Holt");
                TestCase.assertFalse((boolean)FilePlanRoleServiceImplTest.this.filePlanRoleService.existsRole(FilePlanRoleServiceImplTest.this.filePlan, "Michelle Holt"));
                return null;
            }
        });
    }

    public void testAuthorityAssignment() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                Set roles = FilePlanRoleServiceImplTest.this.filePlanRoleService.getRolesByUser(FilePlanRoleServiceImplTest.this.filePlan, FilePlanRoleServiceImplTest.this.rmUserName);
                TestCase.assertNotNull((Object)roles);
                TestCase.assertEquals((int)1, (int)roles.size());
                Set authorities = FilePlanRoleServiceImplTest.this.filePlanRoleService.getUsersAssignedToRole(FilePlanRoleServiceImplTest.this.filePlan, "RecordsManager");
                TestCase.assertNotNull((Object)authorities);
                TestCase.assertEquals((int)1, (int)authorities.size());
                authorities = FilePlanRoleServiceImplTest.this.filePlanRoleService.getGroupsAssignedToRole(FilePlanRoleServiceImplTest.this.filePlan, "RecordsManager");
                TestCase.assertNotNull((Object)authorities);
                TestCase.assertEquals((int)0, (int)authorities.size());
                authorities = FilePlanRoleServiceImplTest.this.filePlanRoleService.getAllAssignedToRole(FilePlanRoleServiceImplTest.this.filePlan, "RecordsManager");
                TestCase.assertNotNull((Object)authorities);
                TestCase.assertEquals((int)1, (int)authorities.size());
                FilePlanRoleServiceImplTest.this.filePlanRoleService.assignRoleToAuthority(FilePlanRoleServiceImplTest.this.filePlan, "RecordsManager", FilePlanRoleServiceImplTest.this.rmUserName);
                roles = FilePlanRoleServiceImplTest.this.filePlanRoleService.getRolesByUser(FilePlanRoleServiceImplTest.this.filePlan, FilePlanRoleServiceImplTest.this.rmUserName);
                TestCase.assertNotNull((Object)roles);
                TestCase.assertEquals((int)2, (int)roles.size());
                authorities = FilePlanRoleServiceImplTest.this.filePlanRoleService.getUsersAssignedToRole(FilePlanRoleServiceImplTest.this.filePlan, "RecordsManager");
                TestCase.assertNotNull((Object)authorities);
                TestCase.assertEquals((int)2, (int)authorities.size());
                authorities = FilePlanRoleServiceImplTest.this.filePlanRoleService.getGroupsAssignedToRole(FilePlanRoleServiceImplTest.this.filePlan, "RecordsManager");
                TestCase.assertNotNull((Object)authorities);
                TestCase.assertEquals((int)0, (int)authorities.size());
                authorities = FilePlanRoleServiceImplTest.this.filePlanRoleService.getAllAssignedToRole(FilePlanRoleServiceImplTest.this.filePlan, "RecordsManager");
                TestCase.assertNotNull((Object)authorities);
                TestCase.assertEquals((int)2, (int)authorities.size());
                return null;
            }
        });
    }
}

