/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.type;

import java.io.Serializable;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.identifier.IdentifierService;
import org.alfresco.module.org_alfresco_module_rm.model.BaseBehaviourBean;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.util.RMContainerCacheManager;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

@BehaviourBean(defaultType="rma:recordsManagementContainer")
public class RecordsManagementContainerType
extends BaseBehaviourBean
implements NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.OnDeleteChildAssociationPolicy {
    private static final String BEHAVIOUR_NAME = "onCreateContainerType";
    protected IdentifierService identifierService;
    protected RecordService recordService;
    protected RecordFolderService recordFolderService;
    private RMContainerCacheManager rmContainerCacheManager;
    private static final String MSG_CANNOT_CAST_TO_RM_TYPE = "rm.action.cast-to-rm-type";

    public void setRmContainerCacheManager(RMContainerCacheManager rmContainerCacheManager) {
        this.rmContainerCacheManager = rmContainerCacheManager;
    }

    public void setIdentifierService(IdentifierService identifierService) {
        this.identifierService = identifierService;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setRecordFolderService(RecordFolderService recordFolderService) {
        this.recordFolderService = recordFolderService;
    }

    public void disable() {
        this.getBehaviour(BEHAVIOUR_NAME).disable();
    }

    public void enable() {
        this.getBehaviour(BEHAVIOUR_NAME).enable();
    }

    @Behaviour(kind=BehaviourKind.ASSOCIATION, policy="alf:onCreateChildAssociation", notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void onCreateChildAssoiationFirstEvent(final ChildAssociationRef childAssocRef, boolean bNew) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                QName parentType = RecordsManagementContainerType.this.nodeService.getType(childAssocRef.getParentRef());
                boolean isContentSubType = RecordsManagementContainerType.this.dictionaryService.isSubClass(RecordsManagementContainerType.this.nodeService.getType(childAssocRef.getChildRef()), ContentModel.TYPE_CONTENT);
                boolean parentIsUnfiledRecordContainer = parentType.equals((Object)RecordsManagementModel.TYPE_UNFILED_RECORD_CONTAINER);
                boolean parentIsUnfiledRecordFolder = parentType.equals((Object)RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER);
                NodeRef child = childAssocRef.getChildRef();
                if ((parentIsUnfiledRecordContainer || parentIsUnfiledRecordFolder) && isContentSubType && !RecordsManagementContainerType.this.recordService.isRecord(child)) {
                    if (!RecordsManagementContainerType.this.nodeService.hasAspect(child, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT)) {
                        RecordsManagementContainerType.this.nodeService.addAspect(child, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT, null);
                    }
                    if (!RecordsManagementContainerType.this.nodeService.hasAspect(child, RecordsManagementModel.ASPECT_RECORD)) {
                        RecordsManagementContainerType.this.recordService.makeRecord(child);
                    }
                }
                return null;
            }
        });
    }

    @Behaviour(kind=BehaviourKind.ASSOCIATION, notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT, name="onCreateContainerType")
    public void onCreateChildAssociation(final ChildAssociationRef childAssocRef, boolean isNewNode) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                NodeRef child = childAssocRef.getChildRef();
                if (RecordsManagementContainerType.this.nodeService.exists(child)) {
                    QName childType = RecordsManagementContainerType.this.convertNodeToFileplanComponent(childAssocRef);
                    if (RecordsManagementContainerType.this.dictionaryService.isSubClass(childType, ContentModel.TYPE_FOLDER) && !RecordsManagementContainerType.this.nodeService.hasAspect(child, ContentModel.ASPECT_HIDDEN)) {
                        if (RecordsManagementContainerType.this.dictionaryService.isSubClass(childType, ContentModel.TYPE_SYSTEM_FOLDER)) {
                            RecordsManagementContainerType.this.nodeService.addAspect(child, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT, null);
                        } else {
                            RecordsManagementContainerType.this.setIdenifierProperty(child);
                        }
                    }
                    if (RecordsManagementContainerType.this.rmContainerCacheManager != null) {
                        RecordsManagementContainerType.this.rmContainerCacheManager.add(child);
                    }
                }
                return null;
            }
        });
    }

    @Behaviour(kind=BehaviourKind.ASSOCIATION, notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onDeleteChildAssociation(final ChildAssociationRef childAssocRef) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                NodeRef child = childAssocRef.getChildRef();
                if (RecordsManagementContainerType.this.rmContainerCacheManager != null) {
                    RecordsManagementContainerType.this.rmContainerCacheManager.remove(child);
                }
                return null;
            }
        });
    }

    protected void setIdenifierProperty(final NodeRef nodeRef) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                if (RecordsManagementContainerType.this.nodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT) && RecordsManagementContainerType.this.nodeService.getProperty(nodeRef, RecordsManagementModel.PROP_IDENTIFIER) == null) {
                    String id = RecordsManagementContainerType.this.identifierService.generateIdentifier(nodeRef);
                    RecordsManagementContainerType.this.nodeService.setProperty(nodeRef, RecordsManagementModel.PROP_IDENTIFIER, (Serializable)((Object)id));
                }
                return null;
            }
        });
    }

    protected QName convertNodeToFileplanComponent(ChildAssociationRef childAssocRef) {
        NodeRef child = childAssocRef.getChildRef();
        QName childType = this.nodeService.getType(child);
        QName parentType = this.nodeService.getType(childAssocRef.getParentRef());
        if (childType.equals((Object)ContentModel.TYPE_FOLDER)) {
            if (parentType.equals((Object)TYPE_FILE_PLAN)) {
                this.nodeService.setType(child, TYPE_RECORD_CATEGORY);
                return TYPE_RECORD_CATEGORY;
            }
            if (parentType.equals((Object)TYPE_RECORD_CATEGORY)) {
                this.nodeService.setType(child, TYPE_RECORD_FOLDER);
                return TYPE_RECORD_FOLDER;
            }
            if (parentType.equals((Object)TYPE_UNFILED_RECORD_CONTAINER) || parentType.equals((Object)TYPE_UNFILED_RECORD_FOLDER)) {
                this.nodeService.setType(child, TYPE_UNFILED_RECORD_FOLDER);
                return TYPE_UNFILED_RECORD_FOLDER;
            }
        }
        return childType;
    }
}

