/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.jscript.app.JSONConversionComponent;
import org.alfresco.module.org_alfresco_module_rm.relationship.Relationship;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipDefinition;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipService;
import org.alfresco.module.org_alfresco_module_rm.script.AbstractRmWebScript;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.WebScriptUtils;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RelationshipsGet
extends AbstractRmWebScript {
    private static final String RELATIONSHIPS = "relationships";
    private static final String RELATIONSHIP_LABEL = "relationshipLabel";
    private static final String RELATIONSHIP_UNIQUE_NAME = "relationshipUniqueName";
    private RelationshipService relationshipService;
    private JSONConversionComponent jsonConversionComponent;

    protected RelationshipService getRelationshipService() {
        return this.relationshipService;
    }

    protected JSONConversionComponent getJsonConversionComponent() {
        return this.jsonConversionComponent;
    }

    public void setRelationshipService(RelationshipService relationshipService) {
        this.relationshipService = relationshipService;
    }

    public void setJsonConversionComponent(JSONConversionComponent jsonConversionComponent) {
        this.jsonConversionComponent = jsonConversionComponent;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        NodeRef nodeRef = this.parseRequestForNodeRef(req);
        model.put(RELATIONSHIPS, this.getRelationships(nodeRef));
        return model;
    }

    private List<String> getRelationships(NodeRef nodeRef) {
        ArrayList<String> relationships = new ArrayList<String>();
        Set<Relationship> relationshipsFrom = this.getRelationshipService().getRelationshipsFrom(nodeRef);
        relationships.addAll(this.buildRelationshipData(relationshipsFrom, RelationshipEndPoint.TARGET));
        Set<Relationship> relationshipsTo = this.getRelationshipService().getRelationshipsTo(nodeRef);
        relationships.addAll(this.buildRelationshipData(relationshipsTo, RelationshipEndPoint.SOURCE));
        return relationships;
    }

    private List<String> buildRelationshipData(Set<Relationship> relationships, RelationshipEndPoint relationshipEndPoint) {
        ArrayList<String> result = new ArrayList<String>();
        for (Relationship relationship : relationships) {
            String label;
            NodeRef node;
            String uniqueName = relationship.getUniqueName();
            RelationshipDefinition relationshipDefinition = this.getRelationshipService().getRelationshipDefinition(uniqueName);
            if (relationshipDefinition == null) continue;
            if (RelationshipEndPoint.SOURCE.equals((Object)relationshipEndPoint)) {
                node = relationship.getSource();
                label = relationshipDefinition.getDisplayName().getSourceText();
            } else if (RelationshipEndPoint.TARGET.equals((Object)relationshipEndPoint)) {
                node = relationship.getTarget();
                label = relationshipDefinition.getDisplayName().getTargetText();
            } else {
                throw new WebScriptException(400, "Unknown relationship end point type '" + String.valueOf((Object)relationshipEndPoint) + "'.");
            }
            String nodeDetails = this.getJsonConversionComponent().toJSON(node, true);
            JSONObject jsonObject = WebScriptUtils.createJSONObject(nodeDetails);
            WebScriptUtils.putValueToJSONObject(jsonObject, RELATIONSHIP_LABEL, label);
            WebScriptUtils.putValueToJSONObject(jsonObject, RELATIONSHIP_UNIQUE_NAME, relationshipDefinition.getUniqueName());
            result.add(jsonObject.toString());
        }
        return result;
    }

    private static enum RelationshipEndPoint {
        SOURCE,
        TARGET;

    }
}

