/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.webscript;

import java.io.IOException;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMWebScriptTestCase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class EmailMapScriptTest
extends BaseRMWebScriptTestCase {
    public static final String URL_RM_EMAILMAP = "/api/rma/admin/emailmap";
    public static final String URL_RM_EMAILMAP_DELETE = "/api/rma/admin/emailmap/%s/%s";
    private static final String APPLICATION_JSON = "application/json";

    public void testEmailMap() throws IOException, JSONException {
        TestWebScriptServer.Response getResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RM_EMAILMAP), 200);
        JSONObject getResponseContent = new JSONObject(getResponse.getContentAsString());
        JSONObject getData = getResponseContent.getJSONObject("data");
        JSONArray getMappings = getData.getJSONArray("mappings");
        EmailMapScriptTest.assertTrue((getMappings.length() == 20 ? 1 : 0) != 0);
        JSONObject newMapping = new JSONObject();
        newMapping.put("from", (Object)"messageTo");
        newMapping.put("to", (Object)"rmc:Wibble");
        TestWebScriptServer.Response postResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_RM_EMAILMAP, newMapping.toString(), APPLICATION_JSON), 200);
        JSONObject postResponseContent = new JSONObject(postResponse.getContentAsString());
        JSONObject postData = postResponseContent.getJSONObject("data");
        JSONArray postMappings = postData.getJSONArray("mappings");
        EmailMapScriptTest.assertTrue((postMappings.length() == 21 ? 1 : 0) != 0);
        EmailMapScriptTest.assertTrue((boolean)this.existsMapping(postMappings));
        TestWebScriptServer.Response deleteResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(String.format(URL_RM_EMAILMAP_DELETE, "messageTo", "rmc:Wibble")), 200);
        JSONObject deleteResponseContent = new JSONObject(deleteResponse.getContentAsString());
        JSONObject deleteData = deleteResponseContent.getJSONObject("data");
        JSONArray deleteMappings = deleteData.getJSONArray("mappings");
        EmailMapScriptTest.assertTrue((deleteMappings.length() == 20 ? 1 : 0) != 0);
        EmailMapScriptTest.assertFalse((boolean)this.existsMapping(deleteMappings));
    }

    private boolean existsMapping(JSONArray mappings) throws JSONException {
        boolean result = false;
        for (int i = 0; i < mappings.length(); ++i) {
            String from = mappings.getJSONObject(i).getString("from");
            String to = mappings.getJSONObject(i).getString("to");
            if (!from.equalsIgnoreCase("messageTo") || !to.equalsIgnoreCase("rmc:Wibble")) continue;
            result = true;
            break;
        }
        return result;
    }
}

