/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.forms;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.forms.RecordsManagementFormFilter;
import org.alfresco.module.org_alfresco_module_rm.identifier.IdentifierService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.forms.FieldDefinition;
import org.alfresco.repo.forms.FieldGroup;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.processor.node.FieldUtils;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

public class RecordsManagementTypeFormFilter
extends RecordsManagementFormFilter<TypeDefinition>
implements RecordsManagementModel {
    private static Log logger = LogFactory.getLog(RecordsManagementTypeFormFilter.class);
    protected static final String NAME_FIELD_GROUP_ID = "name";
    protected static final String TITLE_FIELD_GROUP_ID = "title";
    protected static final String DESC_FIELD_GROUP_ID = "description";
    protected static final String OTHER_FIELD_GROUP_ID = "other";
    protected static final FieldGroup NAME_FIELD_GROUP = new FieldGroup("name", null, false, false, null);
    protected static final FieldGroup TITLE_FIELD_GROUP = new FieldGroup("title", null, false, false, null);
    protected static final FieldGroup DESC_FIELD_GROUP = new FieldGroup("description", null, false, false, null);
    protected static final FieldGroup OTHER_FIELD_GROUP = new FieldGroup("other", null, false, false, null);
    protected IdentifierService identifierService;

    public void setIdentifierService(IdentifierService identifierService) {
        this.identifierService = identifierService;
    }

    public void afterGenerate(TypeDefinition type, List<String> fields, List<String> forcedFields, Form form, Map<String, Object> context) {
        QName typeName = type.getName();
        if (this.rmAdminService.isCustomisable(typeName)) {
            this.addCustomRMProperties(typeName, form);
        }
        Set aspects = type.getDefaultAspectNames();
        for (QName aspect : aspects) {
            if (!this.rmAdminService.isCustomisable(aspect)) continue;
            this.addCustomRMProperties(aspect, form);
        }
        List fieldDefs = form.getFieldDefinitions();
        for (FieldDefinition fieldDef : fieldDefs) {
            String prefixName = fieldDef.getName();
            if (prefixName.equals("rma:identifier")) {
                String defaultId = this.identifierService.generateIdentifier(typeName, null);
                fieldDef.setDefaultValue(defaultId);
                continue;
            }
            if (prefixName.equals("rma:vitalRecordIndicator")) {
                fieldDef.setDefaultValue(Boolean.FALSE.toString());
                continue;
            }
            if (!prefixName.equals("rma:reviewPeriod")) continue;
            fieldDef.setDefaultValue("none|0");
        }
    }

    protected void addCustomRMProperties(QName customisableType, Form form) {
        ParameterCheck.mandatory((String)"customisableType", (Object)customisableType);
        ParameterCheck.mandatory((String)"form", (Object)form);
        Map<QName, PropertyDefinition> customProps = this.rmAdminService.getCustomPropertyDefinitions(customisableType);
        if (customProps != null && !customProps.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + customProps.size() + " custom properties for customisable type " + String.valueOf(customisableType)));
            }
            Collection<PropertyDefinition> properties = customProps.values();
            FieldGroup group = new FieldGroup("rm-custom", null, false, false, null);
            List fields = FieldUtils.makePropertyFields(properties, (FieldGroup)group, (NamespaceService)this.namespaceService, (DictionaryService)this.dictionaryService);
            form.addFields((Collection)fields);
        }
    }

    @Override
    public void beforePersist(TypeDefinition item, FormData data) {
        this.recordService.disablePropertyEditableCheck();
        super.beforePersist(item, data);
    }

    @Override
    public void afterPersist(TypeDefinition item, FormData data, NodeRef persistedObject) {
        super.afterPersist(item, data, persistedObject);
        this.recordService.enablePropertyEditableCheck();
    }
}

