/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.capability.declarative;

import java.util.Iterator;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.capability.CompositeCapability;
import org.alfresco.module.org_alfresco_module_rm.capability.declarative.DeclarativeCapability;
import org.alfresco.service.cmr.repository.NodeRef;

public class DeclarativeCompositeCapability
extends DeclarativeCapability
implements CompositeCapability {
    private Set<Capability> capabilities;

    public void setCapabilities(Set<Capability> capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public Set<Capability> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public int evaluateImpl(NodeRef nodeRef) {
        int result = -1;
        for (Capability capability : this.capabilities) {
            int capabilityResult;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Evaluating child capability " + capability.getName() + " on nodeRef " + nodeRef.toString() + " for composite capability " + this.name));
            }
            if ((capabilityResult = capability.evaluate(nodeRef)) != -1) {
                result = 0;
                if (this.isUndetermined() || capabilityResult != 1) break;
                result = 1;
                break;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("Access denied for child capability " + capability.getName() + " on nodeRef " + nodeRef.toString() + " for composite capability " + this.name));
        }
        return result;
    }

    @Override
    public int evaluate(NodeRef source, NodeRef target) {
        int result = 0;
        if (this.getFilePlanService().isFilePlanComponent(source) && this.getFilePlanService().isFilePlanComponent(target)) {
            if (this.checkKinds(source) && this.checkPermissions(source) && this.checkConditions(source)) {
                if (this.targetCapability != null) {
                    result = this.targetCapability.evaluate(target);
                }
                if (-1 != result) {
                    Capability capability;
                    Iterator<Capability> iterator = this.capabilities.iterator();
                    while (iterator.hasNext() && (result = (capability = iterator.next()).evaluate(source, target)) != 1) {
                    }
                }
            } else {
                result = -1;
            }
        }
        return result;
    }
}

