/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.job;

import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.job.RecordsManagementJobExecuter;
import org.alfresco.module.org_alfresco_module_rm.notification.RecordsManagementNotificationHelper;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotifyOfRecordsDueForReviewJobExecuter
extends RecordsManagementJobExecuter {
    private static Log logger = LogFactory.getLog(NotifyOfRecordsDueForReviewJobExecuter.class);
    private RecordsManagementNotificationHelper recordsManagementNotificationHelper;
    private NodeService nodeService;
    private SearchService searchService;

    public void setRecordsManagementNotificationHelper(RecordsManagementNotificationHelper recordsManagementNotificationHelper) {
        this.recordsManagementNotificationHelper = recordsManagementNotificationHelper;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    public void executeImpl() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Job " + this.getClass().getSimpleName() + " starting."));
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                StringBuilder queryBuffer = new StringBuilder();
                queryBuffer.append("ASPECT:\"rma:vitalRecord\" ");
                queryBuffer.append("AND @rma\\:reviewAsOf:[MIN TO NOW] ");
                queryBuffer.append("AND -ASPECT:\"rma:ghosted\" ");
                String query = queryBuffer.toString();
                ResultSet results = NotifyOfRecordsDueForReviewJobExecuter.this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "fts-alfresco", query);
                final List resultNodes = results.getNodeRefs();
                results.close();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found " + resultNodes.size() + " nodes due for review and without notification."));
                }
                if (resultNodes.size() != 0) {
                    RetryingTransactionHelper.RetryingTransactionCallback<Void> txCallbackSendEmail = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        public Void execute() {
                            NotifyOfRecordsDueForReviewJobExecuter.this.recordsManagementNotificationHelper.recordsDueForReviewEmailNotification(resultNodes);
                            return null;
                        }
                    };
                    NotifyOfRecordsDueForReviewJobExecuter.this.retryingTransactionHelper.setMaxRetries(0);
                    NotifyOfRecordsDueForReviewJobExecuter.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)txCallbackSendEmail);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Job " + this.getClass().getSimpleName() + " finished"));
        }
    }
}

