/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.rest.workflow.api.impl.MapBasedQueryWalker;
import org.alfresco.rm.rest.api.RMRoles;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.RolesFilter;
import org.alfresco.rm.rest.api.model.RoleModel;
import org.alfresco.service.cmr.repository.NodeRef;

public class RMRolesImpl
implements RMRoles {
    private ApiNodesModelFactory nodesModelFactory;
    private FilePlanRoleService filePlanRoleService;
    private static final Set<String> LIST_ROLES_QUERY_PROPERTIES = new HashSet<String>(List.of("personId", "systemRoles", "capabilityName"));

    @Override
    public CollectionWithPagingInfo<RoleModel> getRoles(NodeRef filePlan, Parameters parameters) {
        RolesFilter rolesFilter = this.getRolesFilter(parameters.getQuery());
        Set<Role> roles = this.getRolesByFilter(filePlan, rolesFilter);
        List<RoleModel> filteredRoles = roles.stream().map(role -> this.createRoleModel(filePlan, (Role)role, parameters.getInclude())).filter(this.hasRoleCapabilities(rolesFilter.getCapabilities())).toList();
        LinkedList page = filteredRoles.stream().sorted(Comparator.comparing(RoleModel::name)).skip(parameters.getPaging().getSkipCount()).limit(parameters.getPaging().getMaxItems()).collect(Collectors.toCollection(LinkedList::new));
        int totalItems = filteredRoles.size();
        boolean hasMore = parameters.getPaging().getSkipCount() + parameters.getPaging().getMaxItems() < totalItems;
        return CollectionWithPagingInfo.asPaged((Paging)parameters.getPaging(), (Collection)page, (boolean)hasMore, (Integer)totalItems);
    }

    private Predicate<RoleModel> hasRoleCapabilities(List<String> capabilities) {
        return role -> capabilities == null || capabilities.isEmpty() || role.capabilities().stream().anyMatch(capability -> capabilities.contains(capability.name()));
    }

    private Set<Role> getRolesByFilter(NodeRef filePlan, RolesFilter rolesFilter) {
        if (rolesFilter.getPersonId() != null) {
            return this.filePlanRoleService.getRolesByUser(filePlan, rolesFilter.getPersonId(), rolesFilter.includeSystemRoles());
        }
        return this.filePlanRoleService.getRoles(filePlan, rolesFilter.includeSystemRoles());
    }

    private RoleModel createRoleModel(NodeRef filePlan, Role role, List<String> include) {
        List<String> assignedUsers = this.getAssignedUsers(filePlan, role, include);
        List<String> assignedGroups = this.getAssignedGroups(filePlan, role, include);
        return this.nodesModelFactory.createRoleModel(role, assignedUsers, assignedGroups);
    }

    private List<String> getAssignedUsers(NodeRef filePlan, Role role, List<String> include) {
        if (include != null && include.contains("assignedUsers")) {
            return new ArrayList<String>(this.filePlanRoleService.getAllAssignedToRole(filePlan, role.getName()));
        }
        return null;
    }

    private List<String> getAssignedGroups(NodeRef filePlan, Role role, List<String> include) {
        if (include != null && include.contains("assignedGroups")) {
            return new ArrayList<String>(this.filePlanRoleService.getGroupsAssignedToRole(filePlan, role.getName()));
        }
        return null;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void setFilePlanRoleService(FilePlanRoleService filePlanRoleService) {
        this.filePlanRoleService = filePlanRoleService;
    }

    private RolesFilter getRolesFilter(Query queryParameters) {
        RolesFilter.RolesFilterBuilder rolesFilterBuilder = RolesFilter.builder();
        if (queryParameters != null) {
            RolesQueryWalker propertyWalker = new RolesQueryWalker();
            QueryHelper.walk((Query)queryParameters, (QueryHelper.WalkerCallback)propertyWalker);
            rolesFilterBuilder.withPersonId(propertyWalker.getPersonId()).withCapabilities(propertyWalker.getCapabilitiesNames()).withIncludeSystemRoles(propertyWalker.includeSystemRoles());
        }
        return rolesFilterBuilder.build();
    }

    private static class RolesQueryWalker
    extends MapBasedQueryWalker {
        private List<String> capabilitiesNames;

        public RolesQueryWalker() {
            super(LIST_ROLES_QUERY_PROPERTIES, null);
        }

        public void in(String propertyName, boolean negated, String ... propertyValues) {
            if (negated) {
                throw new InvalidArgumentException("Cannot use NOT for " + propertyName);
            }
            if ("capabilityName".equalsIgnoreCase(propertyName)) {
                this.capabilitiesNames = Arrays.asList(propertyValues);
            }
        }

        public void and() {
        }

        public List<String> getCapabilitiesNames() {
            return this.capabilitiesNames;
        }

        public String getPersonId() {
            return (String)this.getProperty("personId", 8, String.class);
        }

        public Boolean includeSystemRoles() {
            return (Boolean)this.getProperty("systemRoles", 8, Boolean.class);
        }
    }
}

