/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.impl;

import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.action.RMActionExecuterAbstractBase;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.surf.util.I18NUtil;

public class UnCutoffAction
extends RMActionExecuterAbstractBase {
    private static final String MSG_UNDO_NOT_LAST = "rm.action.undo-not-last";

    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        if (this.getNodeService().hasAspect(actionedUponNodeRef, ASPECT_DISPOSITION_LIFECYCLE) && this.getNodeService().hasAspect(actionedUponNodeRef, ASPECT_CUT_OFF)) {
            DispositionAction currentDa;
            DispositionAction da = this.getDispositionService().getLastCompletedDispostionAction(actionedUponNodeRef);
            if (da == null || !da.getName().equals("cutoff")) {
                throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_UNDO_NOT_LAST));
            }
            this.getNodeService().removeAspect(actionedUponNodeRef, ASPECT_CUT_OFF);
            this.getNodeService().addAspect(actionedUponNodeRef, ASPECT_UNCUT_OFF, null);
            if (this.getRecordFolderService().isRecordFolder(actionedUponNodeRef)) {
                List<NodeRef> records = this.getRecordService().getRecords(actionedUponNodeRef);
                for (NodeRef record : records) {
                    this.getNodeService().removeAspect(record, ASPECT_CUT_OFF);
                    this.getNodeService().addAspect(record, ASPECT_UNCUT_OFF, null);
                }
            }
            if ((currentDa = this.getDispositionService().getNextDispositionAction(actionedUponNodeRef)) != null) {
                this.getNodeService().deleteNode(currentDa.getNodeRef());
            }
            this.getNodeService().moveNode(da.getNodeRef(), actionedUponNodeRef, ASSOC_NEXT_DISPOSITION_ACTION, ASSOC_NEXT_DISPOSITION_ACTION);
            this.getNodeService().setProperty(da.getNodeRef(), PROP_DISPOSITION_ACTION_STARTED_AT, null);
            this.getNodeService().setProperty(da.getNodeRef(), PROP_DISPOSITION_ACTION_STARTED_BY, null);
            this.getNodeService().setProperty(da.getNodeRef(), PROP_DISPOSITION_ACTION_COMPLETED_AT, null);
            this.getNodeService().setProperty(da.getNodeRef(), PROP_DISPOSITION_ACTION_COMPLETED_BY, null);
        }
    }
}

