/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.security;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.acegisecurity.AccessDeniedException;
import net.sf.acegisecurity.intercept.InterceptorStatusToken;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityInterceptor;
import org.alfresco.service.cmr.security.AccessStatus;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RMMethodSecurityInterceptor
extends MethodSecurityInterceptor {
    protected static final Log LOGGER = LogFactory.getLog(RMMethodSecurityInterceptor.class);
    private static final ThreadLocal<Map<String, CapabilityReport>> CAPABILITIES = new ThreadLocal<Map<String, CapabilityReport>>(){

        @Override
        protected Map<String, CapabilityReport> initialValue() {
            return new HashMap<String, CapabilityReport>();
        }
    };
    private static final ThreadLocal<Boolean> IS_RM_SECURITY_CHECK = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static final ThreadLocal<List<String>> MESSAGES = new ThreadLocal<List<String>>(){

        @Override
        protected List<String> initialValue() {
            return new ArrayList<String>();
        }
    };

    private static AccessStatus translate(int vote) {
        switch (vote) {
            case 0: {
                return AccessStatus.UNDETERMINED;
            }
            case 1: {
                return AccessStatus.ALLOWED;
            }
            case -1: {
                return AccessStatus.DENIED;
            }
        }
        return AccessStatus.UNDETERMINED;
    }

    private static CapabilityReport getCapabilityReport(String name) {
        Map<String, CapabilityReport> map = CAPABILITIES.get();
        CapabilityReport capability = map.get(name);
        if (capability == null) {
            capability = new CapabilityReport();
            capability.name = name;
            map.put(name, capability);
        }
        return capability;
    }

    public static void isRMSecurityChecked(boolean newValue) {
        if (LOGGER.isDebugEnabled()) {
            IS_RM_SECURITY_CHECK.set(newValue);
        }
    }

    public static void addMessage(String message) {
        if (LOGGER.isDebugEnabled()) {
            List<String> messages = MESSAGES.get();
            messages.add(message);
        }
    }

    public static void addMessage(String message, Object ... params) {
        if (LOGGER.isDebugEnabled()) {
            RMMethodSecurityInterceptor.addMessage(MessageFormat.format(message, params));
        }
    }

    public static void reportCapabilityStatus(String name, int status) {
        if (LOGGER.isDebugEnabled()) {
            CapabilityReport capability = RMMethodSecurityInterceptor.getCapabilityReport(name);
            capability.status = RMMethodSecurityInterceptor.translate(status);
        }
    }

    public static void reportCapabilityCondition(String name, String conditionName, boolean expected, boolean actual) {
        if (LOGGER.isDebugEnabled()) {
            CapabilityReport capability = RMMethodSecurityInterceptor.getCapabilityReport(name);
            if (!expected) {
                conditionName = "!" + (String)conditionName;
            }
            capability.conditions.put((String)conditionName, expected == actual);
        }
    }

    public String getFailureReport() {
        Collection<CapabilityReport> capabilities;
        String result = null;
        if (LOGGER.isDebugEnabled() && !(capabilities = CAPABILITIES.get().values()).isEmpty()) {
            StringBuilder buffer = new StringBuilder("\n");
            for (CapabilityReport capability : capabilities) {
                buffer.append("  ").append(capability.name).append(" (").append(capability.status).append(")\n");
                if (capability.conditions.isEmpty()) continue;
                for (Map.Entry<String, Boolean> entry : capability.conditions.entrySet()) {
                    buffer.append("    - ").append(entry.getKey()).append(" (");
                    if (entry.getValue().booleanValue()) {
                        buffer.append("passed");
                    } else {
                        buffer.append("failed");
                    }
                    buffer.append(")\n");
                }
            }
            result = buffer.toString();
        }
        return result;
    }

    protected InterceptorStatusToken beforeInvocation(Object object) {
        InterceptorStatusToken result = null;
        try {
            CAPABILITIES.remove();
            IS_RM_SECURITY_CHECK.remove();
            MESSAGES.remove();
            result = super.beforeInvocation(object);
        }
        catch (AccessDeniedException exception) {
            if (LOGGER.isDebugEnabled()) {
                MethodInvocation mi = (MethodInvocation)object;
                StringBuilder methodDetails = new StringBuilder("\n");
                if (IS_RM_SECURITY_CHECK.get().booleanValue()) {
                    methodDetails.append("RM method security check was performed.\n");
                } else {
                    methodDetails.append("Standard DM method security check was performed.\n");
                }
                boolean first = true;
                methodDetails.append("Failed on method:  ").append(mi.getMethod().getName()).append("(");
                for (Object arg : mi.getArguments()) {
                    if (first) {
                        first = false;
                    } else {
                        methodDetails.append(", ");
                    }
                    if (arg != null) {
                        methodDetails.append(arg.toString());
                        continue;
                    }
                    methodDetails.append("null");
                }
                methodDetails.append(")\n");
                List<String> messages = MESSAGES.get();
                for (String message : messages) {
                    methodDetails.append(message).append("\n");
                }
                String failureReport = this.getFailureReport();
                if (failureReport == null) {
                    throw new AccessDeniedException(exception.getMessage() + String.valueOf(methodDetails), (Throwable)exception);
                }
                throw new AccessDeniedException(exception.getMessage() + String.valueOf(methodDetails) + this.getFailureReport(), (Throwable)exception);
            }
            throw exception;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation mi) throws Throwable {
        Object result = null;
        InterceptorStatusToken token = this.beforeInvocation(mi);
        try {
            result = mi.proceed();
        }
        finally {
            result = super.afterInvocation(token, result);
        }
        return result;
    }

    private static class CapabilityReport {
        public String name;
        public AccessStatus status;
        public Map<String, Boolean> conditions = new HashMap<String, Boolean>();

        private CapabilityReport() {
        }
    }
}

