/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script.slingshot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.search.RecordsManagementSearchService;
import org.alfresco.module.org_alfresco_module_rm.search.SavedSearchDetails;
import org.alfresco.service.cmr.site.SiteService;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RMSavedSearchesGet
extends DeclarativeWebScript {
    protected RecordsManagementSearchService recordsManagementSearchService;
    protected SiteService siteService;

    public void setRecordsManagementSearchService(RecordsManagementSearchService recordsManagementSearchService) {
        this.recordsManagementSearchService = recordsManagementSearchService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>(13);
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String siteId = (String)templateVars.get("site");
        if (siteId == null || siteId.length() == 0) {
            throw new WebScriptException(400, "Site id not provided.");
        }
        if (this.siteService.getSite(siteId) == null) {
            throw new WebScriptException(404, "Site not found.");
        }
        List<SavedSearchDetails> details = this.recordsManagementSearchService.getSavedSearches(siteId);
        ArrayList<Item> items = new ArrayList<Item>();
        for (SavedSearchDetails savedSearchDetails : details) {
            String name = savedSearchDetails.getName();
            String description = savedSearchDetails.getDescription();
            String query = savedSearchDetails.getCompatibility().getQuery();
            String params = savedSearchDetails.getCompatibility().getParams();
            String sort = savedSearchDetails.getCompatibility().getSort();
            Item item = new Item(name, description, query, params, sort);
            items.add(item);
        }
        model.put("savedSearches", items);
        return model;
    }

    public class Item {
        private String name;
        private String description;
        private String query;
        private String params;
        private String sort;

        public Item(String name, String description, String query, String params, String sort) {
            this.name = name;
            this.description = description;
            this.query = query;
            this.params = params;
            this.sort = sort;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getQuery() {
            return this.query;
        }

        public String getParams() {
            return this.params;
        }

        public String getSort() {
            return this.sort;
        }
    }
}

