/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.impl;

import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ImapModel;
import org.alfresco.module.org_alfresco_module_rm.action.RMActionExecuterAbstractBase;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipDefinition;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipDisplayName;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.util.FileCopyUtils;

public class SplitEmailAction
extends RMActionExecuterAbstractBase {
    private static final String MSG_NO_READ_MIME_MESSAGE = "rm.action.no-read-mime-message";
    private static final String MSG_EMAIL_DECLARED = "rm.action.email-declared";
    private static final String MSG_EMAIL_NOT_RECORD = "rm.action.email-not-record";
    private static final String REL_FROM = "Message";
    private static final String REL_TO = "Attachment";
    private static Log logger = LogFactory.getLog(SplitEmailAction.class);
    private RelationshipService relationshipService;
    private String relationshipUniqueName;

    protected RelationshipService getRelationshipService() {
        return this.relationshipService;
    }

    public void setRelationshipService(RelationshipService relationshipService) {
        this.relationshipService = relationshipService;
    }

    public void bootstrap() {
        Set<RelationshipDefinition> relationshipDefinitions = this.getRelationshipService().getRelationshipDefinitions();
        for (RelationshipDefinition relationshipDefinition : relationshipDefinitions) {
            RelationshipDisplayName displayName = relationshipDefinition.getDisplayName();
            String sourceText = displayName.getSourceText();
            String targetText = displayName.getTargetText();
            if (!sourceText.equals(REL_FROM) || !targetText.equals(REL_TO)) continue;
            this.relationshipUniqueName = relationshipDefinition.getUniqueName();
        }
        if (StringUtils.isBlank((CharSequence)this.relationshipUniqueName)) {
            RelationshipDefinition relationshipDefinition;
            RelationshipDisplayName displayName = new RelationshipDisplayName(REL_FROM, REL_TO);
            relationshipDefinition = this.getRelationshipService().createRelationshipDefinition(displayName);
            this.relationshipUniqueName = relationshipDefinition.getUniqueName();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        this.getNodeService().getType(actionedUponNodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("split email:" + String.valueOf(actionedUponNodeRef)));
        }
        if (!this.getRecordService().isRecord(actionedUponNodeRef)) throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_EMAIL_NOT_RECORD, (Object[])new Object[]{actionedUponNodeRef.toString()}));
        if (this.getRecordService().isDeclared(actionedUponNodeRef)) throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_EMAIL_DECLARED, (Object[])new Object[]{actionedUponNodeRef.toString()}));
        ChildAssociationRef parent = this.getNodeService().getPrimaryParent(actionedUponNodeRef);
        List refs = this.getNodeService().getTargetAssocs(actionedUponNodeRef, (QNamePattern)ImapModel.ASSOC_IMAP_ATTACHMENT);
        if (refs.size() > 0) {
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)"mail message has already been split - do nothing");
            return;
        }
        try {
            ContentReader reader = this.getContentService().getReader(actionedUponNodeRef, ContentModel.PROP_CONTENT);
            InputStream is = reader.getContentInputStream();
            MimeMessage mimeMessage = new MimeMessage(null, is);
            Object content = mimeMessage.getContent();
            if (!(content instanceof Multipart)) return;
            Multipart multipart = (Multipart)content;
            int n = multipart.getCount();
            for (int i = 0; i < n; ++i) {
                BodyPart part = multipart.getBodyPart(i);
                if (!"attachment".equalsIgnoreCase(part.getDisposition())) continue;
                this.createAttachment(actionedUponNodeRef, parent.getParentRef(), (Part)part);
            }
            return;
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_NO_READ_MIME_MESSAGE, (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
    }

    private void createAttachment(NodeRef messageNodeRef, NodeRef parentNodeRef, Part part) throws MessagingException, IOException {
        String fileName;
        block2: {
            fileName = part.getFileName();
            try {
                fileName = MimeUtility.decodeText((String)fileName);
            }
            catch (UnsupportedEncodingException e) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn((Object)("Cannot decode file name '" + fileName + "'"), (Throwable)e);
            }
        }
        Map messageProperties = this.getNodeService().getProperties(messageNodeRef);
        Object messageTitle = (String)messageProperties.get(ContentModel.PROP_NAME);
        messageTitle = messageTitle == null ? fileName : (String)messageTitle + " - " + fileName;
        ContentType contentType = new ContentType(part.getContentType());
        HashMap<QName, Object> docProps = new HashMap<QName, Object>(1);
        docProps.put(ContentModel.PROP_NAME, (String)messageTitle + " - " + fileName);
        docProps.put(ContentModel.PROP_TITLE, fileName);
        ChildAssociationRef attachmentRef = this.getNodeService().createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)fileName), ContentModel.TYPE_CONTENT, docProps);
        ContentWriter writer = this.getContentService().getWriter(attachmentRef.getChildRef(), ContentModel.PROP_CONTENT, true);
        writer.setMimetype(contentType.getBaseType());
        OutputStream os = writer.getContentOutputStream();
        FileCopyUtils.copy((InputStream)part.getInputStream(), (OutputStream)os);
        this.createRMReference(messageNodeRef, attachmentRef.getChildRef());
    }

    private void createRMReference(final NodeRef parentRef, final NodeRef childRef) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                SplitEmailAction.this.getRelationshipService().addRelationship(SplitEmailAction.this.relationshipUniqueName, parentRef, childRef);
                SplitEmailAction.this.getNodeService().createAssociation(parentRef, childRef, ImapModel.ASSOC_IMAP_ATTACHMENT);
                return null;
            }
        });
    }
}

