/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.email;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.email.CustomEmailMappingService;
import org.alfresco.module.org_alfresco_module_rm.email.CustomMapping;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.content.metadata.RFC822MetadataExtracter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class CustomEmailMappingServiceImpl
extends AbstractLifecycleBean
implements CustomEmailMappingService {
    private static Log logger = LogFactory.getLog(CustomEmailMappingServiceImpl.class);
    private static final NodeRef CONFIG_NODE_REF = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "rm_emailmapping_config");
    private static final NodeRef CONFIG_FOLDER_NODE_REF = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "rm_config_folder");
    private static final String CONFIG_NAME = "imapConfig.json";
    private static final CustomMapping[] DEFAULT_MAPPINGS = new CustomMapping[]{new CustomMapping("Date", "dod:dateReceived"), new CustomMapping("messageTo", "dod:address"), new CustomMapping("messageFrom", "dod:originator"), new CustomMapping("messageSent", "dod:publicationDate"), new CustomMapping("messageCc", "dod:otherAddress")};
    private RFC822MetadataExtracter extracter;
    private NodeService nodeService;
    private NamespacePrefixResolver nspr;
    private ContentService contentService;
    private TransactionService transactionService;
    private Set<CustomMapping> customMappings;
    private List<String> emailMappingKeys;

    public void setNamespacePrefixResolver(NamespacePrefixResolver nspr) {
        this.nspr = nspr;
    }

    public void setExtracter(RFC822MetadataExtracter extractor) {
        this.extracter = extractor;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setEmailMappingKeys(List<String> emailMappingKeys) {
        this.emailMappingKeys = emailMappingKeys;
    }

    @Override
    public Set<CustomMapping> getCustomMappings() {
        if (this.customMappings == null) {
            if (this.nodeService.exists(CONFIG_NODE_REF)) {
                this.customMappings = this.loadConfig();
            } else {
                this.customMappings = new HashSet<CustomMapping>();
                Map currentMapping = this.extracter.getCurrentMapping();
                for (Map.Entry entry : currentMapping.entrySet()) {
                    Set set = (Set)entry.getValue();
                    for (QName qname : set) {
                        CustomMapping value = new CustomMapping();
                        value.setFrom((String)entry.getKey());
                        QName resolvedQname = qname.getPrefixedQName(this.nspr);
                        value.setTo(resolvedQname.toPrefixString());
                        this.customMappings.add(value);
                    }
                }
                NodeRef oldConfigNode = this.getOldConfigNode();
                if (oldConfigNode != null) {
                    Set<CustomMapping> oldMappings = this.readOldConfig(oldConfigNode);
                    this.customMappings.addAll(oldMappings);
                }
                for (CustomMapping mapping : DEFAULT_MAPPINGS) {
                    this.customMappings.add(mapping);
                }
                this.saveConfig(this.customMappings);
            }
        }
        return this.customMappings;
    }

    @Override
    public void addCustomMapping(String from, String to) {
        if (StringUtils.isBlank((CharSequence)from) || StringUtils.isBlank((CharSequence)to)) {
            throw new AlfrescoRuntimeException("Invalid values for from/to.");
        }
        CustomMapping customMapping = new CustomMapping(from, to);
        Set<CustomMapping> customMappings = this.getCustomMappings();
        if (customMappings.contains(customMapping)) {
            throw new AlfrescoRuntimeException("Can not add custom email mapping, because duplicate mapping already exists.");
        }
        customMappings.add(customMapping);
        this.saveConfig(customMappings);
        this.updateExtractor();
    }

    @Override
    public void deleteCustomMapping(String from, String to) {
        if (StringUtils.isBlank((CharSequence)from) || StringUtils.isBlank((CharSequence)to)) {
            throw new AlfrescoRuntimeException("Invalid values for from/to.");
        }
        CustomMapping customMapping = new CustomMapping(from, to);
        Set<CustomMapping> customMappings = this.getCustomMappings();
        if (customMappings.contains(customMapping)) {
            customMappings.remove(customMapping);
            this.saveConfig(customMappings);
            this.updateExtractor();
        }
    }

    @Override
    public List<String> getEmailMappingKeys() {
        return this.emailMappingKeys;
    }

    @Override
    public void registerEMailMappingKey(String emailMappingKey) {
        ParameterCheck.mandatoryString((String)"emailMappingKey", (String)emailMappingKey);
        this.emailMappingKeys.add(emailMappingKey);
    }

    private void updateExtractor() {
        HashMap<String, HashSet<QName>> newMapping = new HashMap<String, HashSet<QName>>(17);
        for (CustomMapping mapping : this.getCustomMappings()) {
            QName newQName = QName.createQName((String)mapping.getTo(), (NamespacePrefixResolver)this.nspr);
            HashSet<QName> values = (HashSet<QName>)newMapping.get(mapping.getFrom());
            if (values == null) {
                values = new HashSet<QName>();
                newMapping.put(mapping.getFrom(), values);
            }
            values.add(newQName);
        }
        this.extracter.setMapping(newMapping);
    }

    private Set<CustomMapping> loadConfig() {
        HashSet<CustomMapping> result = new HashSet<CustomMapping>();
        ContentReader cr = this.contentService.getReader(CONFIG_NODE_REF, ContentModel.PROP_CONTENT);
        if (cr != null) {
            String text = cr.getContentString();
            try {
                JSONArray jsonArray = new JSONArray(new JSONTokener(text));
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject obj = jsonArray.getJSONObject(i);
                    CustomMapping mapping = new CustomMapping();
                    mapping.setFrom(obj.getString("from"));
                    mapping.setTo(obj.getString("to"));
                    result.add(mapping);
                }
            }
            catch (JSONException je) {
                throw new AlfrescoRuntimeException("Unable to read custom email configuration", (Throwable)je);
            }
        }
        return result;
    }

    private void saveConfig(Set<CustomMapping> customMappingsToSave) {
        if (!this.nodeService.exists(CONFIG_NODE_REF)) {
            HashMap<QName, String> properties = new HashMap<QName, String>(2);
            properties.put(ContentModel.PROP_NAME, CONFIG_NAME);
            properties.put(ContentModel.PROP_NODE_UUID, CONFIG_NODE_REF.getId());
            this.nodeService.createNode(CONFIG_FOLDER_NODE_REF, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)CONFIG_NAME), ContentModel.TYPE_CONTENT, properties);
        }
        JSONArray jsonMappings = new JSONArray();
        try {
            for (CustomMapping mapping : customMappingsToSave) {
                JSONObject obj = new JSONObject();
                obj.put("from", (Object)mapping.getFrom());
                obj.put("to", (Object)mapping.getTo());
                jsonMappings.put((Object)obj);
            }
        }
        catch (JSONException je) {
            throw new AlfrescoRuntimeException("Unable to create JSON email mapping configuration during save.", (Throwable)je);
        }
        ContentWriter writer = this.contentService.getWriter(CONFIG_NODE_REF, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(jsonMappings.toString());
    }

    protected void onBootstrap(ApplicationEvent event) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() {
                        try {
                            CustomEmailMappingServiceImpl.this.updateExtractor();
                        }
                        catch (RuntimeException e) {
                            if (logger.isWarnEnabled()) {
                                logger.warn((Object)e.getMessage());
                            }
                            CustomEmailMappingServiceImpl.this.customMappings = null;
                            throw e;
                        }
                        return null;
                    }
                };
                CustomEmailMappingServiceImpl.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    protected void onShutdown(ApplicationEvent arg0) {
    }

    private NodeRef getOldConfigNode() {
        NodeRef rootNode = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        return this.nodeService.getChildByName(rootNode, RecordsManagementModel.ASSOC_EMAIL_CONFIG, CONFIG_NAME);
    }

    private Set<CustomMapping> readOldConfig(NodeRef nodeRef) {
        HashSet<CustomMapping> newMappings = new HashSet<CustomMapping>();
        ContentReader cr = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        if (cr != null) {
            String text = cr.getContentString();
            try {
                JSONArray jsonArray = new JSONArray(new JSONTokener(text));
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject obj = jsonArray.getJSONObject(i);
                    CustomMapping mapping = new CustomMapping();
                    mapping.setFrom(obj.getString("from"));
                    mapping.setTo(obj.getString("to"));
                    newMappings.add(mapping);
                }
                return newMappings;
            }
            catch (JSONException je) {
                logger.warn((Object)"unable to read custom email configuration", (Throwable)je);
                return newMappings;
            }
        }
        return newMappings;
    }
}

