/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.recordcategories;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.node.getchildren.FilterProp;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.MultiPartRelationshipResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.impl.SearchTypesFactory;
import org.alfresco.rm.rest.api.model.RecordCategory;
import org.alfresco.rm.rest.api.model.RecordCategoryChild;
import org.alfresco.rm.rest.api.recordcategories.RecordCategoriesEntityResource;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.webscripts.servlet.FormData;

@RelationshipResource(name="children", entityResource=RecordCategoriesEntityResource.class, title="Children of a record category")
public class RecordCategoryChildrenRelation
implements RelationshipResourceAction.Read<RecordCategoryChild>,
RelationshipResourceAction.Create<RecordCategoryChild>,
MultiPartRelationshipResourceAction.Create<RecordCategoryChild> {
    private static final Set<String> LIST_RECORD_CATEGORY_CHILDREN_EQUALS_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("isRecordCategory", "isRecordFolder", "isClosed", "hasRetentionSchedule", "nodeType"));
    private FilePlanComponentsApiUtils apiUtils;
    private SearchTypesFactory searchTypesFactory;
    private FileFolderService fileFolderService;
    private ApiNodesModelFactory nodesModelFactory;
    private TransactionService transactionService;

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setSearchTypesFactory(SearchTypesFactory searchTypesFactory) {
        this.searchTypesFactory = searchTypesFactory;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @WebApiDescription(title="Return a paged list of record category children for the container identified by 'recordCategoryId'")
    public CollectionWithPagingInfo<RecordCategoryChild> readAll(String recordCategoryId, final Parameters parameters) {
        RMParameterCheck.checkNotBlank("recordCategoryId", recordCategoryId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        String relativePath = parameters.getParameter("relativePath");
        NodeRef parentNodeRef = this.apiUtils.lookupAndValidateNodeType(recordCategoryId, RecordsManagementModel.TYPE_RECORD_CATEGORY, relativePath, true);
        Set<QName> searchTypeQNames = this.searchTypesFactory.buildSearchTypesCategoriesEndpoint(parameters, LIST_RECORD_CATEGORY_CHILDREN_EQUALS_QUERY_PROPERTIES);
        Set<QName> assocTypeQNames = Collections.singleton(ContentModel.ASSOC_CONTAINS);
        List<FilterProp> filterProps = this.apiUtils.getListChildrenFilterProps(parameters, LIST_RECORD_CATEGORY_CHILDREN_EQUALS_QUERY_PROPERTIES);
        PagingResults pagingResults = this.fileFolderService.list(parentNodeRef, assocTypeQNames, searchTypeQNames, null, this.apiUtils.getSortProperties(parameters), filterProps, Util.getPagingRequest((Paging)parameters.getPaging()));
        final List page = pagingResults.getPage();
        final HashMap<String, UserInfo> mapUserInfo = new HashMap<String, UserInfo>();
        AbstractList<RecordCategoryChild> nodes = new AbstractList<RecordCategoryChild>(){

            @Override
            public RecordCategoryChild get(int index) {
                FileInfo info = (FileInfo)page.get(index);
                return RecordCategoryChildrenRelation.this.nodesModelFactory.createRecordCategoryChild(info, parameters, mapUserInfo, true);
            }

            @Override
            public int size() {
                return page.size();
            }
        };
        RecordCategory sourceEntity = null;
        if (parameters.includeSource()) {
            FileInfo info = this.fileFolderService.getFileInfo(parentNodeRef);
            sourceEntity = this.nodesModelFactory.createRecordCategory(info, parameters, mapUserInfo, true);
        }
        return CollectionWithPagingInfo.asPaged((Paging)parameters.getPaging(), (Collection)nodes, (boolean)pagingResults.hasMoreItems(), (Integer)((Integer)pagingResults.getTotalResultCount().getFirst()), sourceEntity);
    }

    @WebApiDescription(title="Create one (or more) nodes as children of a record category identified by 'recordCategoryId'")
    public List<RecordCategoryChild> create(String recordCategoryId, final List<RecordCategoryChild> nodeInfos, final Parameters parameters) {
        RMParameterCheck.checkNotBlank("recordCategoryId", recordCategoryId);
        ParameterCheck.mandatory((String)"nodeInfos", nodeInfos);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        final NodeRef parentNodeRef = this.apiUtils.lookupAndValidateNodeType(recordCategoryId, RecordsManagementModel.TYPE_RECORD_CATEGORY);
        ArrayList<RecordCategoryChild> result = new ArrayList<RecordCategoryChild>(nodeInfos.size());
        HashMap<String, UserInfo> mapUserInfo = new HashMap<String, UserInfo>();
        RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>>(){

            public List<NodeRef> execute() {
                LinkedList<NodeRef> createdNodes = new LinkedList<NodeRef>();
                for (RecordCategoryChild nodeInfo : nodeInfos) {
                    NodeRef nodeParent = parentNodeRef;
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{nodeInfo.getRelativePath()})) {
                        nodeParent = RecordCategoryChildrenRelation.this.apiUtils.lookupAndValidateRelativePath(parentNodeRef, nodeInfo.getRelativePath(), RecordsManagementModel.TYPE_RECORD_CATEGORY);
                    }
                    NodeRef newNode = RecordCategoryChildrenRelation.this.apiUtils.createRMNode(nodeParent, nodeInfo, parameters);
                    createdNodes.add(newNode);
                }
                return createdNodes;
            }
        };
        List createdNodes = (List)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
        for (NodeRef nodeInfo : createdNodes) {
            FileInfo info = this.fileFolderService.getFileInfo(nodeInfo);
            result.add(this.nodesModelFactory.createRecordCategoryChild(info, parameters, mapUserInfo, false));
        }
        return result;
    }

    public RecordCategoryChild create(String entityResourceId, FormData formData, Parameters parameters, WithResponse withResponse) {
        throw new IntegrityException("Uploading records into record categories is not allowed.", null);
    }
}

