/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script.slingshot.forms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanComponentKind;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RMMetaDataGet
extends DeclarativeWebScript {
    private static final String PARAM_NODEREF = "noderef";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_EXTENDED = "extended";
    private static final Pattern NODE_REF_PATTERN = Pattern.compile(".+://.+/.+");
    private static final Pattern QNAME_PATTERN = Pattern.compile(".+:[^=,]+");
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private FilePlanService filePlanService;

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        Matcher m;
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        boolean extended = false;
        String result = "NONE";
        String nodeRef = req.getParameter(PARAM_NODEREF);
        if (nodeRef == null || nodeRef.length() == 0) {
            QName qname;
            FilePlanComponentKind kind;
            Matcher m2;
            String type = req.getParameter(PARAM_TYPE);
            if (type != null && type.length() != 0 && type.indexOf(58) != -1 && (m2 = QNAME_PATTERN.matcher(type)).matches() && (kind = this.filePlanService.getFilePlanComponentKindFromType(qname = QName.createQName((String)type, (NamespacePrefixResolver)this.namespaceService))) != null) {
                result = kind.toString();
            }
        } else if (nodeRef.indexOf(58) != -1 && (m = NODE_REF_PATTERN.matcher(nodeRef)).matches()) {
            String extendedValue;
            NodeRef nodeRefObj = new NodeRef(nodeRef);
            FilePlanComponentKind kind = this.filePlanService.getFilePlanComponentKind(nodeRefObj);
            if (kind != null) {
                result = kind.toString();
            }
            if ((extendedValue = req.getParameter(PARAM_EXTENDED)) != null && extendedValue.length() != 0 && (extended = Boolean.parseBoolean(extendedValue))) {
                model.put("aspects", this.getAspects(nodeRefObj));
            }
        }
        model.put("kind", result);
        model.put(PARAM_EXTENDED, extended);
        return model;
    }

    public List<Aspect> getAspects(NodeRef nodeRef) {
        Set qnames = this.nodeService.getAspects(nodeRef);
        ArrayList<Aspect> aspects = new ArrayList<Aspect>(qnames.size());
        for (QName qname : qnames) {
            aspects.add(new Aspect(qname));
        }
        return aspects;
    }

    public class Aspect
    extends QNameBean {
        private static final long serialVersionUID = -6448182941386934326L;

        public Aspect(QName name) {
            super(name);
        }
    }

    public class QNameBean
    implements Serializable {
        private static final long serialVersionUID = 6982292337846270774L;
        protected QName name;

        public QNameBean(QName name) {
            this.name = name;
        }

        public String getName() {
            return this.name.toString();
        }

        public String getPrefixedName() {
            return this.name.toPrefixString((NamespacePrefixResolver)RMMetaDataGet.this.namespaceService);
        }

        public String toString() {
            return this.getName();
        }
    }
}

