/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.version;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.test.integration.version.RecordableVersionsBaseTest;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.module.org_alfresco_module_rm.test.util.TestModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionType;

public class AdHocRecordableVersionsTest
extends RecordableVersionsBaseTest {
    public void testRecordAdHocVersionNoPolicy() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.dmCollaborator){
            private Map<String, Serializable> versionProperties;

            @Override
            public void given() throws Exception {
                this.versionProperties = new HashMap<String, Serializable>(4);
                this.versionProperties.put("description", (Serializable)((Object)"description"));
                this.versionProperties.put("versionType", (Serializable)VersionType.MINOR);
                this.versionProperties.put("recordable-version", Boolean.valueOf(true));
                this.versionProperties.put("file-plan", (Serializable)AdHocRecordableVersionsTest.this.filePlan);
            }

            @Override
            public void when() {
                AdHocRecordableVersionsTest.this.versionService.createVersion(AdHocRecordableVersionsTest.this.dmDocument, this.versionProperties);
            }

            @Override
            public void then() {
                AdHocRecordableVersionsTest.this.checkRecordedVersion(AdHocRecordableVersionsTest.this.dmDocument, "description", "0.1");
            }
        });
    }

    public void testRecordableVersionFalseNoPolicy() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.dmCollaborator){
            private Map<String, Serializable> versionProperties;

            @Override
            public void given() throws Exception {
                this.versionProperties = new HashMap<String, Serializable>(4);
                this.versionProperties.put("description", (Serializable)((Object)"description"));
                this.versionProperties.put("versionType", (Serializable)VersionType.MINOR);
                this.versionProperties.put("recordable-version", Boolean.valueOf(false));
                this.versionProperties.put("file-plan", (Serializable)AdHocRecordableVersionsTest.this.filePlan);
            }

            @Override
            public void when() {
                AdHocRecordableVersionsTest.this.versionService.createVersion(AdHocRecordableVersionsTest.this.dmDocument, this.versionProperties);
            }

            @Override
            public void then() {
                AdHocRecordableVersionsTest.this.checkNotRecordedAspect(AdHocRecordableVersionsTest.this.dmDocument, "description", "0.1");
            }
        });
    }

    public void testNoFilePlan() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AlfrescoRuntimeException.class, this.dmCollaborator){
            private Map<String, Serializable> versionProperties;

            @Override
            public void given() throws Exception {
                this.versionProperties = new HashMap<String, Serializable>(4);
                this.versionProperties.put("description", (Serializable)((Object)"description"));
                this.versionProperties.put("versionType", (Serializable)VersionType.MINOR);
                this.versionProperties.put("recordable-version", Boolean.valueOf(true));
            }

            @Override
            public void when() {
                AdHocRecordableVersionsTest.this.versionService.createVersion(AdHocRecordableVersionsTest.this.dmDocument, this.versionProperties);
            }

            @Override
            public void then() {
                AdHocRecordableVersionsTest.this.checkRecordedVersion(AdHocRecordableVersionsTest.this.dmDocument, "description", "0.1");
            }
        });
    }

    public void testRecordedVersionWithRecordMetadataAspect() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.dmCollaborator){
            private Map<String, Serializable> versionProperties;

            @Override
            public void given() throws Exception {
                this.versionProperties = new HashMap<String, Serializable>(4);
                this.versionProperties.put("description", (Serializable)((Object)"description"));
                this.versionProperties.put("versionType", (Serializable)VersionType.MINOR);
                this.versionProperties.put("recordable-version", Boolean.valueOf(true));
                this.versionProperties.put("file-plan", (Serializable)AdHocRecordableVersionsTest.this.filePlan);
            }

            @Override
            public void when() {
                final Version version = AdHocRecordableVersionsTest.this.versionService.createVersion(AdHocRecordableVersionsTest.this.dmDocument, this.versionProperties);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        NodeRef record = AdHocRecordableVersionsTest.this.recordableVersionService.getVersionRecord(version);
                        TestCase.assertNotNull((Object)record);
                        AdHocRecordableVersionsTest.this.recordService.addRecordType(record, TestModel.ASPECT_RECORD_METADATA);
                        AdHocRecordableVersionsTest.this.nodeService.setProperty(record, TestModel.PROPERTY_RECORD_METADATA, (Serializable)((Object)"Peter Wetherall"));
                        return null;
                    }
                }, (String)AuthenticationUtil.getAdminUserName());
            }

            @Override
            public void then() {
                AdHocRecordableVersionsTest.this.checkRecordedVersion(AdHocRecordableVersionsTest.this.dmDocument, "description", "0.1");
            }
        });
    }
}

