/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.version;

import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementCustomModel;
import org.alfresco.module.org_alfresco_module_rm.relationship.Relationship;
import org.alfresco.module.org_alfresco_module_rm.test.integration.version.RecordableVersionsBaseTest;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionModel;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionPolicy;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.util.PropertyMap;

public class AutoRecordableVersionsTest
extends RecordableVersionsBaseTest {
    public static final String MY_NEW_CONTENT = "this is some new content that I have changed to trigger auto version";

    public void testAutoVersionRecordAllRevisions() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.dmCollaborator){

            @Override
            public void given() throws Exception {
                PropertyMap recordableVersionProperties = new PropertyMap(1);
                recordableVersionProperties.put((Object)RecordableVersionModel.PROP_RECORDABLE_VERSION_POLICY, (Object)RecordableVersionPolicy.ALL);
                recordableVersionProperties.put((Object)RecordableVersionModel.PROP_FILE_PLAN, (Object)AutoRecordableVersionsTest.this.filePlan);
                AutoRecordableVersionsTest.this.nodeService.addAspect(AutoRecordableVersionsTest.this.dmDocument, RecordableVersionModel.ASPECT_VERSIONABLE, (Map)recordableVersionProperties);
                PropertyMap versionableProperties = new PropertyMap(1);
                versionableProperties.put((Object)ContentModel.PROP_INITIAL_VERSION, (Object)false);
                AutoRecordableVersionsTest.this.nodeService.addAspect(AutoRecordableVersionsTest.this.dmDocument, ContentModel.ASPECT_VERSIONABLE, (Map)versionableProperties);
            }

            @Override
            public void when() {
                ContentWriter writer = AutoRecordableVersionsTest.this.contentService.getWriter(AutoRecordableVersionsTest.this.dmDocument, ContentModel.PROP_CONTENT, true);
                writer.putContent(AutoRecordableVersionsTest.MY_NEW_CONTENT);
            }

            @Override
            public void then() {
                AutoRecordableVersionsTest.this.checkRecordedVersion(AutoRecordableVersionsTest.this.dmDocument, null, "0.1");
            }
        });
    }

    public void testVersionRecordsRelated() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.dmCollaborator, false){

            @Override
            public void given() throws Exception {
                AutoRecordableVersionsTest.this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

                    @Override
                    public void runImpl() throws Exception {
                        PropertyMap recordableVersionProperties = new PropertyMap(1);
                        recordableVersionProperties.put((Object)RecordableVersionModel.PROP_RECORDABLE_VERSION_POLICY, (Object)RecordableVersionPolicy.ALL);
                        recordableVersionProperties.put((Object)RecordableVersionModel.PROP_FILE_PLAN, (Object)AutoRecordableVersionsTest.this.filePlan);
                        AutoRecordableVersionsTest.this.nodeService.addAspect(AutoRecordableVersionsTest.this.dmDocument, RecordableVersionModel.ASPECT_VERSIONABLE, (Map)recordableVersionProperties);
                        PropertyMap versionableProperties = new PropertyMap(1);
                        versionableProperties.put((Object)ContentModel.PROP_INITIAL_VERSION, (Object)false);
                        AutoRecordableVersionsTest.this.nodeService.addAspect(AutoRecordableVersionsTest.this.dmDocument, ContentModel.ASPECT_VERSIONABLE, (Map)versionableProperties);
                    }
                });
            }

            @Override
            public void when() {
                this.updateContent();
                this.updateContent();
                this.updateContent();
            }

            @Override
            public void then() {
                AutoRecordableVersionsTest.this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

                    @Override
                    public void runImpl() throws Exception {
                        AutoRecordableVersionsTest.this.checkRecordedVersion(AutoRecordableVersionsTest.this.dmDocument, null, "0.3");
                        Version version = AutoRecordableVersionsTest.this.versionService.getCurrentVersion(AutoRecordableVersionsTest.this.dmDocument);
                        NodeRef record = AutoRecordableVersionsTest.this.recordableVersionService.getVersionRecord(version);
                        boolean foundPrevious = false;
                        Set relationships = AutoRecordableVersionsTest.this.relationshipService.getRelationshipsFrom(record);
                        TestCase.assertNotNull((Object)relationships);
                        TestCase.assertEquals((int)1, (int)relationships.size());
                        for (Relationship relationship : relationships) {
                            if (!relationship.getUniqueName().equals(RecordsManagementCustomModel.CUSTOM_REF_VERSIONS.getLocalName())) continue;
                            NodeRef previousVersionRecord = relationship.getTarget();
                            TestCase.assertNotNull((Object)previousVersionRecord);
                            foundPrevious = true;
                        }
                        TestCase.assertTrue((boolean)foundPrevious);
                    }
                });
            }

            private void updateContent() {
                AutoRecordableVersionsTest.this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

                    @Override
                    public void runImpl() throws Exception {
                        ContentWriter writer = AutoRecordableVersionsTest.this.contentService.getWriter(AutoRecordableVersionsTest.this.dmDocument, ContentModel.PROP_CONTENT, true);
                        writer.putContent(AutoRecordableVersionsTest.MY_NEW_CONTENT);
                    }
                });
            }
        });
    }
}

