/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipService;
import org.alfresco.module.org_alfresco_module_rm.script.AbstractRmWebScript;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.util.WebScriptUtils;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CustomRefDelete
extends AbstractRmWebScript {
    private static final String REF_ID = "refId";
    private static final String ST = "st";
    private static final String SI = "si";
    private RelationshipService relationshipService;
    private RuleService ruleService;

    protected RelationshipService getRelationshipService() {
        return this.relationshipService;
    }

    public void setRelationshipService(RelationshipService relationshipService) {
        this.relationshipService = relationshipService;
    }

    protected RuleService getRuleService() {
        return this.ruleService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        try {
            this.getRuleService().disableRuleType("outbound");
            this.removeCustomRelationship(req);
            model.put("success", true);
        }
        finally {
            this.getRuleService().enableRuleType("outbound");
        }
        return model;
    }

    private void removeCustomRelationship(WebScriptRequest req) {
        String uniqueName = WebScriptUtils.getRequestParameterValue(req, REF_ID);
        NodeRef source = this.parseRequestForNodeRef(req);
        NodeRef target = this.getTargetNode(req);
        this.getRelationshipService().removeRelationship(uniqueName, source, target);
        this.getRelationshipService().removeRelationship(uniqueName, target, source);
    }

    private NodeRef getTargetNode(WebScriptRequest req) {
        String storeType = req.getParameter(ST);
        String storeId = req.getParameter(SI);
        String nodeId = req.getParameter("id");
        NodeRef targetNode = new NodeRef(storeType, storeId, nodeId);
        if (!this.getNodeService().exists(targetNode)) {
            throw new WebScriptException(404, "Unable to find the target node: '" + targetNode.toString() + "'.");
        }
        return targetNode;
    }
}

