/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v22;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.dod5015.DOD5015Model;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.patch.AbstractModulePatch;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class RMv22DODModelSeparationModulePatch
extends AbstractModulePatch
implements RecordsManagementModel {
    private static final long BATCH_SIZE = 100000L;
    private boolean convertToStandardFilePlan = false;
    private PatchDAO patchDAO;
    private NodeDAO nodeDAO;
    private QName[] qnames = new QName[]{DOD5015Model.PROP_ORIGINATOR, DOD5015Model.PROP_ORIGINATING_ORGANIZATION, DOD5015Model.PROP_PUBLICATION_DATE, DOD5015Model.PROP_MEDIA_TYPE, DOD5015Model.PROP_FORMAT, DOD5015Model.PROP_DATE_RECEIVED, DOD5015Model.PROP_ADDRESS, DOD5015Model.PROP_OTHER_ADDRESS};

    public void setConvertToStandardFilePlan(boolean convertToStandardFilePlan) {
        this.convertToStandardFilePlan = convertToStandardFilePlan;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    @Override
    public void applyInternal() {
        if (!this.convertToStandardFilePlan) {
            Long maxNodeId = this.nodeDAO.getMaxNodeId();
            long recordCount = this.patchDAO.getCountNodesWithAspects(Collections.singleton(ASPECT_RECORD));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("   ... updating " + recordCount + " records in batches of 100000"));
            }
            int completed = 0;
            Long i = 0L;
            while (i < maxNodeId) {
                final Long finali = i;
                Integer batchCount = (Integer)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){
                    int batchCount = 0;

                    public Integer execute() throws Throwable {
                        RMv22DODModelSeparationModulePatch.this.nodeDAO.getNodesWithAspects(Collections.singleton(RecordsManagementModel.ASPECT_RECORD), finali, Long.valueOf(finali + 100000L), new NodeDAO.NodeRefQueryCallback(){

                            public boolean handle(Pair<Long, NodeRef> nodePair) {
                                Map properties = RMv22DODModelSeparationModulePatch.this.nodeDAO.getNodeProperties((Long)nodePair.getFirst());
                                boolean changed = false;
                                for (QName qname : RMv22DODModelSeparationModulePatch.this.qnames) {
                                    QName origional = QName.createQName((String)"http://www.alfresco.org/model/recordsmanagement/1.0", (String)qname.getLocalName());
                                    if (!properties.containsKey(origional)) continue;
                                    Serializable value = (Serializable)properties.get(origional);
                                    properties.put(qname, value);
                                    properties.remove(origional);
                                    changed = true;
                                }
                                if (changed) {
                                    RMv22DODModelSeparationModulePatch.this.nodeDAO.setNodeProperties((Long)nodePair.getFirst(), properties);
                                }
                                RMv22DODModelSeparationModulePatch.this.nodeDAO.addNodeAspects((Long)nodePair.getFirst(), Collections.singleton(DOD5015Model.ASPECT_DOD_5015_RECORD));
                                ++batchCount;
                                return true;
                            }
                        });
                        return this.batchCount;
                    }
                }, false, true);
                if (batchCount != 0) {
                    completed += batchCount.intValue();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("   ... completed " + completed + " of " + recordCount));
                    }
                }
                i = i + 100000L;
            }
        }
    }
}

