/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.alfresco.module.org_alfresco_module_rm.test.util.FPUtils;
import org.junit.Assert;
import org.junit.Test;

public class FPUtilsUnitTest {
    @Test
    public void asListShouldProduceList() {
        List l = FPUtils.asListFrom(() -> "hello", () -> "world", () -> {
            String s1 = "abc";
            String s2 = "xyz";
            return s1 + s2;
        });
        Assert.assertEquals(Arrays.asList("hello", "world", "abcxyz"), l);
    }

    @Test
    public void asListShouldWorkForEmptyVarArgs() {
        Assert.assertEquals(Collections.emptyList(), FPUtils.asListFrom(new Supplier[0]));
    }

    @Test
    public void asSetShouldProduceSet() {
        Assert.assertEquals(new HashSet<String>(Arrays.asList("hello", "world")), FPUtils.asSet("hello", "hello", "world"));
    }

    @Test
    public void asSetFromShouldWork() {
        Set s = FPUtils.asSetFrom(() -> "hello", () -> "hello", () -> "world", () -> {
            String s1 = "wo";
            String s2 = "rld";
            return s1 + s2;
        });
        Assert.assertEquals(new HashSet<String>(Arrays.asList("hello", "world")), s);
    }
}

